/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.wizard.dialog;

import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.api.statistics.map.StatisticsResult;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FirstSaveDataWizardPage
extends WizardPage {
    private Text txtEclipseProjectName;
    private Text txtProjectName;
    private Text txtStorer;
    private Text dtStorerDate;
    private Combo txtRepositoryType;
    private Text txtRepositoryRevesion;
    private Text txtRepositoryPath;
    private Text txtDetailed;

    public FirstSaveDataWizardPage(String pageName) {
        super(pageName);
    }

    public FirstSaveDataWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void init(Statistician statistician) {
        this.txtEclipseProjectName.setText(statistician.getProject().getEclipseProjectName());
        this.txtProjectName.setText(statistician.getProject().getProjectName());
        this.txtStorer.setText(statistician.getProject().getStorer());
        this.txtRepositoryType.setText(statistician.getProject().getRepositoryType().trim().toUpperCase());
        this.txtRepositoryRevesion.setText(statistician.getProject().getRepositoryRevision());
        this.txtRepositoryPath.setText(statistician.getProject().getRepositoryPath());
        StringBuffer detailed = new StringBuffer();
        StatisticsResult result = statistician.getResult();
        ObjectStatisticsResult objectResult = result.getBMStatisticsResult();
        if (objectResult != null) {
            detailed.append("bm\uff1a");
            detailed = this.fillDetailed(detailed, objectResult);
        }
        if ((objectResult = result.getSreenStatisticsResult()) != null) {
            detailed.append("\nscreen\uff1a");
            detailed = this.fillDetailed(detailed, objectResult);
        }
        if ((objectResult = result.getSVCStatisticsResult()) != null) {
            detailed.append("\nsvc\uff1a");
            detailed = this.fillDetailed(detailed, objectResult);
        }
        this.txtDetailed.setText(detailed.toString());
    }

    private StringBuffer fillDetailed(StringBuffer detailed, ObjectStatisticsResult objectResult) {
        detailed.append("\n\u6587\u4ef6\u5927\u5c0f\uff1a" + this.conversion(objectResult.getTotalFileSize()));
        detailed.append("\n\u6587\u4ef6\u6700\u5927\u503c\uff1a" + this.conversion(objectResult.getMaxFileSize()));
        detailed.append("\n\u6587\u4ef6\u6700\u5c0f\u503c\uff1a" + this.conversion(objectResult.getMinFileSize()));
        detailed.append("\n\u6587\u4ef6\u5e73\u5747\u503c\uff1a" + this.conversion(objectResult.getAverageFileSize()));
        detailed.append("\n\u811a\u672c\u5927\u5c0f\uff1a" + this.conversion(objectResult.getTotalScriptSize()));
        detailed.append("\n\u811a\u672c\u6700\u5927\u503c\uff1a" + this.conversion(objectResult.getMaxScriptSize()));
        detailed.append("\n\u811a\u672c\u6700\u5c0f\u503c\uff1a" + this.conversion(objectResult.getMinScriptSize()));
        detailed.append("\n\u811a\u672c\u5e73\u5747\u503c\uff1a" + this.conversion(objectResult.getAverageScriptSize()));
        detailed.append("\n\u6807\u7b7e\u6570\u91cf\uff1a" + objectResult.getTotalTagCount());
        detailed.append("\n\u6807\u7b7e\u6570\u91cf\u6700\u5927\u503c\uff1a" + objectResult.getMaxTagCount());
        detailed.append("\n\u6807\u7b7e\u6570\u91cf\u6700\u5c0f\u503c\uff1a" + objectResult.getMinTagCount());
        detailed.append("\n\u6807\u7b7e\u6570\u91cf\u5e73\u5747\u503c\uff1a" + objectResult.getAverageTagCount());
        return detailed;
    }

    public void createControl(Composite parent) {
        this.setTitle("\u4fdd\u5b58\u6570\u636e");
        this.setDescription("\u5c06\u7edf\u8ba1\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label lblEclipseProjectName = new Label(container, 0);
        lblEclipseProjectName.setText("eclipse\u5de5\u7a0b\u540d\uff1a");
        GridData gbEclipseProjectName = new GridData(768);
        this.txtEclipseProjectName = new Text(container, 8);
        this.txtEclipseProjectName.setLayoutData((Object)gbEclipseProjectName);
        Label lblProjectName = new Label(container, 0);
        lblProjectName.setText("\u9879\u76ee\u540d\uff1a");
        GridData gbProjectName = new GridData(768);
        this.txtProjectName = new Text(container, 2048);
        this.txtProjectName.setLayoutData((Object)gbProjectName);
        this.txtProjectName.setFocus();
        Label lblRepositoryType = new Label(container, 0);
        lblRepositoryType.setText("\u8d44\u6e90\u5e93\u7c7b\u578b\uff1a");
        GridData gdRepositoryType = new GridData(768);
        this.txtRepositoryType = new Combo(container, 2048);
        this.txtRepositoryType.setLayoutData((Object)gdRepositoryType);
        this.txtRepositoryType.add("CVS");
        this.txtRepositoryType.add("SVN");
        Label lblRepositoryRevesion = new Label(container, 0);
        lblRepositoryRevesion.setText("\u8d44\u6e90\u5e93\u7248\u672c\uff1a");
        GridData gdRepositoryRevesion = new GridData(768);
        this.txtRepositoryRevesion = new Text(container, 2048);
        this.txtRepositoryRevesion.setLayoutData((Object)gdRepositoryRevesion);
        Label lblRepositoryPath = new Label(container, 0);
        lblRepositoryPath.setText("\u8d44\u6e90\u5e93\u8def\u5f84\uff1a");
        GridData gdRepositoryPath = new GridData(768);
        this.txtRepositoryPath = new Text(container, 2048);
        this.txtRepositoryPath.setLayoutData((Object)gdRepositoryPath);
        Label lblStorer = new Label(container, 0);
        lblStorer.setText("\u4fdd\u5b58\u4eba\uff1a");
        GridData gdStorer = new GridData(768);
        this.txtStorer = new Text(container, 2048);
        this.txtStorer.setLayoutData((Object)gdStorer);
        Label lblStorerDate = new Label(container, 0);
        lblStorerDate.setText("\u4fdd\u5b58\u65f6\u95f4\uff1a");
        GridData gdCalendar = new GridData(768);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd");
        this.dtStorerDate = new Text(container, 8);
        this.dtStorerDate.setText(sd.format(new Date()));
        this.dtStorerDate.setLayoutData((Object)gdCalendar);
        GridData gdLabelDetailed = new GridData();
        gdLabelDetailed.verticalAlignment = 128;
        Label lblDetailed = new Label(container, 0);
        lblDetailed.setText("\u8be6\u7ec6\u4fe1\u606f\uff1a");
        lblDetailed.setLayoutData((Object)gdLabelDetailed);
        GridData gdDetailed = new GridData(1808);
        gdDetailed.heightHint = 200;
        this.txtDetailed = new Text(container, 2824);
        this.txtDetailed.setLayoutData((Object)gdDetailed);
        this.setControl((Control)container);
    }

    private String conversion(int num) {
        String value = Integer.toString(num);
        DecimalFormat df = new DecimalFormat("0.00");
        double v = Double.parseDouble(value);
        if (value.length() > 3 && value.length() <= 6) {
            return String.valueOf(df.format(v /= 1024.0)) + " KB";
        }
        if (value.length() > 6) {
            return String.valueOf(df.format(v /= 1048576.0)) + " MB";
        }
        return String.valueOf((int)v) + " Byte";
    }

    public String getProjectName() {
        return this.txtProjectName.getText().trim();
    }

    public String getStorer() {
        return this.txtStorer.getText().trim();
    }

    public String getRepositoryType() {
        return this.txtRepositoryType.getText().trim();
    }

    public String getRepositoryRevesion() {
        return this.txtRepositoryRevesion.getText().trim();
    }

    public String getRepositoryPath() {
        return this.txtRepositoryPath.getText().trim();
    }
}

