/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.fault;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.model.CheckedException;
import com.sun.xml.internal.ws.api.model.ExceptionType;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.fault.CodeType;
import com.sun.xml.internal.ws.fault.DetailType;
import com.sun.xml.internal.ws.fault.ExceptionBean;
import com.sun.xml.internal.ws.fault.ReasonType;
import com.sun.xml.internal.ws.fault.SOAP11Fault;
import com.sun.xml.internal.ws.fault.SOAP12Fault;
import com.sun.xml.internal.ws.fault.SubcodeType;
import com.sun.xml.internal.ws.message.jaxb.JAXBMessage;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPFaultBuilder {
    private static final JAXBRIContext JAXB_CONTEXT;
    private static final Logger logger;
    public static boolean captureStackTrace;
    static final String CAPTURE_STACK_TRACE_PROPERTY;

    abstract DetailType getDetail();

    abstract void setDetail(DetailType var1);

    abstract String getFaultString();

    public Throwable createException(Map<QName, CheckedExceptionImpl> map) throws JAXBException {
        DetailType detailType = this.getDetail();
        Node node = null;
        if (detailType != null) {
            node = detailType.getDetail(0);
        }
        if (node == null || map == null) {
            return this.attachServerException(this.getProtocolException());
        }
        QName qName = new QName(node.getNamespaceURI(), node.getLocalName());
        CheckedExceptionImpl checkedExceptionImpl = map.get(qName);
        if (checkedExceptionImpl == null) {
            return this.attachServerException(this.getProtocolException());
        }
        if (checkedExceptionImpl.getExceptionType().equals((Object)ExceptionType.UserDefined)) {
            return this.attachServerException(this.createUserDefinedException(checkedExceptionImpl));
        }
        Class clazz = checkedExceptionImpl.getExceptionClass();
        try {
            Constructor constructor = clazz.getConstructor(String.class, (Class)checkedExceptionImpl.getDetailType().type);
            Exception exception = (Exception)constructor.newInstance(this.getFaultString(), this.getJAXBObject(node, checkedExceptionImpl));
            return this.attachServerException(exception);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    @NotNull
    public static Message createSOAPFaultMessage(@NotNull SOAPVersion sOAPVersion, @NotNull ProtocolException protocolException, @Nullable QName qName) {
        Object object = SOAPFaultBuilder.getFaultDetail(null, protocolException);
        if (sOAPVersion == SOAPVersion.SOAP_12) {
            return SOAPFaultBuilder.createSOAP12Fault(sOAPVersion, protocolException, object, null, qName);
        }
        return SOAPFaultBuilder.createSOAP11Fault(sOAPVersion, protocolException, object, null, qName);
    }

    public static Message createSOAPFaultMessage(SOAPVersion sOAPVersion, CheckedExceptionImpl checkedExceptionImpl, Throwable throwable) {
        Object object = SOAPFaultBuilder.getFaultDetail(checkedExceptionImpl, throwable);
        if (sOAPVersion == SOAPVersion.SOAP_12) {
            return SOAPFaultBuilder.createSOAP12Fault(sOAPVersion, throwable, object, checkedExceptionImpl, null);
        }
        return SOAPFaultBuilder.createSOAP11Fault(sOAPVersion, throwable, object, checkedExceptionImpl, null);
    }

    public static Message createSOAPFaultMessage(SOAPVersion sOAPVersion, String string, QName qName) {
        if (qName == null) {
            qName = SOAPFaultBuilder.getDefaultFaultCode(sOAPVersion);
        }
        return SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, string, qName, null);
    }

    public static Message createSOAPFaultMessage(SOAPVersion sOAPVersion, SOAPFault sOAPFault) {
        switch (sOAPVersion) {
            case SOAP_11: {
                return JAXBMessage.create(JAXB_CONTEXT, (Object)new SOAP11Fault(sOAPFault), sOAPVersion);
            }
            case SOAP_12: {
                return JAXBMessage.create(JAXB_CONTEXT, (Object)new SOAP12Fault(sOAPFault), sOAPVersion);
            }
        }
        throw new AssertionError();
    }

    private static Message createSOAPFaultMessage(SOAPVersion sOAPVersion, String string, QName qName, Element element) {
        switch (sOAPVersion) {
            case SOAP_11: {
                return JAXBMessage.create(JAXB_CONTEXT, (Object)new SOAP11Fault(qName, string, null, element), sOAPVersion);
            }
            case SOAP_12: {
                return JAXBMessage.create(JAXB_CONTEXT, (Object)new SOAP12Fault(qName, string, element), sOAPVersion);
            }
        }
        throw new AssertionError();
    }

    final void captureStackTrace(@Nullable Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (!captureStackTrace) {
            return;
        }
        try {
            Document document = DOMUtil.createDom();
            ExceptionBean.marshal(throwable, document);
            DetailType detailType = this.getDetail();
            if (detailType == null) {
                detailType = new DetailType();
                this.setDetail(detailType);
            }
            detailType.getDetails().add(document.getDocumentElement());
        }
        catch (JAXBException jAXBException) {
            logger.log(Level.WARNING, "Unable to capture the stack trace into XML", jAXBException);
        }
    }

    private <T extends Throwable> T attachServerException(T t) {
        DetailType detailType = this.getDetail();
        if (detailType == null) {
            return t;
        }
        for (Element element : detailType.getDetails()) {
            if (!ExceptionBean.isStackTraceXml(element)) continue;
            try {
                t.initCause(ExceptionBean.unmarshal(element));
            }
            catch (JAXBException jAXBException) {
                logger.log(Level.WARNING, "Unable to read the capture stack trace in the fault", jAXBException);
            }
            return t;
        }
        return t;
    }

    protected abstract Throwable getProtocolException();

    private Object getJAXBObject(Node node, CheckedException checkedException) throws JAXBException {
        Bridge bridge = checkedException.getBridge();
        return bridge.unmarshal(node);
    }

    private Exception createUserDefinedException(CheckedExceptionImpl checkedExceptionImpl) {
        Class clazz = checkedExceptionImpl.getExceptionClass();
        try {
            Field[] fieldArray;
            Constructor constructor = clazz.getConstructor(String.class);
            Object t = constructor.newInstance(this.getFaultString());
            Node node = this.getDetail().getDetails().get(0);
            Object object = this.getJAXBObject(node, checkedExceptionImpl);
            for (Field field : fieldArray = object.getClass().getFields()) {
                Method method = clazz.getMethod(SOAPFaultBuilder.getWriteMethod(field), new Class[0]);
                method.invoke(t, field.get(object));
            }
            throw (Exception)t;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private static String getWriteMethod(Field field) {
        return "set" + StringUtils.capitalize(field.getName());
    }

    private static Object getFaultDetail(CheckedExceptionImpl checkedExceptionImpl, Throwable throwable) {
        if (checkedExceptionImpl == null) {
            return null;
        }
        if (checkedExceptionImpl.getExceptionType().equals((Object)ExceptionType.UserDefined)) {
            return SOAPFaultBuilder.createDetailFromUserDefinedException(checkedExceptionImpl, throwable);
        }
        try {
            Method method = throwable.getClass().getMethod("getFaultInfo", new Class[0]);
            return method.invoke(throwable, new Object[0]);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    private static Object createDetailFromUserDefinedException(CheckedExceptionImpl checkedExceptionImpl, Object object) {
        Class clazz = checkedExceptionImpl.getDetailBean();
        Field[] fieldArray = clazz.getDeclaredFields();
        try {
            Object t = clazz.newInstance();
            for (Field field : fieldArray) {
                Method method = object.getClass().getMethod(SOAPFaultBuilder.getReadMethod(field), new Class[0]);
                Method method2 = clazz.getMethod(SOAPFaultBuilder.getWriteMethod(field), method.getReturnType());
                method2.invoke(t, method.invoke(object, new Object[0]));
            }
            return t;
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    private static String getReadMethod(Field field) {
        if (field.getType().isAssignableFrom(Boolean.TYPE)) {
            return "is" + StringUtils.capitalize(field.getName());
        }
        return "get" + StringUtils.capitalize(field.getName());
    }

    private static Message createSOAP11Fault(SOAPVersion sOAPVersion, Throwable throwable, Object object, CheckedExceptionImpl checkedExceptionImpl, QName qName) {
        Object object2;
        Object object3;
        SOAPFaultException sOAPFaultException = null;
        String string = null;
        String string2 = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable;
        } else if (throwable2 != null && throwable2 instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable.getCause();
        }
        if (sOAPFaultException != null) {
            object3 = sOAPFaultException.getFault().getFaultCodeAsQName();
            if (object3 != null) {
                qName = object3;
            }
            string = sOAPFaultException.getFault().getFaultString();
            string2 = sOAPFaultException.getFault().getFaultActor();
        }
        if (qName == null) {
            qName = SOAPFaultBuilder.getDefaultFaultCode(sOAPVersion);
        }
        if (string == null && (string = throwable.getMessage()) == null) {
            string = throwable.toString();
        }
        object3 = null;
        if (object == null && sOAPFaultException != null) {
            object3 = sOAPFaultException.getFault().getDetail();
        } else if (checkedExceptionImpl != null) {
            try {
                object2 = new DOMResult();
                checkedExceptionImpl.getBridge().marshal(object, (Result)object2);
                object3 = (Element)((DOMResult)object2).getNode().getFirstChild();
            }
            catch (JAXBException jAXBException) {
                string = throwable.getMessage();
                qName = SOAPFaultBuilder.getDefaultFaultCode(sOAPVersion);
            }
        }
        object2 = new SOAP11Fault(qName, string, string2, (Element)object3);
        ((SOAPFaultBuilder)object2).captureStackTrace(throwable);
        return JAXBMessage.create(JAXB_CONTEXT, object2, sOAPVersion);
    }

    private static Message createSOAP12Fault(SOAPVersion sOAPVersion, Throwable throwable, Object object, CheckedExceptionImpl checkedExceptionImpl, QName qName) {
        Object object2;
        Object object3;
        Object object4;
        SOAPFaultException sOAPFaultException = null;
        CodeType codeType = null;
        String string = null;
        String string2 = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable;
        } else if (throwable2 != null && throwable2 instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable.getCause();
        }
        if (sOAPFaultException != null) {
            object4 = sOAPFaultException.getFault();
            object3 = object4.getFaultCodeAsQName();
            if (object3 != null) {
                qName = object3;
                codeType = new CodeType(qName);
                object2 = object4.getFaultSubcodes();
                boolean bl = true;
                SubcodeType subcodeType = null;
                while (object2.hasNext()) {
                    QName qName2 = (QName)object2.next();
                    if (bl) {
                        SubcodeType subcodeType2 = new SubcodeType(qName2);
                        codeType.setSubcode(subcodeType2);
                        subcodeType = subcodeType2;
                        bl = false;
                        continue;
                    }
                    subcodeType = SOAPFaultBuilder.fillSubcodes(subcodeType, qName2);
                }
            }
            string = sOAPFaultException.getFault().getFaultString();
            string2 = sOAPFaultException.getFault().getFaultActor();
        }
        if (qName == null) {
            qName = SOAPFaultBuilder.getDefaultFaultCode(sOAPVersion);
            codeType = new CodeType(qName);
        } else if (codeType == null) {
            codeType = new CodeType(qName);
        }
        if (string == null && (string = throwable.getMessage()) == null) {
            string = throwable.toString();
        }
        object4 = new ReasonType(string);
        object3 = null;
        if (object == null && sOAPFaultException != null) {
            object3 = sOAPFaultException.getFault().getDetail();
        } else if (object != null) {
            try {
                object2 = new DOMResult();
                checkedExceptionImpl.getBridge().marshal(object, (Result)object2);
                object3 = (Element)((DOMResult)object2).getNode().getFirstChild();
            }
            catch (JAXBException jAXBException) {
                string = throwable.getMessage();
                qName = SOAPFaultBuilder.getDefaultFaultCode(sOAPVersion);
            }
        }
        object2 = null;
        if (object3 != null) {
            object2 = new DetailType((Element)object3);
        }
        SOAP12Fault sOAP12Fault = new SOAP12Fault(codeType, (ReasonType)object4, null, string2, (DetailType)object2);
        sOAP12Fault.captureStackTrace(throwable);
        return JAXBMessage.create(JAXB_CONTEXT, (Object)sOAP12Fault, sOAPVersion);
    }

    private static SubcodeType fillSubcodes(SubcodeType subcodeType, QName qName) {
        SubcodeType subcodeType2 = new SubcodeType(qName);
        subcodeType.setSubcode(subcodeType2);
        return subcodeType2;
    }

    private static QName getDefaultFaultCode(SOAPVersion sOAPVersion) {
        return sOAPVersion.faultCodeServer;
    }

    public static SOAPFaultBuilder create(Message message) throws JAXBException {
        return (SOAPFaultBuilder)message.readPayloadAsJAXB(JAXB_CONTEXT.createUnmarshaller());
    }

    static {
        logger = Logger.getLogger(SOAPFaultBuilder.class.getName());
        CAPTURE_STACK_TRACE_PROPERTY = SOAPFaultBuilder.class.getName() + ".disableCaptureStackTrace";
        try {
            captureStackTrace = System.getProperty(CAPTURE_STACK_TRACE_PROPERTY) == null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            JAXB_CONTEXT = (JAXBRIContext)JAXBContext.newInstance(SOAP11Fault.class, SOAP12Fault.class);
        }
        catch (JAXBException jAXBException) {
            throw new Error(jAXBException);
        }
    }
}

