/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.server.AsyncProvider;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.server.SDDocumentImpl;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.server.WSDLGenResolver;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.server.provider.ProviderInvokerTube;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.internal.ws.wsdl.writer.WSDLResolver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointFactory {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");

    public static <T> WSEndpoint<T> createEndpoint(Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, EntityResolver entityResolver, boolean bl2) {
        InvokerTube invokerTube;
        List<SDDocumentImpl> list;
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        EndpointFactory.verifyImplementorClass(clazz);
        if (invoker == null) {
            invoker = InstanceResolver.createDefault(clazz).createInvoker();
        }
        ArrayList<SDDocumentSource> arrayList = new ArrayList<SDDocumentSource>();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if (sDDocumentSource != null && !arrayList.contains(sDDocumentSource)) {
            arrayList.add(sDDocumentSource);
        }
        if (container == null) {
            container = ContainerResolver.getInstance().getContainer();
        }
        if (qName == null) {
            qName = EndpointFactory.getDefaultServiceName(clazz);
        }
        if (qName2 == null) {
            qName2 = EndpointFactory.getDefaultPortName(qName, clazz);
        }
        if (!((String)(object = qName.getNamespaceURI())).equals(list = qName2.getNamespaceURI())) {
            throw new ServerRtException("wrong.tns.for.port", list, object);
        }
        if (wSBinding == null) {
            wSBinding = BindingImpl.create(BindingID.parse(clazz));
        }
        if (sDDocumentSource != null) {
            EndpointFactory.verifyPrimaryWSDL(sDDocumentSource, qName);
        }
        object = null;
        if (clazz.getAnnotation(WebServiceProvider.class) == null) {
            object = RuntimeModeler.getPortTypeName(clazz);
        }
        list = EndpointFactory.categoriseMetadata(arrayList, qName, (QName)object);
        SDDocumentImpl sDDocumentImpl = EndpointFactory.findPrimary(list);
        WSDLPortImpl wSDLPortImpl = null;
        AbstractSEIModelImpl abstractSEIModelImpl = null;
        if (sDDocumentImpl != null) {
            wSDLPortImpl = EndpointFactory.getWSDLPort(sDDocumentImpl, (List<? extends SDDocumentSource>)list, qName, qName2);
        }
        WebServiceFeatureList webServiceFeatureList = ((BindingImpl)wSBinding).getFeatures();
        webServiceFeatureList.parseAnnotations(clazz);
        if (clazz.getAnnotation(WebServiceProvider.class) != null) {
            if (wSDLPortImpl != null) {
                webServiceFeatureList.mergeFeatures(wSDLPortImpl, true, true);
            }
            invokerTube = ProviderInvokerTube.create(clazz, wSBinding, invoker);
        } else {
            abstractSEIModelImpl = EndpointFactory.createSEIModel(wSDLPortImpl, clazz, qName, qName2, wSBinding);
            if (wSBinding instanceof SOAPBindingImpl) {
                ((SOAPBindingImpl)wSBinding).setPortKnownHeaders(((SOAPSEIModel)abstractSEIModelImpl).getKnownHeaders());
            }
            if (sDDocumentImpl == null) {
                sDDocumentImpl = EndpointFactory.generateWSDL(wSBinding, abstractSEIModelImpl, list, container, clazz);
                wSDLPortImpl = EndpointFactory.getWSDLPort(sDDocumentImpl, list, qName, qName2);
                abstractSEIModelImpl.freeze(wSDLPortImpl);
            }
            webServiceFeatureList.mergeFeatures(wSDLPortImpl, false, true);
            invokerTube = new SEIInvokerTube(abstractSEIModelImpl, invoker, wSBinding);
        }
        if (bl) {
            EndpointFactory.processHandlerAnnotation(wSBinding, clazz, qName, qName2);
        }
        if (sDDocumentImpl != null) {
            list = EndpointFactory.findMetadataClosure(sDDocumentImpl, list);
        }
        ServiceDefinitionImpl serviceDefinitionImpl = sDDocumentImpl != null ? new ServiceDefinitionImpl(list, sDDocumentImpl) : null;
        return new WSEndpointImpl<T>(qName, qName2, wSBinding, container, abstractSEIModelImpl, wSDLPortImpl, clazz, serviceDefinitionImpl, invokerTube, bl2);
    }

    private static List<SDDocumentImpl> findMetadataClosure(SDDocumentImpl sDDocumentImpl, List<SDDocumentImpl> list) {
        Object object;
        HashMap<String, SDDocumentImpl> hashMap = new HashMap<String, SDDocumentImpl>();
        for (SDDocumentImpl object22 : list) {
            hashMap.put(object22.getSystemId().toString(), object22);
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put(sDDocumentImpl.getSystemId().toString(), sDDocumentImpl);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(sDDocumentImpl.getImports());
        while (!arrayList.isEmpty()) {
            object = (String)arrayList.remove(0);
            SDDocumentImpl sDDocumentImpl2 = (SDDocumentImpl)hashMap.get(object);
            if (sDDocumentImpl2 == null || hashMap2.containsKey(object)) continue;
            hashMap2.put(object, sDDocumentImpl2);
            arrayList.addAll(sDDocumentImpl2.getImports());
        }
        object = new ArrayList();
        object.addAll(hashMap2.values());
        return object;
    }

    private static <T> void processHandlerAnnotation(WSBinding wSBinding, Class<T> clazz, QName qName, QName qName2) {
        HandlerAnnotationInfo handlerAnnotationInfo = HandlerAnnotationProcessor.buildHandlerInfo(clazz, qName, qName2, wSBinding);
        if (handlerAnnotationInfo != null) {
            wSBinding.setHandlerChain(handlerAnnotationInfo.getHandlers());
            if (wSBinding instanceof SOAPBinding) {
                ((SOAPBinding)((Object)wSBinding)).setRoles(handlerAnnotationInfo.getRoles());
            }
        }
    }

    public static boolean verifyImplementorClass(Class<?> clazz) {
        WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webServiceProvider == null && webService == null) {
            throw new IllegalArgumentException(clazz + " has neither @WebSerivce nor @WebServiceProvider annotation");
        }
        if (webServiceProvider != null && webService != null) {
            throw new IllegalArgumentException(clazz + " has both @WebSerivce and @WebServiceProvider annotations");
        }
        if (webServiceProvider != null) {
            if (Provider.class.isAssignableFrom(clazz) || AsyncProvider.class.isAssignableFrom(clazz)) {
                return true;
            }
            throw new IllegalArgumentException(clazz + " doesn't implement Provider or AsyncProvider interface");
        }
        return false;
    }

    private static AbstractSEIModelImpl createSEIModel(WSDLPort wSDLPort, Class<?> clazz, @NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding) {
        RuntimeModeler runtimeModeler = wSDLPort == null ? new RuntimeModeler(clazz, qName, wSBinding.getBindingId()) : new RuntimeModeler(clazz, qName, (WSDLPortImpl)wSDLPort);
        runtimeModeler.setPortName(qName2);
        return runtimeModeler.buildRuntimeModel();
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> clazz) {
        QName qName;
        WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
        if (webServiceProvider != null) {
            String string = webServiceProvider.targetNamespace();
            String string2 = webServiceProvider.serviceName();
            qName = new QName(string, string2);
        } else {
            qName = RuntimeModeler.getServiceName(clazz);
        }
        assert (qName != null);
        return qName;
    }

    @NotNull
    public static QName getDefaultPortName(QName qName, Class<?> clazz) {
        QName qName2;
        WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
        if (webServiceProvider != null) {
            String string = webServiceProvider.targetNamespace();
            String string2 = webServiceProvider.portName();
            qName2 = new QName(string, string2);
        } else {
            qName2 = RuntimeModeler.getPortName(clazz, qName.getNamespaceURI());
        }
        assert (qName2 != null);
        return qName2;
    }

    @Nullable
    public static String getWsdlLocation(Class<?> clazz) {
        String string;
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService != null) {
            string = webService.wsdlLocation();
        } else {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            assert (webServiceProvider != null);
            string = webServiceProvider.wsdlLocation();
        }
        if (string.length() < 1) {
            string = null;
        }
        return string;
    }

    private static SDDocumentImpl generateWSDL(WSBinding wSBinding, AbstractSEIModelImpl abstractSEIModelImpl, List<SDDocumentImpl> list, Container container, Class clazz) {
        Object object;
        BindingID bindingID = wSBinding.getBindingId();
        if (!bindingID.canGenerateWSDL()) {
            throw new ServerRtException("can.not.generate.wsdl", bindingID);
        }
        if (bindingID.toString().equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            object = ServerMessages.GENERATE_NON_STANDARD_WSDL();
            logger.warning((String)object);
        }
        object = new WSDLGenResolver(list, abstractSEIModelImpl.getServiceQName(), abstractSEIModelImpl.getPortTypeName());
        WSDLGenerator wSDLGenerator = new WSDLGenerator(abstractSEIModelImpl, (WSDLResolver)object, wSBinding, container, clazz, ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
        wSDLGenerator.doGeneration();
        return ((WSDLGenResolver)object).updateDocs();
    }

    private static List<SDDocumentImpl> categoriseMetadata(List<SDDocumentSource> list, QName qName, QName qName2) {
        ArrayList<SDDocumentImpl> arrayList = new ArrayList<SDDocumentImpl>(list.size());
        for (SDDocumentSource sDDocumentSource : list) {
            arrayList.add(SDDocumentImpl.create(sDDocumentSource, qName, qName2));
        }
        return arrayList;
    }

    private static void verifyPrimaryWSDL(@NotNull SDDocumentSource sDDocumentSource, @NotNull QName qName) {
        SDDocumentImpl sDDocumentImpl = SDDocumentImpl.create(sDDocumentSource, qName, null);
        if (!(sDDocumentImpl instanceof SDDocument.WSDL)) {
            throw new WebServiceException("Not a primary WSDL=" + sDDocumentSource.getSystemId());
        }
        SDDocument.WSDL wSDL = (SDDocument.WSDL)((Object)sDDocumentImpl);
        if (!wSDL.hasService()) {
            throw new WebServiceException("Not a primary WSDL=" + sDDocumentSource.getSystemId() + " since it doesn't have Service " + qName);
        }
    }

    @Nullable
    private static SDDocumentImpl findPrimary(@NotNull List<SDDocumentImpl> list) {
        SDDocumentImpl sDDocumentImpl = null;
        boolean bl = false;
        boolean bl2 = false;
        for (SDDocumentImpl sDDocumentImpl2 : list) {
            if (!(sDDocumentImpl2 instanceof SDDocument.WSDL)) continue;
            SDDocument.WSDL wSDL = (SDDocument.WSDL)((Object)sDDocumentImpl2);
            if (wSDL.hasService()) {
                sDDocumentImpl = sDDocumentImpl2;
                if (bl) {
                    throw new ServerRtException("duplicate.primary.wsdl", sDDocumentImpl2.getSystemId());
                }
                bl = true;
            }
            if (!wSDL.hasPortType()) continue;
            if (bl2) {
                throw new ServerRtException("duplicate.abstract.wsdl", sDDocumentImpl2.getSystemId());
            }
            bl2 = true;
        }
        return sDDocumentImpl;
    }

    @NotNull
    private static WSDLPortImpl getWSDLPort(SDDocumentSource sDDocumentSource, List<? extends SDDocumentSource> list, @NotNull QName qName, @NotNull QName qName2) {
        URL uRL = sDDocumentSource.getSystemId();
        try {
            WSDLModelImpl wSDLModelImpl = RuntimeWSDLParser.parse(new XMLEntityResolver.Parser(sDDocumentSource), new EntityResolverImpl(list), false, ServiceFinder.find(WSDLParserExtension.class).toArray());
            WSDLPortImpl wSDLPortImpl = wSDLModelImpl.getService(qName).get(qName2);
            if (wSDLPortImpl == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICEPORT(qName, qName2, uRL));
            }
            return wSDLPortImpl;
        }
        catch (IOException iOException) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException("runtime.saxparser.exception", xMLStreamException.getMessage(), xMLStreamException.getLocation(), xMLStreamException);
        }
        catch (SAXException sAXException) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, sAXException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, serviceConfigurationError);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityResolverImpl
    implements XMLEntityResolver {
        private Map<String, SDDocumentSource> metadata = new HashMap<String, SDDocumentSource>();

        public EntityResolverImpl(List<? extends SDDocumentSource> list) {
            for (SDDocumentSource sDDocumentSource : list) {
                this.metadata.put(sDDocumentSource.getSystemId().toExternalForm(), sDDocumentSource);
            }
        }

        @Override
        public XMLEntityResolver.Parser resolveEntity(String string, String string2) throws IOException, XMLStreamException {
            SDDocumentSource sDDocumentSource;
            if (string2 != null && (sDDocumentSource = this.metadata.get(string2)) != null) {
                return new XMLEntityResolver.Parser(sDDocumentSource);
            }
            return null;
        }
    }
}

