/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ClientNotifForwarder;
import com.sun.jmx.remote.internal.ProxyInputStream;
import com.sun.jmx.remote.internal.ProxyRef;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXAddressable;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.NoCallStackClassLoader;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIConnector
implements JMXConnector,
Serializable,
JMXAddressable {
    private static final ClassLogger logger;
    private static final long serialVersionUID = 817323035842634473L;
    private static final String rmiServerImplStubClassName;
    private static final Class rmiServerImplStubClass;
    private static final String rmiConnectionImplStubClassName;
    private static final Class rmiConnectionImplStubClass;
    private static final String pRefClassName = "com.sun.jmx.remote.internal.PRef";
    private static final Constructor proxyRefConstructor;
    private static final String iiopConnectionStubClassName1 = "org.omg.stub.javax.management.remote.rmi._RMIConnection_Stub";
    private static final String iiopConnectionStubClassName2 = "javax.management.remote.rmi._RMIConnection_Stub";
    private static final String proxyStubClassName = "com.sun.jmx.remote.internal.ProxyStub";
    private static final String pInputStreamClassName = "com.sun.jmx.remote.internal.PInputStream";
    private static final Class proxyStubClass;
    private static final byte[] base64ToInt;
    private final RMIServer rmiServer;
    private final JMXServiceURL jmxServiceURL;
    private transient Map env;
    private transient ClassLoader defaultClassLoader;
    private transient RMIConnection connection;
    private transient String connectionId;
    private transient long clientNotifSeqNo = 0L;
    private transient WeakHashMap rmbscMap;
    private transient RMINotifClient rmiNotifClient;
    private transient long clientNotifCounter = 0L;
    private transient boolean connected;
    private transient boolean terminated;
    private transient Exception closeException;
    private transient NotificationBroadcasterSupport connectionBroadcaster;
    private transient ClientCommunicatorAdmin communicatorAdmin;
    private static WeakReference<ORB> orb;

    private RMIConnector(RMIServer rMIServer, JMXServiceURL jMXServiceURL, Map map) {
        if (rMIServer == null && jMXServiceURL == null) {
            throw new IllegalArgumentException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
        this.rmiServer = rMIServer;
        this.jmxServiceURL = jMXServiceURL;
        if (map == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(map);
            this.env = Collections.unmodifiableMap(map);
        }
    }

    public RMIConnector(JMXServiceURL jMXServiceURL, Map<String, ?> map) {
        this(null, jMXServiceURL, map);
    }

    public RMIConnector(RMIServer rMIServer, Map<String, ?> map) {
        this(rMIServer, null, map);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(":");
        if (this.rmiServer != null) {
            stringBuffer.append(" rmiServer=").append(this.rmiServer.toString());
        }
        if (this.jmxServiceURL != null) {
            if (this.rmiServer != null) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" jmxServiceURL=").append(this.jmxServiceURL.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.jmxServiceURL;
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    @Override
    public synchronized void connect(Map<String, ?> map) throws IOException {
        String string;
        boolean bl = logger.traceOn();
        String string2 = string = bl ? "[" + this.toString() + "]" : null;
        if (this.terminated) {
            logger.trace("connect", string + " already closed.");
            throw new IOException("Connector closed");
        }
        if (this.connected) {
            logger.trace("connect", string + " already connected.");
            return;
        }
        try {
            if (bl) {
                logger.trace("connect", string + " connecting...");
            }
            HashMap<String, java.lang.Object> hashMap = new HashMap<String, java.lang.Object>(this.env == null ? Collections.EMPTY_MAP : this.env);
            if (map != null) {
                EnvHelp.checkAttributes(map);
                hashMap.putAll(map);
            }
            if (bl) {
                logger.trace("connect", string + " finding stub...");
            }
            RMIServer rMIServer = this.rmiServer != null ? this.rmiServer : this.findRMIServer(this.jmxServiceURL, hashMap);
            boolean bl2 = EnvHelp.computeBooleanFromString(hashMap, "jmx.remote.x.check.stub");
            if (bl2) {
                RMIConnector.checkStub(rMIServer, rmiServerImplStubClass);
            }
            if (bl) {
                logger.trace("connect", string + " connecting stub...");
            }
            rMIServer = RMIConnector.connectStub(rMIServer, hashMap);
            String string3 = string = bl ? "[" + this.toString() + "]" : null;
            if (bl) {
                logger.trace("connect", string + " getting connection...");
            }
            java.lang.Object v = hashMap.get("jmx.remote.credentials");
            this.connection = RMIConnector.getConnection(rMIServer, v, bl2);
            if (bl) {
                logger.trace("connect", string + " getting class loader...");
            }
            this.defaultClassLoader = EnvHelp.resolveClientClassLoader(hashMap);
            hashMap.put("jmx.remote.default.class.loader", this.defaultClassLoader);
            this.rmiNotifClient = new RMINotifClient(this.defaultClassLoader, hashMap);
            this.env = hashMap;
            long l = EnvHelp.getConnectionCheckPeriod(hashMap);
            this.communicatorAdmin = new RMIClientCommunicatorAdmin(l);
            this.connected = true;
            this.connectionId = this.getConnectionId();
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifSeqNo++, "Successful connection", null);
            this.sendNotification(jMXConnectionNotification);
            if (bl) {
                logger.trace("connect", string + " done...");
            }
        }
        catch (IOException iOException) {
            if (bl) {
                logger.trace("connect", string + " failed to connect: " + iOException);
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                logger.trace("connect", string + " failed to connect: " + runtimeException);
            }
            throw runtimeException;
        }
        catch (NamingException namingException) {
            String string4 = "Failed to retrieve RMIServer stub: " + namingException;
            if (bl) {
                logger.trace("connect", string + " " + string4);
            }
            throw EnvHelp.initCause(new IOException(string4), namingException);
        }
    }

    @Override
    public synchronized String getConnectionId() throws IOException {
        if (this.terminated || !this.connected) {
            if (logger.traceOn()) {
                logger.trace("getConnectionId", "[" + this.toString() + "] not connected.");
            }
            throw new IOException("Not connected");
        }
        return this.connection.getConnectionId();
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        if (this.terminated) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] already closed.");
            }
            throw new IOException("Connection closed");
        }
        if (!this.connected) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] is not connected.");
            }
            throw new IOException("Not connected");
        }
        MBeanServerConnection mBeanServerConnection = (MBeanServerConnection)this.rmbscMap.get(subject);
        if (mBeanServerConnection != null) {
            return mBeanServerConnection;
        }
        mBeanServerConnection = new RemoteMBeanServerConnection(subject);
        this.rmbscMap.put(subject, mBeanServerConnection);
        return mBeanServerConnection;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, java.lang.Object object) {
        if (notificationListener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, java.lang.Object object) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    private void sendNotification(Notification notification) {
        this.connectionBroadcaster.sendNotification(notification);
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(false);
    }

    private synchronized void close(boolean bl) throws IOException {
        Serializable serializable;
        String string;
        String string2;
        boolean bl2;
        block26: {
            boolean bl3;
            block25: {
                bl2 = logger.traceOn();
                bl3 = logger.debugOn();
                String string3 = string2 = bl2 ? "[" + this.toString() + "]" : null;
                if (!bl) {
                    if (this.terminated) {
                        if (this.closeException == null) {
                            if (bl2) {
                                logger.trace("close", string2 + " already closed.");
                            }
                            return;
                        }
                    } else {
                        this.terminated = true;
                    }
                }
                if (this.closeException != null && bl2 && bl2) {
                    logger.trace("close", string2 + " had failed: " + this.closeException);
                    logger.trace("close", string2 + " attempting to close again.");
                }
                string = null;
                if (this.connected) {
                    string = this.connectionId;
                }
                this.closeException = null;
                if (bl2) {
                    logger.trace("close", string2 + " closing.");
                }
                if (this.communicatorAdmin != null) {
                    this.communicatorAdmin.terminate();
                }
                if (this.rmiNotifClient != null) {
                    try {
                        this.rmiNotifClient.terminate();
                        if (bl2) {
                            logger.trace("close", string2 + " RMI Notification client terminated.");
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.closeException = runtimeException;
                        if (bl2) {
                            logger.trace("close", string2 + " Failed to terminate RMI Notification client: " + runtimeException);
                        }
                        if (!bl3) break block25;
                        logger.debug("close", runtimeException);
                    }
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    if (bl2) {
                        logger.trace("close", string2 + " closed.");
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (IOException iOException) {
                    this.closeException = iOException;
                    if (bl2) {
                        logger.trace("close", string2 + " Failed to close RMIServer: " + iOException);
                    }
                    if (!bl3) break block26;
                    logger.debug("close", iOException);
                }
            }
        }
        this.rmbscMap.clear();
        if (string != null) {
            serializable = new JMXConnectionNotification("jmx.remote.connection.closed", this, string, this.clientNotifSeqNo++, "Client has been closed", null);
            this.sendNotification((Notification)serializable);
        }
        if (this.closeException != null) {
            if (bl2) {
                logger.trace("close", string2 + " failed to close: " + this.closeException);
            }
            if (this.closeException instanceof IOException) {
                throw (IOException)this.closeException;
            }
            if (this.closeException instanceof RuntimeException) {
                throw (RuntimeException)this.closeException;
            }
            serializable = new IOException("Failed to close: " + this.closeException);
            throw (IOException)((java.lang.Object)EnvHelp.initCause(serializable, this.closeException));
        }
    }

    private Integer addListenerWithSubject(ObjectName objectName, MarshalledObject marshalledObject, Subject subject, boolean bl) throws InstanceNotFoundException, IOException {
        boolean bl2 = logger.debugOn();
        if (bl2) {
            logger.debug("addListenerWithSubject", "(ObjectName,MarshalledObject,Subject)");
        }
        ObjectName[] objectNameArray = new ObjectName[]{objectName};
        MarshalledObject[] marshalledObjectArray = new MarshalledObject[]{marshalledObject};
        Subject[] subjectArray = new Subject[]{subject};
        Integer[] integerArray = this.addListenersWithSubjects(objectNameArray, marshalledObjectArray, subjectArray, bl);
        if (bl2) {
            logger.debug("addListenerWithSubject", "listenerID=" + integerArray[0]);
        }
        return integerArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] addListenersWithSubjects(ObjectName[] objectNameArray, MarshalledObject[] marshalledObjectArray, Subject[] subjectArray, boolean bl) throws InstanceNotFoundException, IOException {
        Integer[] integerArray;
        boolean bl2;
        block10: {
            bl2 = logger.debugOn();
            if (bl2) {
                logger.debug("addListenersWithSubjects", "(ObjectName[],MarshalledObject[],Subject[])");
            }
            ClassLoader classLoader = this.pushDefaultClassLoader();
            integerArray = null;
            try {
                integerArray = this.connection.addNotificationListeners(objectNameArray, marshalledObjectArray, subjectArray);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                if (bl) {
                    this.communicatorAdmin.gotIOException(noSuchObjectException);
                    integerArray = this.connection.addNotificationListeners(objectNameArray, marshalledObjectArray, subjectArray);
                    break block10;
                }
                throw noSuchObjectException;
            }
            catch (IOException iOException) {
                this.communicatorAdmin.gotIOException(iOException);
            }
            finally {
                this.popDefaultClassLoader(classLoader);
            }
        }
        if (bl2) {
            logger.debug("addListenersWithSubjects", "registered " + integerArray.length + " listener(s)");
        }
        return integerArray;
    }

    static RMIServer connectStub(RMIServer rMIServer, Map map) throws IOException {
        if (rMIServer instanceof Stub) {
            Stub stub = (Stub)((java.lang.Object)rMIServer);
            try {
                stub._orb();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                stub.connect(RMIConnector.resolveOrb(map));
            }
        }
        return rMIServer;
    }

    static ORB resolveOrb(Map map) throws IOException {
        java.lang.Object v;
        if (map != null) {
            v = map.get("java.naming.corba.orb");
            if (v != null && !(v instanceof ORB)) {
                throw new IllegalArgumentException("java.naming.corba.orb must be an instance of org.omg.CORBA.ORB.");
            }
            if (v != null) {
                return (ORB)v;
            }
        }
        ORB oRB = v = orb == null ? null : (ORB)orb.get();
        if (v != null) {
            return v;
        }
        ORB oRB2 = ORB.init((String[])null, (Properties)null);
        orb = new WeakReference<ORB>(oRB2);
        return oRB2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null.");
        }
        RMIConnector.connectStub(this.rmiServer, this.env);
        objectOutputStream.defaultWriteObject();
    }

    private void initTransients() {
        this.rmbscMap = new WeakHashMap();
        this.connected = false;
        this.terminated = false;
        this.connectionBroadcaster = new NotificationBroadcasterSupport();
    }

    private static void checkStub(Remote remote, Class<? extends Remote> clazz) {
        java.lang.Object object;
        if (remote.getClass() != clazz) {
            if (!Proxy.isProxyClass(remote.getClass())) {
                throw new SecurityException("Expecting a " + clazz.getName() + " stub!");
            }
            object = Proxy.getInvocationHandler(remote);
            if (object.getClass() != RemoteObjectInvocationHandler.class) {
                throw new SecurityException("Expecting a dynamic proxy instance with a " + RemoteObjectInvocationHandler.class.getName() + " invocation handler!");
            }
            remote = (Remote)object;
        }
        if ((object = ((RemoteObject)remote).getRef()).getClass() != UnicastRef2.class) {
            throw new SecurityException("Expecting a " + UnicastRef2.class.getName() + " remote reference in stub!");
        }
        LiveRef liveRef = ((UnicastRef2)object).getLiveRef();
        RMIClientSocketFactory rMIClientSocketFactory = liveRef.getClientSocketFactory();
        if (rMIClientSocketFactory == null || rMIClientSocketFactory.getClass() != SslRMIClientSocketFactory.class) {
            throw new SecurityException("Expecting a " + SslRMIClientSocketFactory.class.getName() + " RMI client socket factory in stub!");
        }
    }

    private RMIServer findRMIServer(JMXServiceURL jMXServiceURL, Map map) throws NamingException, IOException {
        String string;
        boolean bl = RMIConnectorServer.isIiopURL(jMXServiceURL, true);
        if (bl) {
            map.put("java.naming.corba.orb", RMIConnector.resolveOrb(map));
        }
        if ((string = jMXServiceURL.getURLPath()).startsWith("/jndi/")) {
            return this.findRMIServerJNDI(string.substring(6), map, bl);
        }
        if (string.startsWith("/stub/")) {
            return this.findRMIServerJRMP(string.substring(6), map, bl);
        }
        if (string.startsWith("/ior/")) {
            return this.findRMIServerIIOP(string.substring(5), map, bl);
        }
        String string2 = "URL path must begin with /jndi/ or /stub/ or /ior/: " + string;
        throw new MalformedURLException(string2);
    }

    private RMIServer findRMIServerJNDI(String string, Map map, boolean bl) throws NamingException {
        InitialContext initialContext = new InitialContext(EnvHelp.mapToHashtable(map));
        java.lang.Object object = initialContext.lookup(string);
        initialContext.close();
        if (bl) {
            return RMIConnector.narrowIIOPServer(object);
        }
        return RMIConnector.narrowJRMPServer(object);
    }

    private static RMIServer narrowJRMPServer(java.lang.Object object) {
        return (RMIServer)object;
    }

    private static RMIServer narrowIIOPServer(java.lang.Object object) {
        try {
            return (RMIServer)PortableRemoteObject.narrow(object, RMIServer.class);
        }
        catch (ClassCastException classCastException) {
            if (logger.traceOn()) {
                logger.trace("narrowIIOPServer", "Failed to narrow objref=" + object + ": " + classCastException);
            }
            if (logger.debugOn()) {
                logger.debug("narrowIIOPServer", classCastException);
            }
            return null;
        }
    }

    private RMIServer findRMIServerIIOP(String string, Map map, boolean bl) {
        ORB oRB = (ORB)map.get("java.naming.corba.orb");
        Object object = oRB.string_to_object(string);
        return (RMIServer)PortableRemoteObject.narrow(object, RMIServer.class);
    }

    private RMIServer findRMIServerJRMP(String string, Map map, boolean bl) throws IOException {
        java.lang.Object object;
        byte[] byArray;
        try {
            byArray = RMIConnector.base64ToByteArray(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedURLException("Bad BASE64 encoding: " + illegalArgumentException.getMessage());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClassLoader classLoader = EnvHelp.resolveClientClassLoader(map);
        ObjectInputStream objectInputStream = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new ObjectInputStreamWithLoader(byteArrayInputStream, classLoader);
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MalformedURLException("Class not found: " + classNotFoundException);
        }
        return (RMIServer)PortableRemoteObject.narrow(object, RMIServer.class);
    }

    private static RMIConnection shadowJrmpStub(RemoteObject remoteObject) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        RemoteRef remoteRef = remoteObject.getRef();
        RemoteRef remoteRef2 = (RemoteRef)proxyRefConstructor.newInstance(remoteRef);
        Class[] classArray = new Class[]{RemoteRef.class};
        Constructor constructor = rmiConnectionImplStubClass.getConstructor(classArray);
        java.lang.Object[] objectArray = new java.lang.Object[]{remoteRef2};
        RMIConnection rMIConnection = (RMIConnection)constructor.newInstance(objectArray);
        return rMIConnection;
    }

    private static RMIConnection shadowIiopStub(Stub stub) throws InstantiationException, IllegalAccessException {
        Stub stub2 = (Stub)proxyStubClass.newInstance();
        stub2._set_delegate(stub._get_delegate());
        return (RMIConnection)((java.lang.Object)stub2);
    }

    private static RMIConnection getConnection(RMIServer rMIServer, java.lang.Object object, boolean bl) throws IOException {
        RMIConnection rMIConnection = rMIServer.newClient(object);
        if (bl) {
            RMIConnector.checkStub(rMIConnection, rmiConnectionImplStubClass);
        }
        try {
            if (rMIConnection.getClass() == rmiConnectionImplStubClass) {
                return RMIConnector.shadowJrmpStub((RemoteObject)((java.lang.Object)rMIConnection));
            }
            String string = rMIConnection.getClass().getName();
            if (string.equals(iiopConnectionStubClassName1) || string.equals(iiopConnectionStubClassName2)) {
                return RMIConnector.shadowIiopStub((Stub)((java.lang.Object)rMIConnection));
            }
            logger.trace("getConnection", "Did not wrap " + rMIConnection.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect");
        }
        catch (Exception exception) {
            logger.error("getConnection", "Could not wrap " + rMIConnection.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect: " + exception);
            logger.debug("getConnection", exception);
        }
        return rMIConnection;
    }

    private static byte[] base64ToByteArray(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = n4 / 4;
        if (4 * n5 != n4) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int n6 = 0;
        int n7 = n5;
        if (n4 != 0) {
            if (string.charAt(n4 - 1) == '=') {
                ++n6;
                --n7;
            }
            if (string.charAt(n4 - 2) == '=') {
                ++n6;
            }
        }
        byte[] byArray = new byte[3 * n5 - n6];
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = RMIConnector.base64toInt(string.charAt(n8++));
            n = RMIConnector.base64toInt(string.charAt(n8++));
            int n10 = RMIConnector.base64toInt(string.charAt(n8++));
            int n11 = RMIConnector.base64toInt(string.charAt(n8++));
            byArray[n9++] = (byte)(n2 << 2 | n >> 4);
            byArray[n9++] = (byte)(n << 4 | n10 >> 2);
            byArray[n9++] = (byte)(n10 << 6 | n11);
        }
        if (n6 != 0) {
            n3 = RMIConnector.base64toInt(string.charAt(n8++));
            n2 = RMIConnector.base64toInt(string.charAt(n8++));
            byArray[n9++] = (byte)(n3 << 2 | n2 >> 4);
            if (n6 == 1) {
                n = RMIConnector.base64toInt(string.charAt(n8++));
                byArray[n9++] = (byte)(n2 << 4 | n >> 2);
            }
        }
        return byArray;
    }

    private static int base64toInt(char c) {
        int n = c >= base64ToInt.length ? -1 : base64ToInt[c];
        if (n < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return n;
    }

    private ClassLoader pushDefaultClassLoader() {
        final Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (this.defaultClassLoader != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    thread.setContextClassLoader(RMIConnector.this.defaultClassLoader);
                    return null;
                }
            });
        }
        return classLoader;
    }

    private void popDefaultClassLoader(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    private static String objects(java.lang.Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        return Arrays.asList(objectArray).toString();
    }

    private static String strings(String[] stringArray) {
        return RMIConnector.objects(stringArray);
    }

    static {
        Class clazz;
        java.lang.Object object;
        String[] stringArray;
        java.lang.Object object2;
        logger = new ClassLogger("javax.management.remote.rmi", "RMIConnector");
        rmiServerImplStubClassName = RMIServer.class.getName() + "Impl_Stub";
        rmiConnectionImplStubClassName = RMIConnection.class.getName() + "Impl_Stub";
        final byte[] byArray = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0017\n\u0000\u0005\u0000\r\t\u0000\u0004\u0000\u000e\u000b\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0001\u0000\u0006<init>\u0001\u0000\u001e(Ljava/rmi/server/RemoteRef;)V\u0001\u0000\u0004Code\u0001\u0000\u0006invoke\u0001\u0000S(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0013\f\u0000\u0006\u0000\u0007\f\u0000\u0014\u0000\u0015\u0007\u0000\u0016\f\u0000\t\u0000\n\u0001\u0000 com/sun/jmx/remote/internal/PRef\u0001\u0000$com/sun/jmx/remote/internal/ProxyRef\u0001\u0000\u0013java/lang/Exception\u0001\u0000\u0003ref\u0001\u0000\u001bLjava/rmi/server/RemoteRef;\u0001\u0000\u0019java/rmi/server/RemoteRef\u0000!\u0000\u0004\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u001b\u0000\u0006\u0000\u0006\u0000\u0000\u0000\u000f*\u00b4\u0000\u0002+,-\u0016\u0004\u00b9\u0000\u0003\u0006\u0000\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0004\u0000\u0001\u0000\f\u0000\u0000");
        java.lang.Object object3 = new PrivilegedExceptionAction(){

            public java.lang.Object run() throws Exception {
                Class<RMIConnector> clazz = RMIConnector.class;
                ClassLoader classLoader = clazz.getClassLoader();
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                String[] stringArray = new String[]{ProxyRef.class.getName()};
                NoCallStackClassLoader noCallStackClassLoader = new NoCallStackClassLoader(RMIConnector.pRefClassName, byArray, stringArray, classLoader, protectionDomain);
                Class<?> clazz2 = noCallStackClassLoader.loadClass(RMIConnector.pRefClassName);
                return clazz2.getConstructor(RemoteRef.class);
            }
        };
        try {
            object2 = Class.forName(rmiServerImplStubClassName);
        }
        catch (Exception exception) {
            logger.error("<clinit>", "Failed to instantiate " + rmiServerImplStubClassName + ": " + exception);
            logger.debug("<clinit>", exception);
            object2 = null;
        }
        rmiServerImplStubClass = object2;
        try {
            stringArray = Class.forName(rmiConnectionImplStubClassName);
            object = (Constructor)AccessController.doPrivileged(object3);
        }
        catch (Exception exception) {
            logger.error("<clinit>", "Failed to initialize proxy reference constructor for " + rmiConnectionImplStubClassName + ": " + exception);
            logger.debug("<clinit>", exception);
            stringArray = null;
            object = null;
        }
        rmiConnectionImplStubClass = stringArray;
        proxyRefConstructor = object;
        object3 = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000)\n\u0000\f\u0000\u0016\u0007\u0000\u0017\n\u0000\f\u0000\u0018\n\u0000\u0002\u0000\u0019\u0007\u0000\u001a\n\u0000\u0005\u0000\u001b\n\u0000\u0005\u0000\u001c\n\u0000\u0005\u0000\u001d\n\u0000\u0002\u0000\u001e\n\u0000\f\u0000\u001f\u0007\u0000 \u0007\u0000!\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0007_invoke\u0001\u0000K(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\nExceptions\u0007\u0000\"\u0001\u0000\r_releaseReply\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\f\u0000\u0010\u0000\u0011\f\u0000\r\u0000\u0015\u0001\u0000+org/omg/CORBA/portable/ApplicationException\f\u0000#\u0000$\f\u0000%\u0000&\f\u0000\r\u0000'\f\u0000(\u0000$\f\u0000\u0014\u0000\u0015\u0001\u0000%com/sun/jmx/remote/internal/ProxyStub\u0001\u0000<org/omg/stub/javax/management/remote/rmi/_RMIConnection_Stub\u0001\u0000)org/omg/CORBA/portable/RemarshalException\u0001\u0000\u000egetInputStream\u0001\u0000&()Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\u0005getId\u0001\u0000\u0014()Ljava/lang/String;\u0001\u00009(Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0015getProxiedInputStream\u0000!\u0000\u000b\u0000\f\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0010\u0000\u0011\u0000\u0002\u0000\u000f\u0000\u0000\u0000;\u0000\u0004\u0000\u0004\u0000\u0000\u0000'\u00bb\u0000\u0002Y*+\u00b7\u0000\u0003\u00b7\u0000\u0004\u00b0M\u00bb\u0000\u0002Y,\u00b6\u0000\u0006\u00b7\u0000\u0004N\u00bb\u0000\u0005Y,\u00b6\u0000\u0007-\u00b7\u0000\b\u00bf\u0000\u0001\u0000\u0000\u0000\f\u0000\r\u0000\u0005\u0000\u0000\u0000\u0012\u0000\u0000\u0000\u0006\u0000\u0002\u0000\u0005\u0000\u0013\u0000\u0001\u0000\u0014\u0000\u0015\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u001e\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0012+\u00c6\u0000\u000b+\u00c0\u0000\u0002\u00b6\u0000\tL*+\u00b7\u0000\n\u00b1\u0000\u0000\u0000\u0000\u0000\u0000");
        object2 = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u001e\n\u0000\u0007\u0000\u000f\t\u0000\u0006\u0000\u0010\n\u0000\u0011\u0000\u0012\n\u0000\u0006\u0000\u0013\n\u0000\u0014\u0000\u0015\u0007\u0000\u0016\u0007\u0000\u0017\u0001\u0000\u0006<init>\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0004Code\u0001\u0000\bread_any\u0001\u0000\u0015()Lorg/omg/CORBA/Any;\u0001\u0000\nread_value\u0001\u0000)(Ljava/lang/Class;)Ljava/io/Serializable;\f\u0000\b\u0000\t\f\u0000\u0018\u0000\u0019\u0007\u0000\u001a\f\u0000\u000b\u0000\f\f\u0000\u001b\u0000\u001c\u0007\u0000\u001d\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\u0001\u0000,com/sun/jmx/remote/internal/ProxyInputStream\u0001\u0000\u0002in\u0001\u0000$Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\"org/omg/CORBA/portable/InputStream\u0001\u0000\u0006narrow\u0001\u0000*()Lorg/omg/CORBA_2_3/portable/InputStream;\u0001\u0000&org/omg/CORBA_2_3/portable/InputStream\u0000!\u0000\u0006\u0000\u0007\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\b\u0000\t\u0000\u0001\u0000\n\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u000b\u0000\f\u0000\u0001\u0000\n\u0000\u0000\u0000\u0014\u0000\u0001\u0000\u0001\u0000\u0000\u0000\b*\u00b4\u0000\u0002\u00b6\u0000\u0003\u00b0\u0000\u0000\u0000\u0000\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\n\u0000\u0000\u0000\u0015\u0000\u0002\u0000\u0002\u0000\u0000\u0000\t*\u00b6\u0000\u0004+\u00b6\u0000\u0005\u00b0\u0000\u0000\u0000\u0000\u0000\u0000");
        stringArray = new String[]{proxyStubClassName, pInputStreamClassName};
        object = new byte[][]{(byte[])object3, (byte[])object2};
        String[] stringArray2 = new String[]{iiopConnectionStubClassName1, iiopConnectionStubClassName2, ProxyInputStream.class.getName()};
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((byte[][])object, stringArray2){
            final /* synthetic */ byte[][] val$byteCodes;
            final /* synthetic */ String[] val$otherClassNames;
            {
                this.val$byteCodes = byArray;
                this.val$otherClassNames = stringArray2;
            }

            public java.lang.Object run() throws Exception {
                Class<RMIConnector> clazz = RMIConnector.class;
                ClassLoader classLoader = clazz.getClassLoader();
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                NoCallStackClassLoader noCallStackClassLoader = new NoCallStackClassLoader(stringArray, this.val$byteCodes, this.val$otherClassNames, classLoader, protectionDomain);
                return noCallStackClassLoader.loadClass(RMIConnector.proxyStubClassName);
            }
        };
        try {
            clazz = (Class)AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Exception exception) {
            logger.error("<clinit>", "Unexpected exception making shadow IIOP stub class: " + exception);
            logger.debug("<clinit>", exception);
            clazz = null;
        }
        proxyStubClass = clazz;
        base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        orb = null;
    }

    private static final class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithLoader(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.loader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return Class.forName(objectStreamClass.getName(), false, this.loader);
        }
    }

    private class RMIClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public RMIClientCommunicatorAdmin(long l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gotIOException(IOException iOException) throws IOException {
            block12: {
                if (iOException instanceof NoSuchObjectException) {
                    super.gotIOException(iOException);
                    return;
                }
                try {
                    RMIConnector.this.connection.getDefaultDomain(null);
                }
                catch (IOException iOException2) {
                    boolean bl = false;
                    java.lang.Object object = this;
                    synchronized (object) {
                        if (!RMIConnector.this.terminated) {
                            RMIConnector.this.terminated = true;
                            bl = true;
                        }
                    }
                    if (!bl) break block12;
                    object = new JMXConnectionNotification("jmx.remote.connection.failed", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Failed to communicate with the server: " + iOException.toString(), iOException);
                    RMIConnector.this.sendNotification((Notification)object);
                    try {
                        RMIConnector.this.close(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (iOException instanceof ServerException) {
                Throwable throwable = ((ServerException)iOException).detail;
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            throw iOException;
        }

        public void reconnectNotificationListeners(ClientListenerInfo[] clientListenerInfoArray) throws IOException {
            int n;
            int n2 = clientListenerInfoArray.length;
            ClientListenerInfo[] clientListenerInfoArray2 = new ClientListenerInfo[n2];
            Subject[] subjectArray = new Subject[n2];
            ObjectName[] objectNameArray = new ObjectName[n2];
            NotificationListener[] notificationListenerArray = new NotificationListener[n2];
            NotificationFilter[] notificationFilterArray = new NotificationFilter[n2];
            MarshalledObject[] marshalledObjectArray = new MarshalledObject[n2];
            java.lang.Object[] objectArray = new java.lang.Object[n2];
            for (n = 0; n < n2; ++n) {
                subjectArray[n] = clientListenerInfoArray[n].getDelegationSubject();
                objectNameArray[n] = clientListenerInfoArray[n].getObjectName();
                notificationListenerArray[n] = clientListenerInfoArray[n].getListener();
                notificationFilterArray[n] = clientListenerInfoArray[n].getNotificationFilter();
                marshalledObjectArray[n] = new MarshalledObject<NotificationFilter>(notificationFilterArray[n]);
                objectArray[n] = clientListenerInfoArray[n].getHandback();
            }
            try {
                Integer[] integerArray = RMIConnector.this.addListenersWithSubjects(objectNameArray, marshalledObjectArray, subjectArray, false);
                for (n = 0; n < n2; ++n) {
                    clientListenerInfoArray2[n] = new ClientListenerInfo(integerArray[n], objectNameArray[n], notificationListenerArray[n], notificationFilterArray[n], objectArray[n], subjectArray[n]);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clientListenerInfoArray2);
                return;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                java.lang.Object object;
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    try {
                        object = RMIConnector.this.addListenerWithSubject(objectNameArray[n], new MarshalledObject<NotificationFilter>(notificationFilterArray[n]), subjectArray[n], false);
                        clientListenerInfoArray2[n3++] = new ClientListenerInfo((Integer)object, objectNameArray[n], notificationListenerArray[n], notificationFilterArray[n], objectArray[n], subjectArray[n]);
                        continue;
                    }
                    catch (InstanceNotFoundException instanceNotFoundException2) {
                        logger.warning("reconnectNotificationListeners", "Can't reconnect listener for " + objectNameArray[n]);
                    }
                }
                if (n3 != n2) {
                    object = clientListenerInfoArray2;
                    clientListenerInfoArray2 = new ClientListenerInfo[n3];
                    System.arraycopy(object, 0, clientListenerInfoArray2, 0, n3);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clientListenerInfoArray2);
                return;
            }
        }

        protected void checkConnection() throws IOException {
            if (logger.debugOn()) {
                logger.debug("RMIClientCommunicatorAdmin-checkConnection", "Calling the method getDefaultDomain.");
            }
            RMIConnector.this.connection.getDefaultDomain(null);
        }

        protected void doStart() throws IOException {
            RMIServer rMIServer = null;
            try {
                rMIServer = RMIConnector.this.rmiServer != null ? RMIConnector.this.rmiServer : RMIConnector.this.findRMIServer(RMIConnector.this.jmxServiceURL, RMIConnector.this.env);
            }
            catch (NamingException namingException) {
                throw new IOException("Failed to get a RMI stub: " + namingException);
            }
            rMIServer = RMIConnector.connectStub(rMIServer, RMIConnector.this.env);
            java.lang.Object v = RMIConnector.this.env.get("jmx.remote.credentials");
            RMIConnector.this.connection = rMIServer.newClient(v);
            ClientListenerInfo[] clientListenerInfoArray = RMIConnector.this.rmiNotifClient.preReconnection();
            this.reconnectNotificationListeners(clientListenerInfoArray);
            RMIConnector.this.connectionId = RMIConnector.this.getConnectionId();
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.opened", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Reconnected to server", null);
            RMIConnector.this.sendNotification(jMXConnectionNotification);
        }

        protected void doStop() {
            try {
                RMIConnector.this.close();
            }
            catch (IOException iOException) {
                logger.warning("RMIClientCommunicatorAdmin-doStop", "Failed to call the method close():" + iOException);
                logger.debug("RMIClientCommunicatorAdmin-doStop", iOException);
            }
        }
    }

    private class RMINotifClient
    extends ClientNotifForwarder {
        public RMINotifClient(ClassLoader classLoader, Map map) {
            super(classLoader, map);
        }

        protected NotificationResult fetchNotifs(long l, int n, long l2) throws IOException, ClassNotFoundException {
            while (true) {
                try {
                    return RMIConnector.this.connection.fetchNotifications(l, n, l2);
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    try {
                        RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                    }
                    catch (IOException iOException3) {
                        if (iOException2 instanceof UnmarshalException) {
                            UnmarshalException unmarshalException = (UnmarshalException)iOException2;
                            if (unmarshalException.detail instanceof ClassNotFoundException) {
                                throw (ClassNotFoundException)unmarshalException.detail;
                            }
                            if (unmarshalException.detail instanceof WriteAbortedException) {
                                WriteAbortedException writeAbortedException = (WriteAbortedException)unmarshalException.detail;
                                if (writeAbortedException.detail instanceof IOException) {
                                    throw (IOException)writeAbortedException.detail;
                                }
                            }
                        } else if (iOException2 instanceof MarshalException) {
                            MarshalException marshalException = (MarshalException)iOException2;
                            if (marshalException.detail instanceof NotSerializableException) {
                                throw (NotSerializableException)marshalException.detail;
                            }
                        }
                        throw iOException2;
                    }
                }
            }
        }

        protected Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException {
            Integer[] integerArray;
            MarshalledObject<NotificationFilterSupport> marshalledObject = null;
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("JMX.mbean.unregistered");
            marshalledObject = new MarshalledObject<NotificationFilterSupport>(notificationFilterSupport);
            ObjectName[] objectNameArray = new ObjectName[]{MBeanServerDelegate.DELEGATE_NAME};
            MarshalledObject[] marshalledObjectArray = new MarshalledObject[]{marshalledObject};
            Subject[] subjectArray = new Subject[]{null};
            try {
                integerArray = RMIConnector.this.connection.addNotificationListeners(objectNameArray, marshalledObjectArray, subjectArray);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                integerArray = RMIConnector.this.connection.addNotificationListeners(objectNameArray, marshalledObjectArray, subjectArray);
            }
            return integerArray[0];
        }

        protected void removeListenerForMBeanRemovedNotif(Integer n) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
            try {
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{n}, null);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{n}, null);
            }
        }

        protected void lostNotifs(String string, long l) {
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", RMIConnector.this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifCounter++, string, new Long(l));
            RMIConnector.this.sendNotification(jMXConnectionNotification);
        }
    }

    private class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private Subject delegationSubject;

        public RemoteMBeanServerConnection() {
            this(null);
        }

        public RemoteMBeanServerConnection(Subject subject) {
            this.delegationSubject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "className=" + string + ", name=" + objectName);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "className=" + string + ", name=" + objectName + ", loaderName=" + objectName2 + ")");
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, objectName2, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, objectName2, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String string, ObjectName objectName, java.lang.Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "className=" + string + ", name=" + objectName + ", params=" + RMIConnector.objects(objectArray) + ", signature=" + RMIConnector.strings(stringArray));
            }
            MarshalledObject<java.lang.Object[]> marshalledObject = new MarshalledObject<java.lang.Object[]>(objectArray);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, marshalledObject, stringArray, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, marshalledObject, stringArray, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, java.lang.Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "className=" + string + ", name=" + objectName + ", loaderName=" + objectName2 + ", params=" + RMIConnector.objects(objectArray) + ", signature=" + RMIConnector.strings(stringArray));
            }
            MarshalledObject<java.lang.Object[]> marshalledObject = new MarshalledObject<java.lang.Object[]>(objectArray);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, objectName2, marshalledObject, stringArray, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(string, objectName, objectName2, marshalledObject, stringArray, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "name=" + objectName);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.unregisterMBean(objectName, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.unregisterMBean(objectName, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "name=" + objectName);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(objectName, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(objectName, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryMBeans", "name=" + objectName + ", query=" + queryExp);
            }
            MarshalledObject<QueryExp> marshalledObject = new MarshalledObject<QueryExp>(queryExp);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(objectName, marshalledObject, this.delegationSubject);
                return set;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(objectName, marshalledObject, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryNames", "name=" + objectName + ", query=" + queryExp);
            }
            MarshalledObject<QueryExp> marshalledObject = new MarshalledObject<QueryExp>(queryExp);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(objectName, marshalledObject, this.delegationSubject);
                return set;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(objectName, marshalledObject, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRegistered(ObjectName objectName) throws IOException {
            if (logger.debugOn()) {
                logger.debug("isRegistered", "name=" + objectName);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isRegistered(objectName, this.delegationSubject);
                return bl;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                boolean bl = RMIConnector.this.connection.isRegistered(objectName, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer getMBeanCount() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "");
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public java.lang.Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttribute", "name=" + objectName + ", attribute=" + string);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                java.lang.Object object = RMIConnector.this.connection.getAttribute(objectName, string, this.delegationSubject);
                return object;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                java.lang.Object object = RMIConnector.this.connection.getAttribute(objectName, string, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttributes", "name=" + objectName + ", attributes=" + RMIConnector.strings(stringArray));
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(objectName, stringArray, this.delegationSubject);
                return attributeList;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(objectName, stringArray, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttribute", "name=" + objectName + ", attribute=" + attribute);
            }
            MarshalledObject<Attribute> marshalledObject = new MarshalledObject<Attribute>(attribute);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.setAttribute(objectName, marshalledObject, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.setAttribute(objectName, marshalledObject, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttributes", "name=" + objectName + ", attributes=" + attributeList);
            }
            MarshalledObject<AttributeList> marshalledObject = new MarshalledObject<AttributeList>(attributeList);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList2 = RMIConnector.this.connection.setAttributes(objectName, marshalledObject, this.delegationSubject);
                return attributeList2;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                AttributeList attributeList3 = RMIConnector.this.connection.setAttributes(objectName, marshalledObject, this.delegationSubject);
                return attributeList3;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public java.lang.Object invoke(ObjectName objectName, String string, java.lang.Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("invoke", "name=" + objectName + ", operationName=" + string + ", params=" + RMIConnector.objects(objectArray) + ", signature=" + RMIConnector.strings(stringArray));
            }
            MarshalledObject<java.lang.Object[]> marshalledObject = new MarshalledObject<java.lang.Object[]>(objectArray);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                java.lang.Object object = RMIConnector.this.connection.invoke(objectName, string, marshalledObject, stringArray, this.delegationSubject);
                return object;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                java.lang.Object object = RMIConnector.this.connection.invoke(objectName, string, marshalledObject, stringArray, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDefaultDomain() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "");
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getDomains() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDomains", "");
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "name=" + objectName);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(objectName, this.delegationSubject);
                return mBeanInfo;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(objectName, this.delegationSubject);
                return mBeanInfo;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "name=" + objectName + ", className=" + string);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isInstanceOf(objectName, string, this.delegationSubject);
                return bl;
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                boolean bl = RMIConnector.this.connection.isInstanceOf(objectName, string, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, java.lang.Object object) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + objectName + ", listener=" + objectName2 + ", filter=" + notificationFilter + ", handback=" + object);
            }
            MarshalledObject<NotificationFilter> marshalledObject = new MarshalledObject<NotificationFilter>(notificationFilter);
            MarshalledObject<java.lang.Object> marshalledObject2 = new MarshalledObject<java.lang.Object>(object);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.addNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.addNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "name=" + objectName + ", listener=" + objectName2);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(objectName, objectName2, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.removeNotificationListener(objectName, objectName2, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, java.lang.Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + objectName + ", listener=" + objectName2 + ", filter=" + notificationFilter + ", handback=" + object);
            }
            MarshalledObject<NotificationFilter> marshalledObject = new MarshalledObject<NotificationFilter>(notificationFilter);
            MarshalledObject<java.lang.Object> marshalledObject2 = new MarshalledObject<java.lang.Object>(object);
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.removeNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, java.lang.Object object) throws InstanceNotFoundException, IOException {
            boolean bl = logger.debugOn();
            if (bl) {
                logger.debug("addNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + objectName + ", listener=" + notificationListener + ", filter=" + notificationFilter + ", handback=" + object);
            }
            Integer n = RMIConnector.this.addListenerWithSubject(objectName, new MarshalledObject<NotificationFilter>(notificationFilter), this.delegationSubject, true);
            RMIConnector.this.rmiNotifClient.addNotificationListener(n, objectName, notificationListener, notificationFilter, object, this.delegationSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean bl = logger.debugOn();
            if (bl) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener)", "name=" + objectName + ", listener=" + notificationListener);
            }
            java.lang.Object[] objectArray = RMIConnector.this.rmiNotifClient.removeNotificationListener(objectName, notificationListener);
            if (bl) {
                logger.debug("removeNotificationListener", "listenerIDs=" + RMIConnector.objects(objectArray));
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(objectName, (Integer[])objectArray, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.removeNotificationListeners(objectName, (Integer[])objectArray, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, java.lang.Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean bl = logger.debugOn();
            if (bl) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + objectName + ", listener=" + notificationListener + ", filter=" + notificationFilter + ", handback=" + object);
            }
            Integer n = RMIConnector.this.rmiNotifClient.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
            if (bl) {
                logger.debug("removeNotificationListener", "listenerID=" + n);
            }
            ClassLoader classLoader = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(objectName, new Integer[]{n}, this.delegationSubject);
            }
            catch (IOException iOException) {
                RMIConnector.this.communicatorAdmin.gotIOException(iOException);
                RMIConnector.this.connection.removeNotificationListeners(objectName, new Integer[]{n}, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(classLoader);
            }
        }
    }
}

