/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.figure;

import aurora.ide.meta.gef.editors.components.figure.TreeLayoutManager;
import aurora.ide.meta.gef.editors.components.figure.TreeNodeFigure;
import aurora.plugin.source.gen.screen.model.Point;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class TreeContainerLayoutManager
extends AbstractLayout {
    public Object getConstraint(IFigure child) {
        return super.getConstraint(child);
    }

    private Dimension getNodeSize(IFigure node) {
        if (node instanceof TreeNodeFigure) {
            Point size = ((TreeNodeFigure)node).getTreeNode().getSize();
            Dimension nodeSize = new Dimension(size.x, size.y);
            return nodeSize;
        }
        return node.getSize();
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        IFigure parent = child.getParent();
        if (parent == null) {
            parent = (IFigure)constraint;
        }
        Dimension newSize = new Dimension();
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure node = (IFigure)children.get(i);
            if (node instanceof TreeNodeFigure) {
                Dimension nodeSize = this.getNodeSize(node);
                newSize.width = newSize.width >= nodeSize.width + 15 ? newSize.width : nodeSize.width + 15;
                newSize.height += nodeSize.height;
            }
            ++i;
        }
        IFigure god = parent.getParent();
        newSize.height += 24;
        if (newSize.width == 0) {
            newSize.width = 150;
        }
        parent.setSize(newSize);
        if (constraint instanceof IFigure) {
            this.layout(parent);
        }
        god.getLayoutManager().setConstraint(parent, constraint);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        Dimension result = this.getNodeSize(container);
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.getNodeSize(child);
            childSize.expand(child.getBounds().getLocation());
            result.union(childSize);
            ++i;
        }
        return result;
    }

    public void layout(IFigure container) {
        List trees = container.getChildren();
        IFigure temp = null;
        for (IFigure treeNode : trees) {
            treeNode.getBounds();
            org.eclipse.draw2d.geometry.Point location = TreeLayoutManager.NODE_RELATIVE_LOCATION.getCopy();
            Dimension size = this.getNodeSize(treeNode);
            if (temp != null) {
                Rectangle lastBounds = temp.getBounds();
                location = lastBounds.getBottomLeft().getCopy();
                location = new org.eclipse.draw2d.geometry.Point(location.x, location.y);
            } else {
                location.translate(container.getBounds().getLocation());
            }
            if (size.equals(0, 0)) {
                treeNode.setSize(TreeLayoutManager.NODE_DEFUAULT_SIZE);
            }
            treeNode.getBounds().setLocation(location);
            temp = treeNode;
            LayoutManager layoutManager = treeNode.getLayoutManager();
            if (layoutManager == null) continue;
            layoutManager.layout(treeNode);
        }
        container.repaint();
    }

    private int getTreeLevel(IFigure temp) {
        List children = temp.getChildren();
        int level = 0;
        int childLevel = 0;
        int i = 0;
        while (i < children.size()) {
            level = 1;
            IFigure child = (IFigure)children.get(i);
            int treeLevel = this.getTreeLevel(child);
            childLevel = childLevel >= treeLevel ? childLevel : treeLevel;
            ++i;
        }
        return level + childLevel;
    }
}

