/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.test;

import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class SaveAsImageAction {
    public static final String ID = "aurora.ide.meta.gef.editors.actions.SaveAsImageAction";
    private ScalableRootEditPart rootEditPart;

    public SaveAsImageAction(ScalableRootEditPart rootEditPart) {
        this.rootEditPart = rootEditPart;
    }

    public void run() {
        double zoom = this.rootEditPart.getZoomManager().getZoom();
        try {
            try {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFileName("aaa.png");
                dialog.setOverwrite(true);
                dialog.setFilterExtensions(new String[]{"*.png", "*.bmp", "*.jpg", "*.jpeg"});
                String file = dialog.open();
                if (file != null) {
                    IFigure figure = this.getRootFigure(this.rootEditPart);
                    Rectangle rectangle = this.calBounds(figure);
                    Image image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
                    GC gc = new GC((Drawable)image);
                    SWTGraphics graphics = new SWTGraphics(gc);
                    figure.paint((Graphics)graphics);
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData()};
                    if (file.endsWith(".bmp")) {
                        loader.save(file, 0);
                    } else if (file.endsWith(".jpg") || file.endsWith(".jpeg")) {
                        loader.save(file, 4);
                    } else if (file.endsWith(".png")) {
                        loader.save(file, 5);
                    } else {
                        file = String.valueOf(file) + ".bmp";
                        loader.save(file, 0);
                    }
                    image.dispose();
                    gc.dispose();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.rootEditPart.getZoomManager().setZoom(zoom);
            }
        }
        finally {
            this.rootEditPart.getZoomManager().setZoom(zoom);
        }
    }

    public IFigure getRootFigure(ScalableRootEditPart rootEditPart) {
        Object object;
        List children = rootEditPart.getChildren();
        if (children.size() > 0 && (object = children.get(0)) instanceof ViewDiagramPart) {
            return ((ViewDiagramPart)object).getFigure();
        }
        return rootEditPart.getLayer((Object)"Printable Layers");
    }

    public Rectangle calBounds(IFigure figure) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        List children = figure.getChildren();
        for (Object object : children) {
            if (!(object instanceof IFigure)) continue;
            Rectangle b = ((IFigure)object).getBounds();
            r.union(b);
        }
        return r.expand(10, 10);
    }
}

