/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.editor;

import aurora.ide.editor.editorInput.PathEditorInput;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.meta.gef.editors.consultant.property.FSDPropertyFactory;
import aurora.ide.prototype.consultant.editor.ComponentFilter;
import aurora.ide.prototype.consultant.editor.Messages;
import aurora.ide.prototype.consultant.editor.ScreenBodyContentProvider;
import aurora.ide.prototype.consultant.editor.ScreenBodyLabelProvider;
import aurora.ide.prototype.consultant.editor.TabBodyFilter;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;

public class FSDEditor
extends EditorPart
implements ISelectionChangedListener {
    public static final String EDITOR_ID = "aurora.ide.prototype.consultant.editor.FSDEditor";
    private IEditorInput input;
    private ScreenBody diagram;
    private FSDPropertyFactory editablePropertyFactory = new FSDPropertyFactory();
    private Composite propertyComposite;
    private boolean isDirty;
    private TreeViewer viewer;

    public void doSave(IProgressMonitor monitor) {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof PathEditorInput) {
            PathEditorInput pei = (PathEditorInput)editorInput;
            IPath path = pei.getPath();
            File file = path.toFile();
            try {
                file.createNewFile();
                if (file.exists() && file.canWrite()) {
                    Object2CompositeMap o2c = new Object2CompositeMap();
                    CompositeMap map = o2c.createCompositeMap(this.diagram);
                    XMLOutputter.saveToFile((File)file, (CompositeMap)map);
                    this.updateEditorStatus(false);
                }
            }
            catch (IOException iOException) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Info", (String)Messages.FSDEditor_2);
            }
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.input = input;
        if (input instanceof PathEditorInput) {
            File file = ((PathEditorInput)input).getPath().toFile();
            CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
            if (loadFile != null) {
                CompositeMap2Object c2o = new CompositeMap2Object();
                this.diagram = c2o.createScreenBody(loadFile);
            } else {
                this.diagram = new ScreenBody();
            }
        }
        String lastSegment = ((PathEditorInput)input).getPath().removeFileExtension().lastSegment();
        this.setPartName(lastSegment);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer((Composite)sashForm);
        this.createPropertyView((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 4});
    }

    private void createPropertyView(Composite sashForm) {
        this.propertyComposite = new Composite(sashForm, 0);
        this.propertyComposite.setLayout((Layout)new GridLayout());
        IPropertyDescriptor[] pds = this.editablePropertyFactory.createPropertyDescriptors((AuroraComponent)this.diagram);
        this.createPropertyControl((AuroraComponent)this.diagram, pds);
    }

    private void createTreeViewer(Composite sashForm) {
        Composite treeViewerComposite = new Composite(sashForm, 0);
        treeViewerComposite.setLayout((Layout)new GridLayout());
        FilteredTree ff = new FilteredTree(treeViewerComposite, 2818, new PatternFilter(), true);
        this.viewer = ff.getViewer();
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ScreenBodyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(new StyledLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.viewer.addFilter((ViewerFilter)new ComponentFilter(new String[]{"gridselectioncol", "navbar"}));
        this.viewer.addFilter((ViewerFilter)new TabBodyFilter());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setInput((Object)this.diagram);
    }

    public void setFocus() {
    }

    public IPropertyDescriptor[] getFSDPropertyDescriptors(AuroraComponent object) {
        IPropertyDescriptor[] pd = this.editablePropertyFactory.createPropertyDescriptors(object);
        return pd;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object firstElement = selection.getFirstElement();
        firstElement = firstElement == null ? this.diagram : firstElement;
        IPropertyDescriptor[] pds = this.editablePropertyFactory.createPropertyDescriptors((AuroraComponent)firstElement);
        this.createPropertyControl((AuroraComponent)firstElement, pds);
    }

    private void createPropertyControl(AuroraComponent ac, IPropertyDescriptor[] pds) {
        Control[] children;
        Control[] controlArray = children = this.propertyComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            org.eclipse.swt.widgets.Listener[] listeners = control.getListeners(24);
            int i = 0;
            while (i < listeners.length) {
                control.removeListener(24, listeners[i]);
                ++i;
            }
            control.dispose();
            ++n2;
        }
        controlArray = pds;
        n = pds.length;
        n2 = 0;
        while (n2 < n) {
            Control pd = controlArray[n2];
            CellEditor ce = pd.createPropertyEditor(this.propertyComposite);
            ce.create(this.propertyComposite);
            Control control = ce.getControl();
            if (control instanceof Text) {
                ((Text)control).setText(ac.getStringPropertyValue("" + pd.getId()));
            }
            if (control instanceof Combo) {
                String pp = ac.getStringPropertyValue("" + pd.getId());
                int indexOf = ((Combo)control).indexOf(pp);
                ((Combo)control).select(indexOf == -1 ? 0 : indexOf);
            }
            TypedListener typedListener = new TypedListener((SWTEventListener)new Listener(ac, (IPropertyDescriptor)pd));
            control.addListener(24, (org.eclipse.swt.widgets.Listener)typedListener);
            ++n2;
        }
        this.propertyComposite.layout();
    }

    public void updateFSDProperty(IPropertyDescriptor pd, String text, AuroraComponent ac) {
        ac.setPropertyValue("" + pd.getId(), (Object)text);
        this.viewer.refresh((Object)ac);
        this.updateEditorStatus(true);
    }

    protected void updateEditorStatus(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }

    private class LabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public LabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
            super(labelProvider, decorator, decorationContext);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }
    }

    private class Listener
    implements ModifyListener {
        private IPropertyDescriptor pd;
        private AuroraComponent ac;

        private Listener(AuroraComponent ac, IPropertyDescriptor pd) {
            this.pd = pd;
            this.ac = ac;
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source instanceof Text) {
                FSDEditor.this.updateFSDProperty(this.pd, ((Text)source).getText(), this.ac);
            }
            if (source instanceof Combo) {
                FSDEditor.this.updateFSDProperty(this.pd, ((Combo)source).getText(), this.ac);
            }
        }
    }

    private class StyledLabelProvider
    extends ScreenBodyLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private StyledLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            String text = super.getText(element);
            StyledString s = new StyledString();
            s.append(text);
            if (element instanceof AuroraComponent) {
                IPropertyDescriptor[] pds = FSDEditor.this.editablePropertyFactory.createPropertyDescriptors((AuroraComponent)element);
                boolean setting = false;
                IPropertyDescriptor[] iPropertyDescriptorArray = pds;
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
                    Object propertyValue = ((AuroraComponent)element).getPropertyValue("" + pd.getId());
                    if (propertyValue != null && !"".equals(propertyValue)) {
                        setting = true;
                        break;
                    }
                    ++n2;
                }
                if (!setting) {
                    s.append("  ").append("[ " + Messages.FSDEditor_9 + " ]", StyledString.DECORATIONS_STYLER);
                }
            }
            return s;
        }
    }
}

