/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.action;

import aurora.ide.meta.gef.editors.ConsultantVScreenEditor;
import aurora.ide.meta.gef.editors.consultant.property.ConsultantPropertyManager;
import aurora.ide.meta.gef.editors.consultant.property.FSDPropertyWizard;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.prototype.consultant.product.action.Messages;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class FSDPropertyEditAction
extends SelectionAction {
    public static final String ID = "aurora.ide.meta.gef.editors.actions.FSDPropertyEditAction";
    private GraphicalEditor editor;
    private ConsultantPropertyManager propertyManager;

    public FSDPropertyEditAction(GraphicalEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        if (this.editor instanceof ConsultantVScreenEditor) {
            this.propertyManager = ((ConsultantVScreenEditor)this.editor).getPropertyManager();
        }
        this.setId(ID);
        this.setText(Messages.FSDPropertyEditAction_1);
    }

    public void run() {
        Shell shell = this.editor.getSite().getShell();
        FSDPropertyWizard wd = new FSDPropertyWizard(shell, this.getValues(this.getPropertyDescs()));
        int open = wd.open();
        if (open == 0) {
            Map values = wd.getValues();
            Set keySet = values.keySet();
            AuroraComponent ac = this.getAuroraComponent();
            if (ac == null) {
                return;
            }
            for (IPropertyDescriptor pd : keySet) {
                this.propertyManager.setPropertyValue(pd.getId(), values.get(pd), ac);
            }
        }
    }

    private AuroraComponent getAuroraComponent() {
        List selectedObjects = this.getSelectedObjects();
        Object object = selectedObjects.get(0);
        if (object instanceof ComponentPart) {
            return ((ComponentPart)object).getComponent();
        }
        return null;
    }

    protected boolean calculateEnabled() {
        IPropertyDescriptor[] fds;
        List selectedObjects = this.getSelectedObjects();
        if (selectedObjects.size() != 1) {
            return false;
        }
        Object object = selectedObjects.get(0);
        return object instanceof ComponentPart && this.propertyManager != null && (fds = this.propertyManager.getFSDPropertyDescriptors((ComponentPart)object)).length > 0;
    }

    private Map<IPropertyDescriptor, String> getValues(IPropertyDescriptor[] pds) {
        HashMap<IPropertyDescriptor, String> values = new HashMap<IPropertyDescriptor, String>();
        List selectedObjects = this.getSelectedObjects();
        Object object = selectedObjects.get(0);
        if (object instanceof ComponentPart) {
            IPropertyDescriptor[] iPropertyDescriptorArray = pds;
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
                String s = ((ComponentPart)object).getComponent().getStringPropertyValue("" + pd.getId());
                values.put(pd, s);
                ++n2;
            }
        }
        return values;
    }

    private IPropertyDescriptor[] getPropertyDescs() {
        List selectedObjects = this.getSelectedObjects();
        Object object = selectedObjects.get(0);
        if (object instanceof ComponentPart && this.propertyManager != null) {
            IPropertyDescriptor[] fds = this.propertyManager.getFSDPropertyDescriptors((ComponentPart)object);
            return fds;
        }
        return new IPropertyDescriptor[0];
    }
}

