/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.meta.gef.util.ComponentUtil;
import aurora.ide.prototype.consultant.product.demonstrate.DemonstrateSettingManager;
import aurora.ide.prototype.consultant.product.demonstrate.Messages;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.DemonstrateBind;
import aurora.plugin.source.gen.screen.model.Grid;
import aurora.plugin.source.gen.screen.model.GridColumn;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DemonstrateLOVPage
extends WizardPage {
    private List<Data> input = new ArrayList<Data>();
    private TableViewer tableViewer;
    private String[] items;
    private static final String[] editors = new String[]{"", "textField", "numberField", "comboBox", "lov", "datePicker"};
    private List<AuroraComponent> bindComponents = new ArrayList<AuroraComponent>();
    private DemonstrateSettingManager sm;

    public DemonstrateLOVPage(String pageName, DemonstrateSettingManager sm) {
        super(pageName);
        this.setTitle(Messages.DemonstrateLOVPage_1);
        this.setMessage(Messages.DemonstrateLOVPage_2);
        this.sm = sm;
        List inputs = (List)sm.getDemonstrateData().getPropertyValue("bind_component");
        if (inputs != null) {
            for (DemonstrateBind db : inputs) {
                this.input.add(new Data(db));
            }
        }
        this.items = this.getBindItems();
    }

    public List<DemonstrateBind> getBindModels() {
        ArrayList<DemonstrateBind> r = new ArrayList<DemonstrateBind>();
        for (Data d : this.input) {
            r.add(d.db);
        }
        return r;
    }

    public void createControl(Composite parentComposite) {
        Composite container = new Composite(parentComposite, 0);
        container.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer(container, 68096);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc1 = new TableColumn(table, 16384);
        tc1.setText(Messages.DemonstrateLOVPage_3);
        tc1.setWidth(250);
        TableColumn tc22 = new TableColumn(table, 0x1000000);
        tc22.setText(Messages.DemonstrateLOVPage_4);
        tc22.setWidth(80);
        TableColumn tc2 = new TableColumn(table, 0x1000000);
        tc2.setText(Messages.DemonstrateLOVPage_5);
        tc2.setWidth(80);
        TableColumn tc3 = new TableColumn(table, 0x1000000);
        tc3.setText(Messages.DemonstrateLOVPage_6);
        tc3.setWidth(80);
        this.tableViewer.setColumnProperties(new String[]{"11", "222", "22", "33"});
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput(this.input);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable(), 68), new CheckboxCellEditor((Composite)this.tableViewer.getTable()), new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), editors, 8), new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), this.items, 8)};
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new MyCellModifier());
        Composite btnBar = new Composite(container, 0);
        btnBar.setLayout((Layout)new GridLayout(2, false));
        Button btnAdd = new Button(btnBar, 0);
        btnAdd.setText(" + ");
        btnAdd.setLayoutData((Object)new GridData());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Data d = new Data(new DemonstrateBind());
                d.setAttr1("");
                DemonstrateLOVPage.this.input.add(d);
                DemonstrateLOVPage.this.tableViewer.refresh();
            }
        });
        Button btnSub = new Button(btnBar, 0);
        btnSub.setText(" - ");
        btnSub.setLayoutData((Object)new GridData());
        btnSub.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection select = (StructuredSelection)DemonstrateLOVPage.this.tableViewer.getSelection();
                Data d = (Data)select.getFirstElement();
                if (d == null) {
                    return;
                }
                DemonstrateLOVPage.this.input.remove(d);
                DemonstrateLOVPage.this.tableViewer.refresh();
            }
        });
        this.setControl((Control)container);
    }

    protected String[] getBindItems() {
        if (this.items == null) {
            AuroraComponent ac = this.sm.getAuroraComponent();
            if ("gridcolumn".equals(ac.getComponentType())) {
                Grid grid = ComponentUtil.findParentGrid((AuroraComponent)ac);
                List gridColumns = ComponentUtil.getGridColumns((GridColumn)grid);
                for (GridColumn gridColumn : gridColumns) {
                    this.bindComponents.add((AuroraComponent)gridColumn);
                }
            } else {
                Container notHVBoxParent = ComponentUtil.getNotHVBoxParent((AuroraComponent)ac);
                List allInputChildren = ComponentUtil.getAllInputChildren((Container)notHVBoxParent);
                for (AuroraComponent auroraComponent : allInputChildren) {
                    this.bindComponents.add(auroraComponent);
                }
            }
            this.items = new String[this.bindComponents.size() + 1];
            this.items[0] = "";
            int i = 1;
            while (i < this.items.length) {
                this.items[i] = this.bindComponents.get(i - 1).getPrompt();
                ++i;
            }
        }
        return this.items;
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class Data {
        private DemonstrateBind db;

        public Data(DemonstrateBind db) {
            this.db = db;
        }

        public String getAttr1() {
            return this.db.getColumnPrompt();
        }

        public void setAttr22(boolean attr22) {
            this.db.setForDisplay(attr22);
        }

        public boolean isAttr22() {
            return this.db.isForDisplay();
        }

        public void setAttr1(String attr1) {
            this.db.setColumnPrompt(attr1);
        }

        public String getAttr2() {
            return this.db.getForQueryEditor();
        }

        public void setAttr2(String attr2) {
            this.db.setForQueryEditor(attr2);
        }

        public AuroraComponent getAttr3() {
            AuroraComponent bindModel = this.db.getBindModel();
            for (AuroraComponent bc : DemonstrateLOVPage.this.bindComponents) {
                if (!bc.equals(bindModel)) continue;
                return bindModel;
            }
            return null;
        }

        public void setAttr3(AuroraComponent attr3) {
            this.db.setBindModel(attr3);
        }

        public int getEditorIndex() {
            int i = 0;
            while (i < editors.length) {
                if (editors[i].equals(this.getAttr2())) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void setEditorIndex(int i) {
            this.setAttr2(editors[i]);
        }

        public int getBindIndex() {
            int i = 0;
            while (i < DemonstrateLOVPage.this.bindComponents.size()) {
                if (((AuroraComponent)DemonstrateLOVPage.this.bindComponents.get(i)).equals(this.getAttr3())) {
                    return i + 1;
                }
                ++i;
            }
            return 0;
        }

        public void setBindIndex(int i) {
            String[] bindItems = DemonstrateLOVPage.this.getBindItems();
            if (i > 0 && bindItems.length - i > 0) {
                this.setAttr3((AuroraComponent)DemonstrateLOVPage.this.bindComponents.get(i - 1));
            } else {
                this.setAttr3(null);
            }
        }
    }

    class MyCellModifier
    implements ICellModifier {
        MyCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            Data d = (Data)element;
            if (property.equals("11")) {
                return d.getAttr1();
            }
            if (property.equals("222")) {
                return d.isAttr22();
            }
            if (property.equals("22")) {
                return d.getEditorIndex();
            }
            if (property.equals("33")) {
                return d.getBindIndex();
            }
            return -1;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            Data d = (Data)element;
            if (property.equals("11")) {
                d.setAttr1(value.toString());
            } else if (property.equals("222")) {
                d.setAttr22(Boolean.parseBoolean(value.toString()));
            } else if (property.equals("22")) {
                d.setEditorIndex((Integer)value);
            } else if (property.equals("33")) {
                d.setBindIndex((Integer)value);
            }
            DemonstrateLOVPage.this.tableViewer.refresh();
        }
    }

    class TableLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Data d = (Data)element;
            if (columnIndex == 0) {
                return d.getAttr1();
            }
            if (columnIndex == 1) {
                return Boolean.toString(d.isAttr22());
            }
            if (columnIndex == 2) {
                return d.getAttr2();
            }
            if (columnIndex == 3) {
                AuroraComponent attr3 = d.getAttr3();
                return attr3 == null ? "" : attr3.getPrompt();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Data cfr_ignored_0 = (Data)element;
            return null;
        }
    }
}

