/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.figures.ViewDiagramLayout;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import aurora.ide.meta.gef.editors.wizard.dialog.DemonstratingDialog;
import aurora.ide.prototype.consultant.demonstrate.DemonstrateEditorMode;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import java.io.File;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import uncertain.composite.CompositeMap;

public class LoginDiagramPart
extends ViewDiagramPart {
    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer(){

            public void paint(Graphics graphics) {
                Image image = LoginDiagramPart.this.getImage();
                if (image != null) {
                    ImageFigure imageFigure = new ImageFigure();
                    imageFigure.setImage(image);
                    imageFigure.setSize(this.getSize());
                    imageFigure.setOpaque(true);
                    imageFigure.paint(graphics);
                }
                super.paint(graphics);
            }
        };
        ViewDiagramLayout manager = new ViewDiagramLayout(false, (ComponentPart)this);
        figure.setLayoutManager((LayoutManager)manager);
        return figure;
    }

    private Image getImage() {
        EditorMode editorMode = this.getEditorMode();
        if (editorMode instanceof DemonstrateEditorMode) {
            byte[] iconByteData;
            DemonstratingDialog demonstratingDialog = ((DemonstrateEditorMode)editorMode).getDemonstratingDialog();
            File project = demonstratingDialog.getProject();
            CompositeMap loadDemonProperties = ResourceUtil.loadDemonProperties(project);
            if (loadDemonProperties == null) {
                return null;
            }
            CompositeMap child = loadDemonProperties.getChild("login_img");
            if (child != null && child.getText() != null && !"".equals(child.getText()) && (iconByteData = AuroraImagesUtils.toBytes((String)child.getText())) != null) {
                ImageData idd = AuroraImagesUtils.toImageData((byte[])iconByteData);
                ImageDescriptor id = ImageDescriptor.createFromImageData((ImageData)idd);
                Image image = id.createImage();
                return image;
            }
        }
        return null;
    }
}

