/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd.wizard;

import aurora.ide.prototype.consultant.product.fsd.wizard.FSDComposite;
import aurora.ide.prototype.consultant.product.fsd.wizard.Messages;
import aurora.ide.swt.util.GridLayoutUtil;
import aurora.ide.swt.util.PageModel;
import aurora.ide.swt.util.TableContentProvider;
import aurora.ide.swt.util.TableLabelProvider;
import aurora.ide.swt.util.TextField;
import aurora.ide.swt.util.WidgetFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uncertain.composite.CompositeMap;

public class FSDContentControl
extends FSDComposite {
    public static final String FSD_TABLE_INPUT = "fsd_table_input";
    public static final String ONLY_SAVE_LOGIC = "only_save_logic";
    public static final String FSD_DOCX_PATH = "fsd_docx_path";
    private IPath base;

    public FSDContentControl(PageModel model, IPath base) {
        super(model);
        this.base = base;
    }

    public void createFSDContentControl(final Composite root) {
        Composite parent = WidgetFactory.composite((Composite)root);
        parent.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        parent.setLayoutData((Object)new GridData(1808));
        Composite pathComposite = WidgetFactory.composite((Composite)parent);
        pathComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_3);
        pathComposite.setLayoutData((Object)new GridData(768));
        final TextField tf = WidgetFactory.createTextButtonField((Composite)pathComposite, (String)Messages.ContentDescPage_0, (String)Messages.ContentDescPage_1);
        tf.addModifyListener((ModifyListener)new FSDComposite.TextModifyListener(FSD_DOCX_PATH, tf.getText()));
        tf.setText(this.getModel().getStringPropertyValue(FSD_DOCX_PATH));
        tf.addButtonClickListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.clickBrowseButton(root.getShell(), tf);
            }
        });
        final Button checked = new Button(parent, 32);
        checked.setLayoutData((Object)new GridData(768));
        checked.setText(Messages.ContentDescPage_3);
        checked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.getModel().setPropertyValue(FSDContentControl.ONLY_SAVE_LOGIC, (Object)checked.getSelection());
            }
        });
        checked.setSelection(this.getModel().getBooleanPropertyValue(ONLY_SAVE_LOGIC).booleanValue());
        this.createContentTable(WidgetFactory.composite((Composite)parent));
    }

    protected void createContentTable(final Composite tableComposite) {
        tableComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_2);
        tableComposite.setLayoutData((Object)new GridData(768));
        final TableViewer tv = new TableViewer(tableComposite, 68352);
        Table table = tv.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableColumn(table);
        tv.setContentProvider((IContentProvider)this.getContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        Composite buttonComposite = WidgetFactory.composite((Composite)tableComposite);
        buttonComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        Button add = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_8);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.clickAddButton(tableComposite.getShell(), tv);
            }
        });
        Button del = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_10);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.clickDelButton(tv);
            }
        });
        Button up = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_11);
        up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.moveElement(tv, -1);
            }
        });
        Button down = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_12);
        down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSDContentControl.this.moveElement(tv, 1);
            }
        });
        tv.setInput(this.getTableInput());
    }

    protected TableContentProvider getContentProvider() {
        return new TableContentProvider();
    }

    protected TableLabelProvider getLabelProvider() {
        return new TableLabelProvider(){

            public String getColumnText(Object element, int i) {
                if (element instanceof String) {
                    if (i == 0) {
                        Path p = new Path(element.toString());
                        return p.lastSegment();
                    }
                    if (i == 1) {
                        return element.toString();
                    }
                }
                return "";
            }
        };
    }

    protected void createTableColumn(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(128);
        column1.setText(Messages.ContentDescPage_5);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setWidth(193);
        column2.setText(Messages.ContentDescPage_6);
    }

    public void moveElement(TableViewer tv, int i) {
        ISelection s = tv.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            String r1 = (String)ss.getFirstElement();
            int idx = this.getTableInput().indexOf(r1);
            if (idx == -1) {
                return;
            }
            int idx2 = idx + i;
            if (idx2 < 0 || idx2 == this.getTableInput().size()) {
                return;
            }
            String r2 = this.getTableInput().get(idx2);
            this.getTableInput().set(idx2, r1);
            this.getTableInput().set(idx, r2);
            tv.setInput(this.getTableInput());
        }
    }

    protected List<String> getTableInput() {
        List propertyValue = (List)this.getModel().getPropertyValue(FSD_TABLE_INPUT);
        return propertyValue;
    }

    protected String getDefaultFileName() {
        PageModel model = this.getModel();
        return model.getPropertyValue("fun_code") + "_" + model.getPropertyValue("fun_name");
    }

    protected void clickBrowseButton(Shell shell, TextField tf) {
        FileDialog sd = new FileDialog(shell, 8192);
        sd.setFileName(this.getDefaultFileName());
        sd.setFilterExtensions(new String[]{"*.docx"});
        sd.setOverwrite(true);
        String open = sd.open();
        if (open == null || open.length() < 1) {
            return;
        }
        tf.setText(open);
    }

    protected void clickAddButton(Shell shell, TableViewer tv) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText("Open File");
        dialog.setFilterExtensions(new String[]{"*.uip"});
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            this.getTableInput().add(path);
        }
        tv.setInput(this.getTableInput());
    }

    protected void clickDelButton(TableViewer tv) {
        ISelection s = tv.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            List list = ss.toList();
            this.getTableInput().removeAll(list);
            tv.setInput(this.getTableInput());
        }
    }

    @Override
    public void saveToMap(CompositeMap map) {
        map.put((Object)ONLY_SAVE_LOGIC, (Object)this.getModel().getBooleanPropertyValue(ONLY_SAVE_LOGIC));
        String docPath = this.getModel().getStringPropertyValue(FSD_DOCX_PATH);
        map.createChild(FSD_DOCX_PATH).setText(this.makeRelative(docPath));
        List propertyValue = (List)this.getModel().getPropertyValue(FSD_TABLE_INPUT);
        String s = "";
        for (String string : propertyValue) {
            s = String.valueOf(s) + "," + this.makeRelative(string);
        }
        s = s.replaceFirst(",", "");
        map.createChild(FSD_TABLE_INPUT).setText(s);
    }

    public String makeRelative(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        Path p = new Path(path);
        IPath makeRelativeTo = p.makeRelativeTo(this.base);
        return makeRelativeTo.toString();
    }

    public String makeAbsolute(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        Path p = new Path(path);
        return this.base.append((IPath)p).toString();
    }

    @Override
    public void loadFromMap(CompositeMap map) {
        this.updateModel(ONLY_SAVE_LOGIC, Boolean.TRUE.equals(map.getBoolean((Object)ONLY_SAVE_LOGIC, true)));
        String docPath = this.getMapCData(FSD_DOCX_PATH, map);
        this.updateModel(FSD_DOCX_PATH, this.makeAbsolute(docPath));
        String t = this.getMapCData(FSD_TABLE_INPUT, map);
        String[] split = t.split(",");
        ArrayList<String> ss = new ArrayList<String>();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && !"".equals(s)) {
                ss.add(this.makeAbsolute(s));
            }
            ++n2;
        }
        this.updateModel(FSD_TABLE_INPUT, ss);
    }
}

