/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view;

import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class Node
extends PlatformObject {
    private Node parent;
    private List<Node> children = new ArrayList<Node>();
    private IPath path;
    private boolean makeChildFinish = false;
    private boolean isChecked = false;
    private boolean isGrayed = false;

    protected Node() {
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Node(IPath path) {
        this.setPath(path);
    }

    public Node(File file) {
        this((IPath)new Path(file.getPath()));
    }

    public File getFile() {
        if (this.path == null) {
            return null;
        }
        return this.path.toFile();
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean hasChildren() {
        File[] list = this.getFile().listFiles();
        return list != null && list.length > 0;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public List<Node> makeChildren() {
        if (this.makeChildFinish) {
            return this.children;
        }
        File[] listFiles = this.getFile().listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Node child;
                File file = fileArray[n2];
                String name = file.getName();
                if (!("CVS".equals(name) || ".svn".equals(name) || !name.endsWith(".uip") && !file.isDirectory() || this.contains(child = new Node((IPath)new Path(file.getPath()))))) {
                    this.addChild(child);
                }
                ++n2;
            }
        }
        this.makeChildFinish = true;
        return this.children;
    }

    private boolean contains(Node node) {
        for (Node n : this.children) {
            if (!n.getPath().equals((Object)node.getPath())) continue;
            return true;
        }
        return false;
    }

    public void addChild(Node child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void removeChild(Node child) {
        Node del = null;
        for (Node n : this.children) {
            if (!n.getPath().equals((Object)child.getPath())) continue;
            del = n;
            break;
        }
        if (del != null) {
            this.children.remove((Object)del);
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Node getChild(String name) {
        for (Node n : this.children) {
            if (!name.equals(n.getPath().lastSegment())) continue;
            return n;
        }
        return null;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public String getPropertiesPath() {
        boolean project = ResourceUtil.isProject(this.getFile());
        if (project) {
            return ResourceUtil.getProjectPropertyFile(this.getFile()).getPath();
        }
        boolean module = ResourceUtil.isModule(this.getFile());
        if (module) {
            return ResourceUtil.getModulePropertyFile(this.getFile()).getPath();
        }
        boolean function = ResourceUtil.isFunction(this.getFile());
        if (function) {
            return ResourceUtil.getFunctionPropertyFile(this.getFile()).getPath();
        }
        return this.path == null ? "" : this.path.toString();
    }

    public boolean isGrayed() {
        return this.isGrayed;
    }

    public void setGrayed(boolean isGrayed) {
        this.isGrayed = isGrayed;
    }
}

