/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view;

import aurora.ide.editor.editorInput.PathEditorInput;
import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.Root;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NodeLinkHelper {
    private NavigationView commonNavigator;

    public NodeLinkHelper(NavigationView commonNavigator) {
        this.commonNavigator = commonNavigator;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        Node node = this.getNode(anInput);
        if (node != null) {
            return new StructuredSelection((Object)node);
        }
        return StructuredSelection.EMPTY;
    }

    public Node getNode(IEditorInput anInput) {
        if (anInput instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)anInput).getPath();
            Node rootNode = this.getRootNode(path);
            return this.findNode(path, rootNode);
        }
        return null;
    }

    public Node findNode(IPath path, Node rootNode) {
        Node r = rootNode;
        if (rootNode != null) {
            String[] segments;
            IPath makeRelativeTo = path.makeRelativeTo(rootNode.getPath());
            String[] stringArray = segments = makeRelativeTo.segments();
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (r != null) {
                    r.makeChildren();
                    r = r.getChild(string);
                }
                ++n2;
            }
        }
        if (r != null && path.equals((Object)r.getPath())) {
            return r;
        }
        return null;
    }

    public Node getRootNode(IPath path) {
        Object input = this.commonNavigator.getViewer().getInput();
        if (input instanceof Root) {
            List<Node> children = ((Root)((Object)input)).getChildren();
            for (Node node : children) {
                if (!node.getPath().isPrefixOf(path)) continue;
                return node;
            }
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object firstElement = aSelection.getFirstElement();
        if (firstElement instanceof Node) {
            PathEditorInput fileInput = new PathEditorInput(((Node)((Object)firstElement)).getPath());
            IEditorPart editor = null;
            editor = aPage.findEditor((IEditorInput)fileInput);
            if (editor != null) {
                aPage.bringToTop((IWorkbenchPart)editor);
            }
        }
    }
}

