/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.action;

import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.action.Messages;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import aurora.ide.prototype.consultant.view.wizard.CreateFunctionWizard;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class CreateFunctionAction
extends Action
implements ISelectionChangedListener {
    private final TreeViewer commonViewer;
    private NavigationView viewer;

    public CreateFunctionAction(NavigationView viewer) {
        super(Messages.CreateFunctionAction_0);
        this.setToolTipText(Messages.CreateFunctionAction_1);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.viewer = viewer;
        this.commonViewer = viewer.getViewer();
        this.commonViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged();
    }

    public void run() {
        Node selectionNode = this.viewer.getSelectionNode();
        if (selectionNode == null) {
            return;
        }
        CreateFunctionWizard w = new CreateFunctionWizard(this.commonViewer.getControl().getShell(), selectionNode.getFile());
        if (w.open() == 0) {
            Node newNode = new Node((IPath)new Path(w.getFunction().getPath()));
            this.viewer.addNewNode((Object)selectionNode, newNode);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged();
    }

    protected void selectionChanged() {
        Node node = this.viewer.getSelectionNode();
        if (node != null && (ResourceUtil.isProject(node.getFile()) || ResourceUtil.isModule(node.getFile()))) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

