/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.action;

import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.NodeLinkHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class LinkEditorAction
extends Action
implements ISelectionChangedListener,
IPropertyListener {
    private IPartListener partListener;
    private final NavigationView commonNavigator;
    private final TreeViewer commonViewer;
    private NodeLinkHelper linkHelper;
    private boolean ignoreSelectionChanged;
    private boolean ignoreEditorActivation;
    private UIJob activateEditorJob = new UIJob("Linking viewer selection with current editor"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IStructuredSelection sSelection;
            ISelection selection;
            if (!LinkEditorAction.this.commonViewer.getControl().isDisposed() && (selection = LinkEditorAction.this.commonViewer.getSelection()) != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
                LinkEditorAction.this.ignoreEditorActivation = true;
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        LinkEditorAction.this.linkHelper.activateEditor(LinkEditorAction.this.commonNavigator.getSite().getPage(), sSelection);
                    }
                });
                LinkEditorAction.this.ignoreEditorActivation = false;
            }
            return Status.OK_STATUS;
        }
    };
    private UIJob updateSelectionJob = new UIJob("Linking viewer selection with current editor"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!LinkEditorAction.this.commonViewer.getControl().isDisposed()) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        IEditorPart editor;
                        IWorkbenchPage page = LinkEditorAction.this.commonNavigator.getSite().getPage();
                        if (page != null && (editor = page.getActiveEditor()) != null) {
                            IEditorInput input = editor.getEditorInput();
                            IStructuredSelection newSelection = LinkEditorAction.this.linkHelper.findSelection(input);
                            if (!newSelection.isEmpty()) {
                                LinkEditorAction.this.ignoreSelectionChanged = true;
                                LinkEditorAction.this.commonNavigator.selectReveal((ISelection)newSelection);
                                LinkEditorAction.this.ignoreSelectionChanged = false;
                            }
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };

    public LinkEditorAction(NavigationView aNavigator, TreeViewer aViewer) {
        super("&Link with Editor");
        this.setToolTipText("Link with Editor");
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.linkHelper = new NodeLinkHelper(this.commonNavigator);
        this.init();
    }

    protected void init() {
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart && !LinkEditorAction.this.ignoreEditorActivation) {
                    LinkEditorAction.this.updateSelectionJob.schedule(120L);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof IEditorPart && !LinkEditorAction.this.ignoreEditorActivation) {
                    LinkEditorAction.this.updateSelectionJob.schedule(120L);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.updateLinkingEnabled(this.commonNavigator.isLinkingEnabled());
        this.commonNavigator.addPropertyListener(this);
    }

    public void dispose() {
        this.commonNavigator.removePropertyListener(this);
        if (this.isChecked()) {
            this.commonViewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }

    public void run() {
        this.commonNavigator.setLinkingEnabled(!this.commonNavigator.isLinkingEnabled());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.commonNavigator.isLinkingEnabled() && !this.ignoreSelectionChanged) {
            this.activateEditor();
        }
    }

    protected void activateEditor() {
        ISelection selection = this.commonViewer.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.activateEditorJob.schedule(120L);
        }
    }

    public void propertyChanged(Object aSource, int aPropertyId) {
        switch (aPropertyId) {
            case 65536: {
                this.updateLinkingEnabled(((NavigationView)((Object)aSource)).isLinkingEnabled());
            }
        }
    }

    private void updateLinkingEnabled(boolean toEnableLinking) {
        this.setChecked(toEnableLinking);
        if (toEnableLinking) {
            this.updateSelectionJob.schedule(120L);
            this.commonViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
            this.commonNavigator.getSite().getPage().addPartListener(this.partListener);
        } else {
            this.commonViewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }
}

