/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.wizard;

import aurora.ide.prototype.consultant.product.fsd.ExportProjectFSDProgress;
import aurora.ide.prototype.consultant.product.fsd.wizard.Messages;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import aurora.ide.prototype.consultant.view.wizard.ProjectFSDContentPage;
import aurora.ide.prototype.consultant.view.wizard.ProjectFSDDescPage;
import aurora.ide.swt.util.PageModel;
import aurora.ide.swt.util.UWizard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;

public class ProjectExportFSDWizard
extends UWizard {
    private ProjectFSDDescPage page1;
    private ProjectFSDContentPage page2;
    private Node projectNode;
    private CompositeMap loadProperties;
    private Node selectionNode;

    public ProjectExportFSDWizard(Shell shell, Node selectionNode) {
        super(shell);
        this.setNeedsProgressMonitor(true);
        this.projectNode = ResourceUtil.getProjectNode(selectionNode);
        this.loadProperties = this.loadProperties(selectionNode.getFile());
        this.selectionNode = selectionNode;
    }

    public void addPages() {
        this.page1 = new ProjectFSDDescPage("ProjectFSDDescPage", Messages.ExportWizard_1, null, this.loadProperties);
        this.page2 = new ProjectFSDContentPage("ProjectFSDContentPage", Messages.ExportWizard_3, null, this.selectionNode, this.projectNode, this.loadProperties);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    protected CompositeMap loadProperties(File file) {
        if (ResourceUtil.isProject(file)) {
            return ResourceUtil.loadProjectProperties(file);
        }
        if (ResourceUtil.isModule(file)) {
            CompositeMap pp = ResourceUtil.loadModuleProperties(file);
            ResourceUtil.copyProjectProperties(file, pp);
            return pp;
        }
        return new CompositeMap();
    }

    protected void saveProperties(CompositeMap map) throws IOException {
        File file = this.selectionNode.getFile();
        if (ResourceUtil.isProject(file)) {
            ResourceUtil.createFile(file, "quick_ui.project", map);
        }
        if (ResourceUtil.isModule(file)) {
            ResourceUtil.createFile(file, "quick_ui.module", map);
        }
    }

    public boolean performFinish() {
        PageModel p2m = this.page2.getModel();
        PageModel p1m = this.page1.getModel();
        CompositeMap map = new CompositeMap("properties");
        this.page1.saveTOMap(map);
        this.page2.saveTOMap(map);
        try {
            this.saveProperties(map);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new ExportProjectFSDProgress(p2m.getStringPropertyValue("fsd_docx_path"), p1m, (List)p2m.getPropertyValue("fsd_table_input"), p2m.getBooleanPropertyValue("only_save_logic")));
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

