/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.wizard;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.prototype.consultant.product.fsd.wizard.FSDContentControl;
import aurora.ide.prototype.consultant.product.fsd.wizard.Messages;
import aurora.ide.prototype.consultant.view.FunctionSelectionDialog;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.swt.util.GridLayoutUtil;
import aurora.ide.swt.util.TableLabelProvider;
import aurora.ide.swt.util.UWizardPage;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uncertain.composite.CompositeMap;

public class ProjectFSDContentPage
extends UWizardPage {
    public static String[] properties = new String[]{"fsd_docx_path", "fsd_table_input", "only_save_logic"};
    private Node projectNode;
    private Node selectionNode;

    protected ProjectFSDContentPage(String pageName, String title, ImageDescriptor titleImage, Node selectionNode, Node projectNode, CompositeMap input) {
        super(pageName);
        this.setTitle(title);
        this.setImageDescriptor(titleImage);
        this.setMessage(Messages.ContentDescPage_2);
        this.projectNode = projectNode;
        this.selectionNode = selectionNode;
        new FSDContentControl(this.getModel(), selectionNode.getPath()).loadFromMap(input);
    }

    protected String[] getModelPropertyKeys() {
        return properties;
    }

    protected String verifyModelProperty(String key, Object val) {
        if (properties[0].equals(key) && (val == null || "".equals(val))) {
            return Messages.ProjectFSDContentPage_1;
        }
        return null;
    }

    protected Composite createPageControl(Composite control) {
        Composite c2 = new Composite(control, 0);
        c2.setLayoutData((Object)new GridData(1808));
        c2.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        new FSDContentControl(this.getModel(), this.selectionNode.getPath()){

            @Override
            protected void createTableColumn(Table table) {
                TableColumn column1 = new TableColumn(table, 16384);
                column1.setWidth(128);
                column1.setText(Messages.ProjectFSDContentPage_2);
                TableColumn column2 = new TableColumn(table, 0);
                column2.setWidth(193);
                column2.setText(Messages.ProjectFSDContentPage_3);
            }

            @Override
            protected TableLabelProvider getLabelProvider() {
                return new TableLabelProvider(){

                    public String getColumnText(Object element, int i) {
                        if (element instanceof String) {
                            Path p = new Path(element.toString());
                            File file = p.toFile();
                            if (!file.exists()) {
                                return "";
                            }
                            if (i == 0) {
                                return file.getParentFile().getName();
                            }
                            if (i == 1) {
                                CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
                                CompositeMap child = loadFile.getChild("fun_name");
                                String text = child == null ? "" : child.getText();
                                return text == null ? "" : text;
                            }
                        }
                        return "";
                    }
                };
            }

            @Override
            protected void clickAddButton(Shell shell, TableViewer tv) {
                FunctionSelectionDialog fsd = new FunctionSelectionDialog();
                String path = fsd.openFolderSelectionDialog(Messages.ProjectFSDContentPage_7, shell, (Object)ProjectFSDContentPage.this.getProjectNode());
                if (path != null && path.length() > 0) {
                    this.getTableInput().add(path);
                }
                tv.setInput(this.getTableInput());
            }
        }.createFSDContentControl(c2);
        return c2;
    }

    protected Node getProjectNode() {
        return this.projectNode;
    }

    protected void saveTOMap(CompositeMap map) {
        new FSDContentControl(this.getModel(), this.selectionNode.getPath()).saveToMap(map);
    }
}

