/*
 * Decompiled with CFR 0.152.
 */
package aurora.javascript.commonjs.module.provider;

import aurora.javascript.Context;
import aurora.javascript.Scriptable;
import aurora.javascript.commonjs.module.ModuleScript;
import aurora.javascript.commonjs.module.ModuleScriptProvider;
import java.net.URI;
import java.util.LinkedList;

public class MultiModuleScriptProvider
implements ModuleScriptProvider {
    private final ModuleScriptProvider[] providers;

    public MultiModuleScriptProvider(Iterable<? extends ModuleScriptProvider> providers) {
        LinkedList<ModuleScriptProvider> l = new LinkedList<ModuleScriptProvider>();
        for (ModuleScriptProvider moduleScriptProvider : providers) {
            l.add(moduleScriptProvider);
        }
        this.providers = l.toArray(new ModuleScriptProvider[l.size()]);
    }

    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, URI uri, URI base, Scriptable paths) throws Exception {
        ModuleScriptProvider[] moduleScriptProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleScriptProvider provider = moduleScriptProviderArray[n2];
            ModuleScript script = provider.getModuleScript(cx, moduleId, uri, base, paths);
            if (script != null) {
                return script;
            }
            ++n2;
        }
        return null;
    }
}

