/*
 * Decompiled with CFR 0.152.
 */
package aurora.javascript.optimizer;

import aurora.javascript.Node;
import aurora.javascript.ObjArray;
import aurora.javascript.ObjToIntMap;
import aurora.javascript.ast.Jump;
import aurora.javascript.optimizer.OptFunctionNode;
import java.util.BitSet;
import java.util.HashMap;

class Block {
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private int itsBlockID;
    private BitSet itsLiveOnEntrySet;
    private BitSet itsLiveOnExitSet;
    private BitSet itsUseBeforeDefSet;
    private BitSet itsNotDefSet;
    static final boolean DEBUG = false;
    private static int debug_blockCount;

    Block(int startNodeIndex, int endNodeIndex) {
        this.itsStartNodeIndex = startNodeIndex;
        this.itsEndNodeIndex = endNodeIndex;
    }

    static void runFlowAnalyzes(OptFunctionNode fn, Node[] statementNodes) {
        int paramCount = fn.fnode.getParamCount();
        int varCount = fn.fnode.getParamAndVarCount();
        int[] varTypes = new int[varCount];
        int i = 0;
        while (i != paramCount) {
            varTypes[i] = 3;
            ++i;
        }
        i = paramCount;
        while (i != varCount) {
            varTypes[i] = 0;
            ++i;
        }
        Block[] theBlocks = Block.buildBlocks(statementNodes);
        Block.reachingDefDataFlow(fn, statementNodes, theBlocks, varTypes);
        Block.typeFlow(fn, statementNodes, theBlocks, varTypes);
        int i2 = paramCount;
        while (i2 != varCount) {
            if (varTypes[i2] == 1) {
                fn.setIsNumberVar(i2);
            }
            ++i2;
        }
    }

    private static Block[] buildBlocks(Node[] statementNodes) {
        FatBlock fb;
        HashMap<Node, FatBlock> theTargetBlocks = new HashMap<Node, FatBlock>();
        ObjArray theBlocks = new ObjArray();
        int beginNodeIndex = 0;
        int i = 0;
        while (i < statementNodes.length) {
            switch (statementNodes[i].getType()) {
                case 131: {
                    if (i == beginNodeIndex) break;
                    fb = Block.newFatBlock(beginNodeIndex, i - 1);
                    if (statementNodes[beginNodeIndex].getType() == 131) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    fb = Block.newFatBlock(beginNodeIndex, i);
                    if (statementNodes[beginNodeIndex].getType() == 131) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i + 1;
                }
            }
            ++i;
        }
        if (beginNodeIndex != statementNodes.length) {
            FatBlock fb2 = Block.newFatBlock(beginNodeIndex, statementNodes.length - 1);
            if (statementNodes[beginNodeIndex].getType() == 131) {
                theTargetBlocks.put(statementNodes[beginNodeIndex], fb2);
            }
            theBlocks.add(fb2);
        }
        i = 0;
        while (i < theBlocks.size()) {
            fb = (FatBlock)theBlocks.get(i);
            Node blockEndNode = statementNodes[fb.realBlock.itsEndNodeIndex];
            int blockEndNodeType = blockEndNode.getType();
            if (blockEndNodeType != 5 && i < theBlocks.size() - 1) {
                FatBlock fallThruTarget = (FatBlock)theBlocks.get(i + 1);
                fb.addSuccessor(fallThruTarget);
                fallThruTarget.addPredecessor(fb);
            }
            if (blockEndNodeType == 7 || blockEndNodeType == 6 || blockEndNodeType == 5) {
                Node target = ((Jump)blockEndNode).target;
                FatBlock branchTargetBlock = (FatBlock)theTargetBlocks.get(target);
                target.putProp(6, branchTargetBlock.realBlock);
                fb.addSuccessor(branchTargetBlock);
                branchTargetBlock.addPredecessor(fb);
            }
            ++i;
        }
        Block[] result = new Block[theBlocks.size()];
        int i2 = 0;
        while (i2 < theBlocks.size()) {
            FatBlock fb3 = (FatBlock)theBlocks.get(i2);
            Block b = fb3.realBlock;
            b.itsSuccessors = fb3.getSuccessors();
            b.itsPredecessors = fb3.getPredecessors();
            b.itsBlockID = i2;
            result[i2] = b;
            ++i2;
        }
        return result;
    }

    private static FatBlock newFatBlock(int startNodeIndex, int endNodeIndex) {
        FatBlock fb = new FatBlock();
        fb.realBlock = new Block(startNodeIndex, endNodeIndex);
        return fb;
    }

    private static String toString(Block[] blockList, Node[] statementNodes) {
        return null;
    }

    private static void reachingDefDataFlow(OptFunctionNode fn, Node[] statementNodes, Block[] theBlocks, int[] varTypes) {
        int i = 0;
        while (i < theBlocks.length) {
            theBlocks[i].initLiveOnEntrySets(fn, statementNodes);
            ++i;
        }
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = theBlocks.length - 1;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] pred;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doReachedUseDataFlow() && (pred = theBlocks[vIndex].itsPredecessors) != null) {
                    int i2 = 0;
                    while (i2 < pred.length) {
                        int index = pred[i2].itsBlockID;
                        visit[index] = true;
                        needRescan |= index > vIndex;
                        ++i2;
                    }
                }
            }
            if (vIndex == 0) {
                if (!needRescan) break;
                vIndex = theBlocks.length - 1;
                needRescan = false;
                continue;
            }
            --vIndex;
        }
        theBlocks[0].markAnyTypeVariables(varTypes);
    }

    private static void typeFlow(OptFunctionNode fn, Node[] statementNodes, Block[] theBlocks, int[] varTypes) {
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = 0;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] succ;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doTypeFlow(fn, statementNodes, varTypes) && (succ = theBlocks[vIndex].itsSuccessors) != null) {
                    int i = 0;
                    while (i < succ.length) {
                        int index = succ[i].itsBlockID;
                        visit[index] = true;
                        needRescan |= index < vIndex;
                        ++i;
                    }
                }
            }
            if (vIndex == theBlocks.length - 1) {
                if (!needRescan) break;
                vIndex = 0;
                needRescan = false;
                continue;
            }
            ++vIndex;
        }
    }

    private static boolean assignType(int[] varTypes, int index, int type) {
        int prev = varTypes[index];
        int n = index;
        varTypes[n] = varTypes[n] | type;
        return prev != varTypes[n];
    }

    private void markAnyTypeVariables(int[] varTypes) {
        int i = 0;
        while (i != varTypes.length) {
            if (this.itsLiveOnEntrySet.get(i)) {
                Block.assignType(varTypes, i, 3);
            }
            ++i;
        }
    }

    private void lookForVariableAccess(OptFunctionNode fn, Node n) {
        switch (n.getType()) {
            case 137: {
                int varIndex = fn.fnode.getIndexForNameNode(n);
                if (varIndex <= -1 || this.itsNotDefSet.get(varIndex)) break;
                this.itsUseBeforeDefSet.set(varIndex);
                break;
            }
            case 106: 
            case 107: {
                Node child = n.getFirstChild();
                if (child.getType() == 55) {
                    int varIndex = fn.getVarIndex(child);
                    if (!this.itsNotDefSet.get(varIndex)) {
                        this.itsUseBeforeDefSet.set(varIndex);
                    }
                    this.itsNotDefSet.set(varIndex);
                    break;
                }
                this.lookForVariableAccess(fn, child);
                break;
            }
            case 56: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                this.lookForVariableAccess(fn, rhs);
                this.itsNotDefSet.set(fn.getVarIndex(n));
                break;
            }
            case 55: {
                int varIndex = fn.getVarIndex(n);
                if (this.itsNotDefSet.get(varIndex)) break;
                this.itsUseBeforeDefSet.set(varIndex);
                break;
            }
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.lookForVariableAccess(fn, child);
                    child = child.getNext();
                }
                break block0;
            }
        }
    }

    private void initLiveOnEntrySets(OptFunctionNode fn, Node[] statementNodes) {
        int listLength = fn.getVarCount();
        this.itsUseBeforeDefSet = new BitSet(listLength);
        this.itsNotDefSet = new BitSet(listLength);
        this.itsLiveOnEntrySet = new BitSet(listLength);
        this.itsLiveOnExitSet = new BitSet(listLength);
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = statementNodes[i];
            this.lookForVariableAccess(fn, n);
            ++i;
        }
        this.itsNotDefSet.flip(0, listLength);
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            int i = 0;
            while (i < this.itsSuccessors.length) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
                ++i;
            }
        }
        return this.updateEntrySet(this.itsLiveOnEntrySet, this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private boolean updateEntrySet(BitSet entrySet, BitSet exitSet, BitSet useBeforeDef, BitSet notDef) {
        int card = entrySet.cardinality();
        entrySet.or(exitSet);
        entrySet.and(notDef);
        entrySet.or(useBeforeDef);
        return entrySet.cardinality() != card;
    }

    private static int findExpressionType(OptFunctionNode fn, Node n, int[] varTypes) {
        switch (n.getType()) {
            case 40: {
                return 1;
            }
            case 30: 
            case 38: 
            case 70: {
                return 3;
            }
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                return 3;
            }
            case 55: {
                return varTypes[fn.getVarIndex(n)];
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 106: 
            case 107: {
                return 1;
            }
            case 126: {
                return 3;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 69: {
                return 3;
            }
            case 32: 
            case 41: 
            case 137: {
                return 3;
            }
            case 42: 
            case 48: 
            case 65: 
            case 66: 
            case 157: {
                return 3;
            }
            case 21: {
                Node child = n.getFirstChild();
                int lType = Block.findExpressionType(fn, child, varTypes);
                int rType = Block.findExpressionType(fn, child.getNext(), varTypes);
                return lType | rType;
            }
            case 102: {
                Node ifTrue = n.getFirstChild().getNext();
                Node ifFalse = ifTrue.getNext();
                int ifTrueType = Block.findExpressionType(fn, ifTrue, varTypes);
                int ifFalseType = Block.findExpressionType(fn, ifFalse, varTypes);
                return ifTrueType | ifFalseType;
            }
            case 8: 
            case 35: 
            case 37: 
            case 56: 
            case 89: {
                return Block.findExpressionType(fn, n.getLastChild(), varTypes);
            }
            case 104: 
            case 105: {
                Node child = n.getFirstChild();
                int lType = Block.findExpressionType(fn, child, varTypes);
                int rType = Block.findExpressionType(fn, child.getNext(), varTypes);
                return lType | rType;
            }
        }
        return 3;
    }

    private static boolean findDefPoints(OptFunctionNode fn, Node n, int[] varTypes) {
        Node first;
        boolean result = false;
        Node next = first = n.getFirstChild();
        while (next != null) {
            result |= Block.findDefPoints(fn, next, varTypes);
            next = next.getNext();
        }
        switch (n.getType()) {
            case 106: 
            case 107: {
                if (first.getType() != 55) break;
                int i = fn.getVarIndex(first);
                result |= Block.assignType(varTypes, i, 1);
                break;
            }
            case 56: {
                Node rValue = first.getNext();
                int theType = Block.findExpressionType(fn, rValue, varTypes);
                int i = fn.getVarIndex(n);
                result |= Block.assignType(varTypes, i, theType);
            }
        }
        return result;
    }

    private boolean doTypeFlow(OptFunctionNode fn, Node[] statementNodes, int[] varTypes) {
        boolean changed = false;
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = statementNodes[i];
            if (n != null) {
                changed |= Block.findDefPoints(fn, n, varTypes);
            }
            ++i;
        }
        return changed;
    }

    private void printLiveOnEntrySet(OptFunctionNode fn) {
    }

    private static class FatBlock {
        private ObjToIntMap successors = new ObjToIntMap();
        private ObjToIntMap predecessors = new ObjToIntMap();
        Block realBlock;

        private FatBlock() {
        }

        private static Block[] reduceToArray(ObjToIntMap map) {
            Block[] result = null;
            if (!map.isEmpty()) {
                result = new Block[map.size()];
                int i = 0;
                ObjToIntMap.Iterator iter = map.newIterator();
                iter.start();
                while (!iter.done()) {
                    FatBlock fb = (FatBlock)iter.getKey();
                    result[i++] = fb.realBlock;
                    iter.next();
                }
            }
            return result;
        }

        void addSuccessor(FatBlock b) {
            this.successors.put(b, 0);
        }

        void addPredecessor(FatBlock b) {
            this.predecessors.put(b, 0);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }
    }
}

