/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.fonts.FopCharacterSet;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.afp.util.StructuredFieldReader;
import org.apache.fop.fonts.Typeface;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public class CharacterSetBuilder {
    protected static final Log LOG = LogFactory.getLog((Class)CharacterSetBuilder.class);
    private static CharacterSetBuilder instance;
    private static final CharacterSetOrientation[] EMPTY_CSO_ARRAY;
    private static final byte[] CODEPAGE_SF;
    private static final byte[] CHARACTER_TABLE_SF;
    private static final byte[] FONT_DESCRIPTOR_SF;
    private static final byte[] FONT_CONTROL_SF;
    private static final byte[] FONT_ORIENTATION_SF;
    private static final byte[] FONT_POSITION_SF;
    private static final byte[] FONT_INDEX_SF;
    private final Map codePagesCache = new WeakHashMap();
    private final SoftMapCache characterSetsCache = new SoftMapCache(true);

    private CharacterSetBuilder() {
    }

    public static CharacterSetBuilder getInstance() {
        if (instance == null) {
            instance = new CharacterSetBuilder();
        }
        return instance;
    }

    public static CharacterSetBuilder getDoubleByteInstance() {
        return new DoubleByteLoader();
    }

    protected InputStream openInputStream(ResourceAccessor accessor, String filename) throws IOException {
        URI uri;
        try {
            uri = new URI(filename.trim());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("Invalid filename: " + filename + " (" + e.getMessage() + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening " + uri));
        }
        InputStream inputStream = accessor.createInputStream(uri);
        return inputStream;
    }

    protected void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterSet build(String characterSetName, String codePageName, String encoding, ResourceAccessor accessor) throws IOException {
        String descriptor = characterSetName + "_" + encoding + "_" + codePageName;
        CharacterSet characterSet = (CharacterSet)this.characterSetsCache.get((Object)descriptor);
        if (characterSet != null) {
            return characterSet;
        }
        characterSet = new CharacterSet(codePageName, encoding, characterSetName, accessor);
        InputStream inputStream = null;
        try {
            Map codePage = (Map)this.codePagesCache.get(codePageName);
            if (codePage == null) {
                codePage = this.loadCodePage(codePageName, encoding, accessor);
                this.codePagesCache.put(codePageName, codePage);
            }
            inputStream = this.openInputStream(accessor, characterSetName);
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            FontDescriptor fontDescriptor = CharacterSetBuilder.processFontDescriptor(structuredFieldReader);
            characterSet.setNominalVerticalSize(fontDescriptor.getNominalFontSizeInMillipoints());
            FontControl fontControl = this.processFontControl(structuredFieldReader);
            if (fontControl != null) {
                int metricNormalizationFactor;
                CharacterSetOrientation[] characterSetOrientations = this.processFontOrientation(structuredFieldReader);
                if (fontControl.isRelative()) {
                    metricNormalizationFactor = 1;
                } else {
                    int dpi = fontControl.getDpi();
                    metricNormalizationFactor = 72000000 / fontDescriptor.getNominalFontSizeInMillipoints() / dpi;
                }
                this.processFontPosition(structuredFieldReader, characterSetOrientations, metricNormalizationFactor);
                for (int i = 0; i < characterSetOrientations.length; ++i) {
                    this.processFontIndex(structuredFieldReader, characterSetOrientations[i], codePage, metricNormalizationFactor);
                    characterSet.addCharacterSetOrientation(characterSetOrientations[i]);
                }
            } else {
                throw new IOException("Missing D3AE89 Font Control structured field.");
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
        this.characterSetsCache.put((Object)descriptor, (Object)characterSet);
        return characterSet;
    }

    public CharacterSet build(String characterSetName, String codePageName, String encoding, Typeface typeface) {
        return new FopCharacterSet(codePageName, encoding, characterSetName, typeface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadCodePage(String codePage, String encoding, ResourceAccessor accessor) throws IOException {
        HashMap<String, String> codePages = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream(accessor, codePage.trim());
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            byte[] data = structuredFieldReader.getNext(CHARACTER_TABLE_SF);
            int position = 0;
            byte[] gcgiBytes = new byte[8];
            byte[] charBytes = new byte[1];
            for (int index = 3; index < data.length; ++index) {
                if (position < 8) {
                    gcgiBytes[position] = data[index];
                    ++position;
                    continue;
                }
                if (position == 9) {
                    position = 0;
                    charBytes[0] = data[index];
                    String gcgiString = new String(gcgiBytes, "Cp1146");
                    String charString = new String(charBytes, encoding);
                    codePages.put(gcgiString, charString);
                    continue;
                }
                ++position;
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
        return codePages;
    }

    protected static FontDescriptor processFontDescriptor(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fndData = structuredFieldReader.getNext(FONT_DESCRIPTOR_SF);
        return new FontDescriptor(fndData);
    }

    protected FontControl processFontControl(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fncData = structuredFieldReader.getNext(FONT_CONTROL_SF);
        FontControl fontControl = null;
        if (fncData != null) {
            int metricResolution;
            fontControl = new FontControl();
            if (fncData[7] == 2) {
                fontControl.setRelative(true);
            }
            if ((metricResolution = CharacterSetBuilder.getUBIN(fncData, 9)) == 1000) {
                fontControl.setUnitsPerEm(1000);
            } else {
                fontControl.setDpi(metricResolution / 10);
            }
        }
        return fontControl;
    }

    protected CharacterSetOrientation[] processFontOrientation(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_ORIENTATION_SF);
        int position = 0;
        byte[] fnoData = new byte[26];
        ArrayList<CharacterSetOrientation> orientations = new ArrayList<CharacterSetOrientation>();
        for (int index = 3; index < data.length; ++index) {
            fnoData[position] = data[index];
            if (++position != 26) continue;
            position = 0;
            int orientation = CharacterSetBuilder.determineOrientation(fnoData[2]);
            int space = ((fnoData[8] & 0xFF) << 8) + (fnoData[9] & 0xFF);
            int em = ((fnoData[14] & 0xFF) << 8) + (fnoData[15] & 0xFF);
            CharacterSetOrientation cso = new CharacterSetOrientation(orientation);
            cso.setSpaceIncrement(space);
            cso.setEmSpaceIncrement(em);
            orientations.add(cso);
        }
        return orientations.toArray(EMPTY_CSO_ARRAY);
    }

    protected void processFontPosition(StructuredFieldReader structuredFieldReader, CharacterSetOrientation[] characterSetOrientations, double metricNormalizationFactor) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_POSITION_SF);
        int position = 0;
        byte[] fpData = new byte[26];
        int characterSetOrientationIndex = 0;
        for (int index = 3; index < data.length; ++index) {
            if (position < 22) {
                fpData[position] = data[index];
                if (position == 9) {
                    CharacterSetOrientation characterSetOrientation = characterSetOrientations[characterSetOrientationIndex];
                    int xHeight = CharacterSetBuilder.getSBIN(fpData, 2);
                    int capHeight = CharacterSetBuilder.getSBIN(fpData, 4);
                    int ascHeight = CharacterSetBuilder.getSBIN(fpData, 6);
                    int dscHeight = CharacterSetBuilder.getSBIN(fpData, 8);
                    characterSetOrientation.setXHeight((int)Math.round((double)xHeight * metricNormalizationFactor));
                    characterSetOrientation.setCapHeight((int)Math.round((double)capHeight * metricNormalizationFactor));
                    characterSetOrientation.setAscender((int)Math.round((double)ascHeight * metricNormalizationFactor));
                    characterSetOrientation.setDescender((int)Math.round((double)(dscHeight *= -1) * metricNormalizationFactor));
                }
            } else if (position == 22) {
                position = 0;
                ++characterSetOrientationIndex;
                fpData[position] = data[index];
            }
            ++position;
        }
    }

    protected void processFontIndex(StructuredFieldReader structuredFieldReader, CharacterSetOrientation cso, Map codepage, double metricNormalizationFactor) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_INDEX_SF);
        int position = 0;
        byte[] gcgid = new byte[8];
        byte[] fiData = new byte[20];
        char lowest = '\u00ff';
        char highest = '\u0000';
        String firstABCMismatch = null;
        for (int index = 3; index < data.length; ++index) {
            double diffPercent;
            int c;
            int b;
            if (position < 8) {
                gcgid[position] = data[index];
                ++position;
                continue;
            }
            if (position < 27) {
                fiData[position - 8] = data[index];
                ++position;
                continue;
            }
            if (position != 27) continue;
            fiData[position - 8] = data[index];
            position = 0;
            String gcgiString = new String(gcgid, "Cp1146");
            String idx = (String)codepage.get(gcgiString);
            if (idx == null) continue;
            char cidx = idx.charAt(0);
            int width = CharacterSetBuilder.getUBIN(fiData, 0);
            int a = CharacterSetBuilder.getSBIN(fiData, 10);
            int abc = a + (b = CharacterSetBuilder.getUBIN(fiData, 12)) + (c = CharacterSetBuilder.getSBIN(fiData, 14));
            int diff = Math.abs(abc - width);
            if (diff != 0 && width != 0 && (diffPercent = (double)(100 * diff) / (double)width) > 2.0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(gcgiString + ": " + a + " + " + b + " + " + c + " = " + (a + b + c) + " but found: " + width));
                }
                if (firstABCMismatch == null) {
                    firstABCMismatch = gcgiString;
                }
            }
            if (cidx < lowest) {
                lowest = cidx;
            }
            if (cidx > highest) {
                highest = cidx;
            }
            int normalizedWidth = (int)Math.round((double)width * metricNormalizationFactor);
            cso.setWidth(cidx, normalizedWidth);
        }
        cso.setFirstChar(lowest);
        cso.setLastChar(highest);
        if (LOG.isDebugEnabled() && firstABCMismatch != null) {
            LOG.debug((Object)("Font has metrics inconsitencies where A+B+C doesn't equal the character increment. The first such character found: " + firstABCMismatch));
        }
    }

    private static int getUBIN(byte[] data, int start) {
        return ((data[start] & 0xFF) << 8) + (data[start + 1] & 0xFF);
    }

    private static int getSBIN(byte[] data, int start) {
        int ubin = ((data[start] & 0xFF) << 8) + (data[start + 1] & 0xFF);
        if ((ubin & 0x8000) != 0) {
            return ubin | 0xFFFF0000;
        }
        return ubin;
    }

    private static int determineOrientation(byte orientation) {
        int degrees = 0;
        switch (orientation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 45: {
                degrees = 90;
                break;
            }
            case 90: {
                degrees = 180;
                break;
            }
            case -121: {
                degrees = 270;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid orientation: " + orientation);
            }
        }
        return degrees;
    }

    static {
        EMPTY_CSO_ARRAY = new CharacterSetOrientation[0];
        CODEPAGE_SF = new byte[]{-45, -88, -121};
        CHARACTER_TABLE_SF = new byte[]{-45, -116, -121};
        FONT_DESCRIPTOR_SF = new byte[]{-45, -90, -119};
        FONT_CONTROL_SF = new byte[]{-45, -89, -119};
        FONT_ORIENTATION_SF = new byte[]{-45, -82, -119};
        FONT_POSITION_SF = new byte[]{-45, -84, -119};
        FONT_INDEX_SF = new byte[]{-45, -116, -119};
    }

    private static class DoubleByteLoader
    extends CharacterSetBuilder {
        private DoubleByteLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map loadCodePage(String codePage, String encoding, ResourceAccessor accessor) throws IOException {
            HashMap<String, String> codePages = new HashMap<String, String>();
            InputStream inputStream = null;
            try {
                byte[] data;
                inputStream = this.openInputStream(accessor, codePage.trim());
                StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
                while ((data = structuredFieldReader.getNext(CHARACTER_TABLE_SF)) != null) {
                    int position = 0;
                    byte[] gcgiBytes = new byte[8];
                    byte[] charBytes = new byte[2];
                    for (int index = 3; index < data.length; ++index) {
                        if (position < 8) {
                            gcgiBytes[position] = data[index];
                            ++position;
                            continue;
                        }
                        if (position == 9) {
                            charBytes[0] = data[index];
                            ++position;
                            continue;
                        }
                        if (position == 10) {
                            position = 0;
                            charBytes[1] = data[index];
                            String gcgiString = new String(gcgiBytes, "Cp1146");
                            String charString = new String(charBytes, encoding);
                            codePages.put(gcgiString, charString);
                            continue;
                        }
                        ++position;
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeInputStream(inputStream);
                throw throwable;
            }
            this.closeInputStream(inputStream);
            return codePages;
        }
    }

    private static class FontDescriptor {
        private byte[] data;

        public FontDescriptor(byte[] data) {
            this.data = data;
        }

        public int getNominalFontSizeInMillipoints() {
            int nominalFontSize = 100 * CharacterSetBuilder.getUBIN(this.data, 39);
            return nominalFontSize;
        }
    }

    private class FontControl {
        private int dpi;
        private int unitsPerEm;
        private boolean isRelative = false;

        private FontControl() {
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int i) {
            this.dpi = i;
        }

        public int getUnitsPerEm() {
            return this.unitsPerEm;
        }

        public void setUnitsPerEm(int value) {
            this.unitsPerEm = value;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean b) {
            this.isRelative = b;
        }
    }
}

