/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import aurora.plugin.sap.FieldMapping;
import com.sap.mw.jco.JCO;
import java.util.HashMap;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;

public class Structure {
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    public String Name;
    public String Target;
    public String Type = "import";
    ILogger logger;
    HashMap name_map;
    boolean fetchAll;
    FieldMapping[] field_mappings;

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public boolean getFetchAll() {
        return this.fetchAll;
    }

    public void setFetchAll(boolean fetchAll) {
        this.fetchAll = fetchAll;
    }

    public void setFieldMappings(FieldMapping[] m) {
        this.field_mappings = m;
        this.name_map = new HashMap();
        int i = 0;
        while (i < m.length) {
            if (m[i].Name == null) {
                throw new ConfigurationError("Must set 'name' for <field-mapping>");
            }
            this.name_map.put(m[i].Name.toLowerCase(), m[i]);
            ++i;
        }
    }

    public FieldMapping[] getFieldMappings() {
        return this.field_mappings;
    }

    public boolean isImport() {
        return IMPORT.equalsIgnoreCase(this.Type);
    }

    public JCO.Structure getJCOStructure(JCO.ParameterList list) {
        try {
            JCO.Structure structure = list.getStructure(this.Name);
            if (structure == null) {
                throw new IllegalArgumentException("Structure '" + this.Name + "' doesn't exist");
            }
            return structure;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Can't get Structure '" + this.Name + "':" + t.getMessage());
        }
    }

    public void fillJCOStructure(JCO.Structure structure, CompositeMap context) {
        this.logger.info("ABAP Structure " + this.Name);
        if (this.field_mappings != null) {
            int i = 0;
            while (i < this.field_mappings.length) {
                FieldMapping fieldMapping = this.field_mappings[i];
                Object value = context.getObject(fieldMapping.Source_field);
                if (value == null) {
                    value = fieldMapping.Value;
                }
                structure.setValue(value, fieldMapping.Name);
                this.logger.info(String.valueOf(fieldMapping.Name) + " -> " + value);
                ++i;
            }
        }
        this.logger.info("\r\nStructure transfered");
    }

    public CompositeMap fillCompositeMap(JCO.Structure records, CompositeMap result) {
        FieldMapping mapping = null;
        CompositeMap item = new CompositeMap((int)((double)records.getFieldCount() * 1.5));
        item.setName("record");
        if (this.field_mappings != null && this.field_mappings.length > 0 && !this.fetchAll) {
            int i = 0;
            while (i < this.field_mappings.length) {
                mapping = this.field_mappings[i];
                String returnField = mapping.Return_field;
                if (returnField == null) {
                    throw new ConfigurationError("Must set 'return_field' for <field-mapping>");
                }
                item.putObject(returnField, records.getValue(mapping.Name));
                ++i;
            }
            result.addChild(item);
            return result;
        }
        int col = 0;
        while (col < records.getFieldCount()) {
            String fieldName = records.getField(col).getName();
            if (this.name_map != null) {
                mapping = (FieldMapping)this.name_map.get(fieldName.toLowerCase());
            }
            if (mapping != null) {
                String returnField = mapping.Return_field;
                if (returnField == null) {
                    throw new ConfigurationError("Must set 'return_field' for <field-mapping>");
                }
                item.putObject(returnField, records.getValue(col));
            } else {
                item.put((Object)fieldName, records.getValue(col));
            }
            ++col;
        }
        result.addChild(item);
        return result;
    }
}

