/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NamespaceNode
implements Node {
    public static final short NAMESPACE_NODE = 13;
    private Node parent;
    private String name;
    private String value;

    public NamespaceNode(Node node, String string, String string2) {
        this.parent = node;
        this.name = string;
        this.value = string2;
    }

    NamespaceNode(Node node, Node node2) {
        String string = node2.getNodeName();
        this.name = string.equals("xmlns") ? "" : string.substring(6);
        this.parent = node;
        this.value = node2.getNodeValue();
    }

    public String getNodeName() {
        return this.name;
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeValue(String string) throws DOMException {
        this.no_mods();
    }

    public short getNodeType() {
        return 13;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new EmptyNodeList();
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.parent == null ? null : this.parent.getOwnerDocument();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.no_mods();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.no_mods();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        this.no_mods();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        this.no_mods();
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean bl) {
        return new NamespaceNode(this.parent, this.name, this.value);
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        this.no_mods();
    }

    public String getLocalName() {
        return this.name;
    }

    public boolean hasAttributes() {
        return false;
    }

    private void no_mods() throws DOMException {
        throw new DOMException(7, "Namespace node may not be modified");
    }

    public int hashCode() {
        return this.hashCode(this.parent) + this.hashCode(this.name) + this.hashCode(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof NamespaceNode) {
            NamespaceNode namespaceNode = (NamespaceNode)object;
            return this.equals(this.parent, namespaceNode.getParentNode()) && this.equals(this.name, namespaceNode.getNodeName()) && this.equals(this.value, namespaceNode.getNodeValue());
        }
        return false;
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    private boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return -1;
    }

    public String getTextContent() throws DOMException {
        return this.value;
    }

    public void setTextContent(String string) throws DOMException {
        this.value = string;
    }

    public boolean isSameNode(Node node) {
        return this.equals(node);
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return string.equals(this.value) && this.name.length() == 0;
    }

    public String lookupNamespaceURI(String string) {
        if (string.equals(this.name)) {
            return this.value;
        }
        return null;
    }

    public boolean isEqualNode(Node node) {
        return this.equals(node);
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    class EmptyNodeList
    implements NodeList {
        EmptyNodeList() {
        }

        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }
    }
}

