/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;

class DefaultFunctionCallExpr
extends DefaultExpr
implements FunctionCallExpr {
    private String prefix;
    private String functionName;
    private List parameters;

    public DefaultFunctionCallExpr(String string, String string2) {
        this.prefix = string;
        this.functionName = string2;
        this.parameters = new ArrayList();
    }

    public void addParameter(Expr expr) {
        this.parameters.add(expr);
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPrefix();
        if (string != null && !string.equals("")) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append("(");
        Iterator iterator = this.getParameters().iterator();
        Expr expr = null;
        while (iterator.hasNext()) {
            expr = (Expr)iterator.next();
            stringBuffer.append(expr.getText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Expr simplify() {
        List list = this.getParameters();
        int n = list.size();
        Expr expr = null;
        ArrayList<Expr> arrayList = new ArrayList<Expr>(n);
        int n2 = 0;
        while (n2 < n) {
            expr = (Expr)list.get(n2);
            arrayList.add(expr.simplify());
            ++n2;
        }
        this.parameters = arrayList;
        return this;
    }

    public String toString() {
        String string = this.getPrefix();
        if (string == null) {
            return "[(DefaultFunctionCallExpr): " + this.getFunctionName() + "(" + this.getParameters() + ") ]";
        }
        return "[(DefaultFunctionCallExpr): " + this.getPrefix() + ":" + this.getFunctionName() + "(" + this.getParameters() + ") ]";
    }

    public Object evaluate(Context context) throws JaxenException {
        String string = context.translateNamespacePrefixToUri(this.getPrefix());
        Function function = context.getFunction(string, this.getPrefix(), this.getFunctionName());
        List list = this.getParameters();
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Expr expr = null;
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            expr = (Expr)list.get(n2);
            object = expr.evaluate(context);
            arrayList.add(object);
            ++n2;
        }
        return function.call(context, arrayList);
    }
}

