/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.RNCConstants;
import com.objfac.rnceditor.partition.RNCPartitionScanner;
import com.objfac.rnceditor.partition.RNCPartitioner;
import com.objfac.util.Misc;
import com.objfac.xmleditor.BaseDocumentProvider;
import com.objfac.xmleditor.BaseEditorEnvironment;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.IReaderStorage;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.ui.IEditorInput;

public class RNCDocumentProvider
extends BaseDocumentProvider {
    private static RNCPartitionScanner fScanner;

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument;
        block3: {
            iDocument = super.createDocument(object);
            try {
                RNCDocumentProvider.setPartitioner(iDocument);
            }
            catch (Throwable throwable) {
                XMLPlugin.log(throwable);
                if (throwable instanceof CoreException) {
                    throw (CoreException)throwable;
                }
                if (!(throwable instanceof Error)) break block3;
                throw (Error)throwable;
            }
        }
        return iDocument;
    }

    public static IDocument createXMLDocument(String string) {
        Document document;
        block2: {
            document = new Document(string);
            try {
                RNCDocumentProvider.setPartitioner((IDocument)document);
            }
            catch (Throwable throwable) {
                XMLPlugin.log(throwable);
                if (!(throwable instanceof Error)) break block2;
                throw (Error)throwable;
            }
        }
        return document;
    }

    private static void setPartitioner(IDocument iDocument) {
        if (iDocument != null) {
            IDocumentPartitioner iDocumentPartitioner = RNCDocumentProvider.createRNCPartitioner();
            iDocumentPartitioner.connect(iDocument);
            if (iDocumentPartitioner instanceof IDocumentExtension3) {
                IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocumentPartitioner;
                iDocumentExtension3.setDocumentPartitioner("com.objfac.rncpartitioner", iDocumentPartitioner);
            }
        }
    }

    public static IDocumentPartitioner createRNCPartitioner() {
        return new RNCPartitioner((ITokenScanner)RNCDocumentProvider.getRNCPartitionScanner(), RNCConstants.TYPES);
    }

    public static RNCPartitionScanner getRNCPartitionScanner() {
        if (fScanner == null) {
            fScanner = new RNCPartitionScanner();
        }
        return fScanner;
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IReaderStorage) {
            IReaderStorage iReaderStorage = (IReaderStorage)iEditorInput;
            return this.setDocumentContent(iDocument, iReaderStorage.getCharContents());
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IReaderStorage) {
            IReaderStorage iReaderStorage = (IReaderStorage)iEditorInput;
            return this.setDocumentContent(iDocument, iReaderStorage.getCharContents());
        }
        return super.setDocumentContent(iDocument, iEditorInput);
    }

    protected String getPersistedEncoding(Object object) {
        return super.getPersistedEncoding(object);
    }

    protected boolean setDocumentContent(IDocument iDocument, Reader reader) {
        try {
            iDocument.set(Misc.read((Reader)reader));
            return true;
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
            return false;
        }
    }

    protected BaseEditorEnvironment getEditorEnvironment() {
        return XMLPlugin.getDefault().getRNCEditorEnvironment();
    }
}

