/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.PartitionUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class XMLContentOutlinePage
extends ContentOutlinePage {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected static final int FIRSTNWS = 0;
    protected static final int TAGNAME = 1;
    protected static final int SKIP = 2;
    protected static final int JSP = 3;
    protected static final int JSPDECL = 4;
    protected static final int END = 5;
    protected static final Integer IFIRSTNWS = new Integer(0);
    protected static final Integer ITAGNAME = new Integer(1);
    protected static final Integer ISKIP = new Integer(2);
    protected static final Integer IJSP = new Integer(3);
    protected static final Integer IJSPDECL = new Integer(4);
    protected static final Integer IEND = new Integer(5);
    protected HashMap fNameMap = new HashMap();

    public XMLContentOutlinePage(IDocumentProvider iDocumentProvider, ITextEditor iTextEditor) {
        this.fNameMap.put("com.objfac.xmlcomment", IFIRSTNWS);
        this.fNameMap.put("com.objfac.xmltag", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlstarttag", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlemptytag", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlendtag", IEND);
        this.fNameMap.put("com.objfac.xmlcdata", ISKIP);
        this.fNameMap.put("com.objfac.xmlxml", ITAGNAME);
        this.fNameMap.put("com.objfac.xmldoctype", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlpi", ITAGNAME);
        this.fNameMap.put("com.objfac.xmljasp", IJSP);
        this.fNameMap.put("com.objfac.xmljaspdecl", IJSPDECL);
        this.fNameMap.put("com.objfac.xmltext", ISKIP);
        this.fNameMap.put("com.objfac.xmlelement", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlgentity", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlpentity", ITAGNAME);
        this.fNameMap.put("com.objfac.xmlattlist", ITAGNAME);
        this.fNameMap.put("com.objfac.xmldoctype", ITAGNAME);
        this.fNameMap.put("com.objfac.xmldoctypestart", ITAGNAME);
        this.fNameMap.put("com.objfac.xmldoctypeend", IEND);
        this.fDocumentProvider = iDocumentProvider;
        this.fTextEditor = iTextEditor;
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            treeViewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        super.selectionChanged(selectionChangedEvent);
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Tag tag = (Tag)((IStructuredSelection)iSelection).getFirstElement();
            int n = tag.fPosition.getOffset();
            int n2 = tag.fPosition.getLength();
            try {
                this.fTextEditor.setHighlightRange(n, n2, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object object) {
        this.fInput = object;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            treeViewer.setInput(this.fInput);
            ContentProvider contentProvider = (ContentProvider)treeViewer.getContentProvider();
            ITextSelection iTextSelection = (ITextSelection)this.fTextEditor.getSelectionProvider().getSelection();
            Tag tag = contentProvider.findTag(iTextSelection.getOffset());
            StructuredSelection structuredSelection = tag == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)tag);
            treeViewer.setSelection((ISelection)structuredSelection, true);
            control.setRedraw(true);
            treeViewer.reveal((Object)tag);
        }
    }

    public void changeSelection() {
        Control control;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            ITextSelection iTextSelection;
            ContentProvider contentProvider;
            Tag tag;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
            Tag tag2 = (Tag)iStructuredSelection.getFirstElement();
            if (tag2 != (tag = (contentProvider = (ContentProvider)treeViewer.getContentProvider()).findTag((iTextSelection = (ITextSelection)this.fTextEditor.getSelectionProvider().getSelection()).getOffset()))) {
                StructuredSelection structuredSelection = tag == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)tag);
                control.setRedraw(false);
                treeViewer.setSelection((ISelection)structuredSelection, true);
                control.setRedraw(true);
            }
            treeViewer.reveal((Object)tag);
        }
    }

    protected static class Tag {
        public String fType;
        public String fName;
        public Position fPosition;
        public ArrayList fContent;
        public Tag fParent;
        public int fBeg;
        public int fLen;

        public Tag(String string, String string2, Position position, Tag tag) {
            this.fType = string;
            this.fName = string2;
            this.fPosition = position;
            this.fParent = tag;
        }

        public Tag(String string, String string2, int n, int n2, Tag tag) {
            this.fType = string;
            this.fName = string2;
            this.fBeg = n;
            this.fLen = n2;
            this.fParent = tag;
        }

        public Tag(ArrayList arrayList) {
            this.fContent = arrayList;
        }

        public String toString() {
            return this.fName;
        }

        public boolean contains(int n) {
            if (this.fPosition.getLength() == 1) {
                return this.fPosition.getOffset() < n && n <= this.fPosition.getOffset() + this.fPosition.getLength();
            }
            return this.fPosition.getOffset() < n && n < this.fPosition.getOffset() + this.fPosition.getLength();
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String TAGS = "com.objfac.tag";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("com.objfac.tag");
        protected ArrayList fContent = new ArrayList();
        protected Tag fRoot = new Tag(this.fContent);
        protected Tag fParent;

        protected ContentProvider() {
        }

        protected void parse(IDocument iDocument) {
            ITypedRegion iTypedRegion;
            int n = iDocument.getLength();
            int n2 = 0;
            this.fParent = this.fRoot;
            try {
                while (n2 < n) {
                    iTypedRegion = PartitionUtils.getPartition(iDocument, "com.objfac.xmlpartitioner", n2, false);
                    String string = iTypedRegion.getType();
                    int n3 = iTypedRegion.getOffset();
                    int n4 = iTypedRegion.getLength();
                    this.addTag(iDocument, n, string, n3, n4);
                    n2 += n4;
                }
            }
            catch (Exception exception) {
                XMLPlugin.log(exception);
            }
            try {
                while (this.fParent != this.fRoot) {
                    iTypedRegion = new Position(this.fParent.fBeg, n - this.fParent.fBeg);
                    iDocument.addPosition(TAGS, (Position)iTypedRegion);
                    this.fParent.fPosition = iTypedRegion;
                    this.fParent = this.fParent.fParent;
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                XMLPlugin.log(badPositionCategoryException);
            }
            this.fContent = this.fRoot.fContent;
        }

        protected void addTag(IDocument iDocument, int n, String string, int n2, int n3) throws Exception {
            Integer n4 = (Integer)XMLContentOutlinePage.this.fNameMap.get(string);
            if (n4 == null) {
                return;
            }
            switch (n4) {
                case 0: {
                    break;
                }
                case 1: {
                    String string2 = this.collectTagName(iDocument, n2, n3);
                    if (string.equals("com.objfac.xmlstarttag") || string.equals("com.objfac.xmldoctypestart")) {
                        Tag tag = new Tag(string, string2, n2, n3, this.fParent);
                        this.fContent.add(tag);
                        this.fContent = new ArrayList();
                        tag.fContent = this.fContent;
                        tag.fParent = this.fParent;
                        this.fParent = tag;
                        break;
                    }
                    Position position = new Position(n2, n3);
                    iDocument.addPosition(TAGS, position);
                    Tag tag = new Tag(string, string2, position, this.fParent);
                    this.fContent.add(tag);
                    break;
                }
                case 5: {
                    String string3 = this.collectTagName(iDocument, n2 + 1, n3 - 1);
                    if (this.fParent == null || (string != "com.objfac.xmldoctypeend" || this.fParent.fType != "com.objfac.xmldoctypestart") && (this.fParent.fName == null || !string3.equals(this.fParent.fName))) break;
                    Position position = new Position(this.fParent.fBeg, n2 + n3 - this.fParent.fBeg);
                    iDocument.addPosition(TAGS, position);
                    this.fParent.fPosition = position;
                    this.fParent = this.fParent.fParent;
                    this.fContent = this.fParent.fContent;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (n3 <= 2) break;
                    iDocument.getChar(n2 += 2);
                    break;
                }
            }
        }

        protected String collectTagName(IDocument iDocument, int n, int n2) throws Exception {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 1) {
                char c = iDocument.getChar(++n);
                n2 -= 2;
                block0 : switch (c) {
                    case '?': {
                        stringBuffer.setLength(0);
                        while (n2-- > 0) {
                            if (XMLCharacter.isWhitespace((char)(c = iDocument.getChar(++n))) || c == '?') break block0;
                            stringBuffer.append(c);
                        }
                        break;
                    }
                    case '!': {
                        stringBuffer.append(c);
                        while (n2-- > 0) {
                            if (XMLCharacter.isWhitespace((char)(c = iDocument.getChar(++n)))) break;
                            stringBuffer.append(c);
                        }
                        String string = stringBuffer.toString();
                        while (n2-- > 0) {
                            if (!XMLCharacter.isWhitespace((char)(c = iDocument.getChar(++n)))) break;
                        }
                        stringBuffer.setLength(0);
                        if (string.equals("!ENTITY") && c == '%') {
                            while (n2-- > 0) {
                                if (!XMLCharacter.isWhitespace((char)(c = iDocument.getChar(++n)))) break;
                            }
                        }
                        if (!XMLCharacter.isIDStart((char)c)) break;
                        stringBuffer.append(c);
                        while (n2-- > 0) {
                            if (!XMLCharacter.isIDPart((char)(c = iDocument.getChar(++n)))) break block0;
                            stringBuffer.append(c);
                        }
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        while (n2-- > 0) {
                            if (XMLCharacter.isWhitespace((char)(c = iDocument.getChar(++n))) || c == '/' || c == '>') break block0;
                            stringBuffer.append(c);
                        }
                        break block0;
                    }
                }
            }
            return stringBuffer.toString();
        }

        public Tag findTag(int n) {
            return this.findTag(this.fContent, null, n);
        }

        private Tag findTag(ArrayList arrayList, Tag tag, int n) {
            int n2 = 0;
            int n3 = arrayList.size();
            while (n2 < n3) {
                Tag tag2 = (Tag)arrayList.get(n2);
                Tag tag3 = this.findTag(tag2, n);
                if (tag3 != null) {
                    return tag3;
                }
                ++n2;
            }
            return null;
        }

        private Tag findTag(Tag tag, int n) {
            Tag tag2 = null;
            ArrayList arrayList = tag.fContent;
            if (arrayList != null) {
                tag2 = this.findTag(arrayList, tag, n);
            }
            if (tag2 == null && tag.contains(n)) {
                tag2 = tag;
            }
            return tag2;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            IDocument iDocument;
            if (object != null && (iDocument = XMLContentOutlinePage.this.fDocumentProvider.getDocument(object)) != null) {
                try {
                    iDocument.removePositionCategory(TAGS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    XMLPlugin.log(badPositionCategoryException);
                }
                iDocument.removePositionUpdater(this.fPositionUpdater);
            }
            this.fContent.clear();
            if (object2 != null && (iDocument = XMLContentOutlinePage.this.fDocumentProvider.getDocument(object2)) != null) {
                iDocument.addPositionCategory(TAGS);
                iDocument.addPositionUpdater(this.fPositionUpdater);
                this.parse(iDocument);
            }
        }

        public void reparse() {
            IDocument iDocument = XMLContentOutlinePage.this.fDocumentProvider.getDocument(XMLContentOutlinePage.this.fInput);
            if (iDocument != null) {
                try {
                    iDocument.removePositionCategory(TAGS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    XMLPlugin.log(badPositionCategoryException);
                }
                iDocument.removePositionUpdater(this.fPositionUpdater);
                iDocument.addPositionCategory(TAGS);
                iDocument.addPositionUpdater(this.fPositionUpdater);
                this.parse(iDocument);
            }
        }

        public void dispose() {
            if (this.fContent != null) {
                this.fContent.clear();
                this.fContent = null;
            }
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public Object[] getElements(Object object) {
            return this.fContent.toArray();
        }

        public boolean hasChildren(Object object) {
            Tag tag = (Tag)object;
            return tag.fContent != null && tag.fContent.size() > 0;
        }

        public Object getParent(Object object) {
            return ((Tag)object).fParent;
        }

        public Object[] getChildren(Object object) {
            Tag tag = (Tag)object;
            if (tag.fContent != null) {
                return tag.fContent.toArray();
            }
            return new Object[0];
        }
    }

    private class TagLabelProvider
    extends LabelProvider {
        String[] fRelUrls = new String[]{"com.objfac.xmlattlist", "icons/basic/obj16/attlist.gif", "com.objfac.xmldoctype", "icons/basic/obj16/doctype.gif", "com.objfac.xmldoctypestart", "icons/basic/obj16/doctype.gif", "com.objfac.xmlelement", "icons/basic/obj16/elementdef.gif", "com.objfac.xmlemptytag", "icons/basic/obj16/emptytag.gif", "com.objfac.xmlgentity", "icons/basic/obj16/gent.gif", "com.objfac.xmlpentity", "icons/basic/obj16/pent.gif", "com.objfac.xmlgentityref", "icons/basic/obj16/gentref.gif", "com.objfac.xmljasp", "icons/basic/obj16/jsp.gif", "com.objfac.xmljaspdecl", "icons/basic/obj16/jsp.gif", "com.objfac.xmlnotation", "icons/basic/obj16/notation.gif", "com.objfac.xmlpentityref", "icons/basic/obj16/pentref.gif", "com.objfac.xmlpi", "icons/basic/obj16/pi.gif", "com.objfac.xmlstarttag", "icons/basic/obj16/starttag.gif", "com.objfac.xmltag", "icons/basic/obj16/tag.gif", "com.objfac.xmlxml", "icons/basic/obj16/xmldecl.gif"};
        HashMap fImageMap = new HashMap();
        URL fInstallUrl = XMLPlugin.getDefault().getDescriptor().getInstallURL();

        TagLabelProvider() {
        }

        public void dispose() {
            Iterator iterator = this.fImageMap.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.fImageMap.clear();
            super.dispose();
        }

        public Image getImage(Object object) {
            Tag tag = (Tag)object;
            String string = tag.fType;
            Image image = (Image)this.fImageMap.get(string);
            if (image == null) {
                int n = 0;
                while (n < this.fRelUrls.length) {
                    String string2 = this.fRelUrls[n];
                    if (string2.equals(string)) {
                        String string3 = this.fRelUrls[n + 1];
                        try {
                            URL uRL = new URL(this.fInstallUrl, string3);
                            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                            image = imageDescriptor.createImage();
                            this.fImageMap.put(string, image);
                        }
                        catch (MalformedURLException malformedURLException) {
                            XMLPlugin.log(malformedURLException);
                        }
                        break;
                    }
                    n += 2;
                }
            }
            return image;
        }
    }
}

