/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.xmleditor.ICursorListener;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.FilterIterator;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class XMLCutEndTagAction
implements IEditorActionDelegate,
ICursorListener {
    private XMLEditor fEditor;
    private IAction fAction;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fAction = iAction;
        XMLEditor xMLEditor = this.fEditor;
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
        if (xMLEditor != this.fEditor) {
            if (xMLEditor != null) {
                xMLEditor.removeCursorListener(this);
            }
            if (this.fEditor != null) {
                this.fEditor.addCursorListener(this);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction iAction) {
        XMLNode xMLNode = this.getEndTag();
        if (xMLNode == null) return;
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iSourceViewer == null) return;
        if (iDocument == null) return;
        Clipboard clipboard = new Clipboard(iSourceViewer.getTextWidget().getDisplay());
        try {
            try {
                int n = xMLNode.getOffset();
                int n2 = xMLNode.getLength();
                String string = iDocument.get(n, n2);
                clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                iDocument.replace(n, n2, "");
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            clipboard.dispose();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        clipboard.dispose();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(this.getEndTag(iSelection) != null);
    }

    public void mouseUp() {
        if (this.fAction != null) {
            this.fAction.setEnabled(this.getEndTag() != null);
        }
    }

    public void modified() {
        if (this.fEditor != null) {
            XMLTree xMLTree = this.fEditor.getXMLTree();
            boolean bl = true;
            if (xMLTree.isIncremental()) {
                bl = false;
                List list = xMLTree.getIncrementalChanges(FilterIterator.ALL);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = ((XMLNode)iterator.next()).getType();
                    if (string != "com.objfac.xmlstarttag" && string != "com.objfac.xmlendtag") continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.fAction.setEnabled(this.getEndTag() != null);
            }
        }
    }

    private XMLNode getEndTag(ISelection iSelection) {
        if (this.fEditor != null && iSelection instanceof TextSelection) {
            XMLNode xMLNode;
            TextSelection textSelection = (TextSelection)iSelection;
            int n = textSelection.getOffset();
            XMLTree xMLTree = this.fEditor.getXMLTree();
            if (xMLTree != null && (xMLNode = xMLTree.findNode(n)) != null) {
                XMLNode xMLNode2 = null;
                String string = xMLNode.getType();
                if (string == "com.objfac.xmlendtag") {
                    xMLNode2 = xMLNode;
                } else if (string == "com.objfac.xmlstarttag" && xMLNode.lastChild != null && xMLNode.lastChild.getType() == "com.objfac.xmlendtag") {
                    xMLNode2 = xMLNode.lastChild;
                } else if (xMLNode.parent != null && xMLNode.parent.getType() == "com.objfac.xmlstarttag" && xMLNode.parent.lastChild != null && xMLNode.parent.lastChild.getType() == "com.objfac.xmlendtag") {
                    xMLNode2 = xMLNode.parent.lastChild;
                }
                return xMLNode2;
            }
        }
        return null;
    }

    private XMLNode getEndTag() {
        ISelectionProvider iSelectionProvider;
        if (this.fEditor != null && (iSelectionProvider = this.fEditor.getSelectionProvider()) != null) {
            ISelection iSelection = iSelectionProvider.getSelection();
            return this.getEndTag(iSelection);
        }
        return null;
    }
}

