/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.util.Misc;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.actions.DefinitionFinder;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.actions.XSDDefinitionFinder;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLNodeTree;
import com.objfac.xmleditor.xmltree.XMLTree;

public class XSDEditor
extends XMLEditor {
    private DefinitionFinder fDefinitionFinder;

    public XSDEditor() {
        super(true);
    }

    public int getEditorKind() {
        return 4;
    }

    public String getEditorId() {
        return "com.objfac.xmleditor.XMLEditor.xsd";
    }

    protected void backgroundHandleDependencies(long l) {
        DependencyManager dependencyManager = DependencyManager.getSingletonManager();
        String string = this.getUrl();
        XMLTree xMLTree = this.getXMLTree();
        XSDEditor.setDependencies(dependencyManager, string, xMLTree, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDependencies(final DependencyManager dependencyManager, final String string, XMLTree xMLTree, long l) {
        dependencyManager.forget(string);
        try {
            if (xMLTree != null) {
                final String string2 = XSDEditor.getTargetNamespace(xMLTree);
                xMLTree.visit(new XMLNodeTree.Visitor(){

                    public void visit(XMLNode xMLNode) {
                        String string6;
                        String string22 = xMLNode.getType();
                        if ((string22 == "com.objfac.xmlstarttag" || string22 == "com.objfac.xmlemptytag") && (string6 = xMLNode.getNamespace()) != null && string6.equals("http://www.w3.org/2001/XMLSchema")) {
                            String string3;
                            boolean bl;
                            String string4 = xMLNode.getLocalname();
                            boolean bl2 = bl = "include".equals(string4) || "redefine".equals(string4);
                            if ((bl || "import".equals(string4)) && (string3 = xMLNode.getAttributeValue("schemaLocation")) != null) {
                                String string5 = Misc.getAbsUrl((String)string, (String)string3);
                                dependencyManager.addDependency(string, string5, bl);
                                if (bl) {
                                    dependencyManager.setTargetNamespace(string, string2);
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            dependencyManager.remember(string);
            throw throwable;
        }
        {
            Object var6_7 = null;
            dependencyManager.remember(string);
            return;
        }
    }

    private static String getTargetNamespace(XMLTree xMLTree) {
        String string;
        String string2;
        XMLNode xMLNode = xMLTree.getRoot();
        if (xMLNode != null && xMLNode.getLocalname().equals("schema") && (string2 = xMLNode.getNamespace()) != null && string2.equals("http://www.w3.org/2001/XMLSchema") && (string = xMLNode.getAttributeValue("targetNamespace")) != null) {
            return string.trim();
        }
        return "";
    }

    public boolean canOpenDefinition() {
        return this.getDefinitionFinder().getDefinitionTarget() != null;
    }

    public void openDefinition() {
        this.getDefinitionFinder().openDefinition();
    }

    private DefinitionFinder getDefinitionFinder() {
        if (this.fDefinitionFinder == null) {
            this.fDefinitionFinder = new XSDDefinitionFinder(this);
        }
        return this.fDefinitionFinder;
    }
}

