/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.walker.IWalker;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.io.CharArrayWriter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class FlattenRNGAction
implements IEditorActionDelegate {
    private XMLEditor fEditor;
    private static final String RNG_EXTENSION = ".rng";
    private static final String FLAT = "_flat";

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
        iAction.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.fEditor == null) {
            return false;
        }
        if (this.fEditor.getEditorKind() == 2) {
            return true;
        }
        DTDParams dTDParams = this.fEditor.getDTDParams();
        return dTDParams.trng && dTDParams.url != null;
    }

    public void run(IAction iAction) {
        String string;
        XMLNode xMLNode;
        if (!this.isEnabled()) {
            return;
        }
        XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
        String string2 = null;
        XMLTree xMLTree = this.fEditor.getXMLTree();
        XMLNode xMLNode2 = xMLTree.getDoctype();
        IDocument iDocument = null;
        if (xMLNode2 != null && (iDocument = this.fEditor.getDocument()) != null) {
            xMLNode = xMLNode2;
            if (xMLNode2.getType() == "com.objfac.xmldoctypestart") {
                xMLNode = xMLNode2.getLastChild();
            }
            if ((string = xMLNode.getType()) == "com.objfac.xmldoctype" || string == "com.objfac.xmldoctypeend") {
                try {
                    string2 = iDocument.get(xMLNode2.getOffset(), xMLNode.getOffset() + xMLNode.getLength());
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
        new ErrorCollector();
        xMLNode = xMLSchemaReaderShell.backgroundReadThisSchema(this.fEditor.getEditorKind(), this.fEditor.getDTDParams(), this.fEditor.getUrl(), this.fEditor.getEncoding(), string2, this.fEditor.getResourceWatcherCallback());
        if (xMLNode != null) {
            string = Misc.getName((String)this.fEditor.getUrl());
            String string3 = Local.format((String)"<!-- Flattened RELAX NG generated from {0} by XMLBuddy -->", (Object)string);
            CharArrayWriter charArrayWriter = xMLSchemaReaderShell.dumpWalker((IWalker)xMLNode, string3, false, 1);
            int n = string.lastIndexOf(46);
            String string4 = n < 0 ? String.valueOf(string) + FLAT + RNG_EXTENSION : String.valueOf(string.substring(0, n)) + FLAT + RNG_EXTENSION;
            Storage storage = new Storage(charArrayWriter.toCharArray(), string4, string, "UTF-8");
            IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                try {
                    iWorkbenchPage.openEditor((IEditorInput)storage, "com.objfac.xmleditor.XMLEditor.rng");
                }
                catch (PartInitException partInitException) {
                    XMLPlugin.log(partInitException);
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

