/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.CaselessMap;
import com.objfac.util.Misc;
import com.objfac.util.config.LookaheadIterator;
import com.objfac.util.config.POMDocument;
import com.objfac.util.config.Parameter;
import com.objfac.util.config.ParameterParser;
import com.objfac.util.config.event.ErrorCollector;
import com.objfac.util.config.event.ErrorHandler;
import com.objfac.xmleditor.Messages;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.FormatRules;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FormatRuleRegistry {
    private static HashMap rulesByNamespace;
    static /* synthetic */ Class class$0;

    public static synchronized FormatRules getRules(String string, String string2) {
        FormatRules formatRules;
        if (rulesByNamespace == null) {
            rulesByNamespace = new HashMap();
            FormatRuleRegistry.readFormatRules();
        }
        if ((formatRules = (FormatRules)rulesByNamespace.get(FormatRuleRegistry.makeQName(string, string2))) == null) {
            formatRules = (FormatRules)rulesByNamespace.get(FormatRuleRegistry.makeQName(string, ""));
        }
        if (formatRules != null) {
            return formatRules;
        }
        return FormatRules.DEFAULT_RULES;
    }

    public static synchronized void addRules(FormatRules formatRules) {
        if (formatRules.ruleNamespace != null && formatRules.ruleNamespace.length() > 0) {
            rulesByNamespace.put(formatRules.ruleNamespace, formatRules);
        }
    }

    public static synchronized FormatRules[] getRules() {
        Collection collection = rulesByNamespace.values();
        return collection.toArray(new FormatRules[collection.size()]);
    }

    public static synchronized void resetRules() {
        rulesByNamespace = null;
        FormatRuleRegistry.getRules("", "");
    }

    public static synchronized void readFormatRules(InputStream inputStream) {
        FormatRules formatRules = FormatRuleRegistry.readRules(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        Map map = FormatRuleRegistry.makePrefixMap(formatRules);
        String[] stringArray = FormatRuleRegistry.makeNamespace(formatRules.ruleNamespace, map);
        if (stringArray.length > 0) {
            formatRules.ruleNamespace = Misc.arrayToSv((String[])stringArray, (String)" ");
            formatRules.keepStartTagsOnSameLine = FormatRuleRegistry.makeQNames(formatRules.keepStartTagsOnSameLine, map);
            formatRules.keepEndTagsOnSameLine = FormatRuleRegistry.makeQNames(formatRules.keepEndTagsOnSameLine, map);
            formatRules.keepContentsAsIs = FormatRuleRegistry.makeQNames(formatRules.keepContentsAsIs, map);
            formatRules.startLeft = FormatRuleRegistry.makeQNames(formatRules.startLeft, map);
            int n = 0;
            while (n < stringArray.length) {
                rulesByNamespace.put(stringArray[n], formatRules);
                ++n;
            }
        }
    }

    public static Map makePrefixMap(FormatRules formatRules) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = formatRules.namespaces;
        String[] stringArray = Misc.ssvToArray((String)string);
        int n = stringArray.length & 0xFFFFFFFE;
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(stringArray[n2], stringArray[n2 + 1]);
            n2 += 2;
        }
        return hashMap;
    }

    public static Set makeKeepSet(FormatRules formatRules, String string) {
        Object object = formatRules.ignoreCaseInElementNames ? new CaselessMap() : new HashMap();
        String[] stringArray = Misc.ssvToArray((String)string);
        int n = 0;
        while (n < stringArray.length) {
            ((HashMap)object).put(stringArray[n], stringArray[n]);
            ++n;
        }
        return ((HashMap)object).keySet();
    }

    public static String makeQName(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return String.valueOf(string2) + "{" + string + "}";
    }

    private static String makeElementQName(String string, Map map) {
        int n;
        String string2 = "";
        String string3 = string;
        if (string3 != null && string3.length() > 0 && map.size() > 0 && (n = string3.indexOf(58)) >= 0) {
            String string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            if (string4.length() == 0 || string3.length() == 0) {
                return null;
            }
            string2 = (String)map.get(string4);
            if (string2 == null) {
                return null;
            }
        }
        return FormatRuleRegistry.makeQName(string2, string3);
    }

    private static void readFormatRules() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.objfac.xmleditor.actions.FormatRuleRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FormatRuleRegistry.readFormatRules(clazz.getClassLoader().getResourceAsStream("com/objfac/xmleditor/actions/html.fmt"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.objfac.xmleditor.actions.FormatRuleRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FormatRuleRegistry.readFormatRules(clazz2.getClassLoader().getResourceAsStream("com/objfac/xmleditor/actions/xhtml.fmt"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.objfac.xmleditor.actions.FormatRuleRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FormatRuleRegistry.readFormatRules(clazz3.getClassLoader().getResourceAsStream("com/objfac/xmleditor/actions/docbook.fmt"));
        String string = XMLPlugin.getDefault().getPreferenceStore().getString("com.objfac.xmleditor.formatrules");
        String[] stringArray = Misc.csvToArray((String)string);
        int n = 0;
        while (n < stringArray.length) {
            try {
                FormatRuleRegistry.readFormatRules(new FileInputStream(new File(stringArray[n])));
            }
            catch (FileNotFoundException fileNotFoundException) {
                XMLPlugin.log(MessageFormat.format(Messages.rulesNotFound, stringArray[n]));
            }
            ++n;
        }
    }

    private static String[] makeNamespace(String string, Map map) {
        String[] stringArray = Misc.ssvToArray((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(58);
            int n3 = string2.lastIndexOf(58);
            int n4 = string2.indexOf(47);
            String string3 = n4 >= 0 || n2 != n3 ? FormatRuleRegistry.makeQName(string2, "") : FormatRuleRegistry.makeElementQName(stringArray[n], map);
            if (string3 != null) {
                arrayList.add(string3);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String makeQNames(String string, Map map) {
        String[] stringArray = Misc.ssvToArray((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = FormatRuleRegistry.makeElementQName(stringArray[n], map);
            if (string2 != null) {
                arrayList.add(string2);
            }
            ++n;
        }
        return Misc.CollectionToSv(arrayList, (String)" ");
    }

    private static FormatRules readRules(InputStream inputStream) {
        FormatRules formatRules = null;
        if (inputStream != null) {
            formatRules = FormatRules.copyDefaultRules();
            ErrorCollector errorCollector = new ErrorCollector(true);
            POMDocument pOMDocument = ParameterParser.parseDocument((InputStream)inputStream, (ErrorHandler)errorCollector, (boolean)true);
            if (errorCollector.getMaxSeverity() <= 0) {
                LookaheadIterator lookaheadIterator = pOMDocument.getParameters();
                while (lookaheadIterator.hasNext()) {
                    Parameter parameter = (Parameter)lookaheadIterator.next();
                    int n = FormatRules.ruleIndex(parameter.getId());
                    switch (n) {
                        case 0: {
                            formatRules.ruleNamespace = parameter.getTrimText();
                            break;
                        }
                        case 1: {
                            formatRules.namespaces = parameter.getTrimText();
                            break;
                        }
                        case 2: {
                            formatRules.indentNestedElements = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 3: {
                            formatRules.keepStartTagsOnSameLine = parameter.getTrimText();
                            break;
                        }
                        case 4: {
                            formatRules.keepEndTagsOnSameLine = parameter.getTrimText();
                            break;
                        }
                        case 5: {
                            formatRules.keepContentsAsIs = parameter.getTrimText();
                            break;
                        }
                        case 6: {
                            formatRules.startLeft = parameter.getTrimText();
                            break;
                        }
                        case 7: {
                            formatRules.ignoreCaseInElementNames = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 8: {
                            formatRules.indentNestedDeclarations = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 9: {
                            formatRules.flowText = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 10: {
                            formatRules.textRuler = Integer.parseInt(parameter.getTrimText());
                            if (formatRules.textRuler >= 50) break;
                            formatRules.textRuler = 50;
                            break;
                        }
                        case 11: {
                            formatRules.indentEndTags = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 12: {
                            formatRules.preserveSpaceInComments = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 13: {
                            formatRules.flowComments = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 14: {
                            formatRules.flowTagContents = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 15: {
                            formatRules.keepEmptyLines = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 16: {
                            formatRules.keepOneEmptyLine = parameter.getTrimText().equals("true");
                            break;
                        }
                        case 17: {
                            boolean bl = formatRules.indentToTabBoundaries = parameter.getTrimText().equals("true");
                        }
                    }
                }
            }
        }
        return formatRules;
    }
}

