/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.generators.XMLDTDGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class XMLGenerateDTDAction
implements IEditorActionDelegate,
IErrorHandler {
    private XMLEditor fEditor;
    private ISelection fSelection;
    private XMLDTDGenerator fGenerator;
    private String fError;
    private static final String DTD_EXTENSION = ".dtd";
    private static XMLGenerateDTDAction fDelegate;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction iAction) {
        String string;
        if (!(this.fSelection instanceof ITextSelection)) return;
        if (this.fEditor == null) return;
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        String string2 = string = iEditorInput.getName();
        int n = string.lastIndexOf(46);
        string = n > 0 ? String.valueOf(string.substring(0, n)) + DTD_EXTENSION : String.valueOf(string) + DTD_EXTENSION;
        this.fGenerator = new XMLDTDGenerator(this);
        try {
            block11: {
                IDocument iDocument;
                this.fError = null;
                this.fGenerator.run(this.fEditor.getXMLTree().getHead(), XMLPlugin.getLogger());
                if (this.fError != null) {
                    ErrorDialog.openError((Shell)this.fEditor.getViewer().getTextWidget().getShell(), (String)Local.getString((String)"Generate DTD"), (String)Local.getString((String)"Problem detected in XML document"), (IStatus)new Status(4, "com.objfac.xmleditor", 2, this.fError, null));
                }
                if ((iDocument = this.fEditor.getDocument()) != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        String[] stringArray = iDocument.getLegalLineDelimiters();
                        String string3 = stringArray[stringArray.length - 1];
                        outputStreamWriter.write(string3);
                        outputStreamWriter.write("<!-- Generated from " + string2 + " by XMLBuddy -->" + string3);
                        if (!this.fGenerator.printDTD(outputStreamWriter, string3)) break block11;
                        ((Writer)outputStreamWriter).close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        Storage storage = new Storage(byArray, string, string2);
                        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (iWorkbenchPage != null) {
                            try {
                                iWorkbenchPage.openEditor((IEditorInput)storage, "com.objfac.xmleditor.XMLEditor.dtd");
                            }
                            catch (PartInitException partInitException) {
                                XMLPlugin.log(partInitException);
                            }
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        XMLPlugin.log(unsupportedEncodingException);
                    }
                    catch (IOException iOException) {
                        XMLPlugin.log(iOException);
                    }
                }
            }
            Object var15_19 = null;
            this.fGenerator = null;
            return;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.fGenerator = null;
            throw throwable;
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection;
        boolean bl = false;
        if (iSelection instanceof ITextSelection && this.fEditor != null) {
            bl = this.fEditor.getEditorKind() == 0 && this.fEditor.isXml();
        }
        iAction.setEnabled(bl);
    }

    public boolean error(String string) {
        this.fError = string;
        return false;
    }

    public static XMLGenerateDTDAction getDelegate() {
        if (fDelegate == null) {
            fDelegate = new XMLGenerateDTDAction();
        }
        return fDelegate;
    }
}

