/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.walker.DocumentContext;
import com.objfac.walker.DummyContext;
import com.objfac.walker.IWalker;
import com.objfac.walker.gen.GenerateXMLResult;
import com.objfac.xml.schema.SchemaConstants;
import com.objfac.xmleditor.notes.Name;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class XMLGenerator {
    private StringBuffer altNs;
    private String defaultPrefix;
    private String[] rootAttrs;
    private int elementCount;
    private int maxElements;
    private boolean inText;
    private int uniqueId;
    private int prefixCount;
    private int lineMax;
    private int tabCount;
    private int lineLength;
    private int nest;
    boolean inElement;
    private PrintWriter writer;
    private HashMap genCount;
    private HashMap nsToPrefix;
    private HashMap nsToAliasPrefix;
    private LinkedList nslist;
    private String pendingPrefix;
    private String pendingNs;
    private DocumentContext dummyContext = new DummyContext();
    private static final Integer ONE = new Integer(1);
    private static final Integer TWO = new Integer(2);
    private static final Integer TRE = new Integer(3);

    public void generate(Name name, String[] stringArray, GenerateXMLResult generateXMLResult, IWalker iWalker, PrintWriter printWriter, boolean bl, int n, int n2, int n3) {
        this.writer = printWriter;
        this.genCount = new HashMap();
        this.nsToPrefix = new HashMap();
        this.nsToAliasPrefix = new HashMap();
        this.nslist = new LinkedList();
        this.nest = -1;
        this.tabCount = n;
        this.lineMax = n2;
        this.maxElements = n3;
        this.rootAttrs = stringArray;
        this.elementCount = 0;
        this.defaultPrefix = generateXMLResult.prefix;
        this.generateElement(name, iWalker, generateXMLResult, bl);
        this.genCount = null;
        this.nsToPrefix = null;
        this.nsToAliasPrefix = null;
        this.nslist = null;
    }

    private void generateElement(Name name, IWalker iWalker, GenerateXMLResult generateXMLResult, boolean bl) {
        String string;
        Integer n = (Integer)this.genCount.get(name);
        if (n == null) {
            this.genCount.put(name, ONE);
        } else if (n == ONE) {
            this.genCount.put(name, TWO);
        } else if (n == TWO) {
            this.genCount.put(name, TRE);
        } else {
            this.addComment(Local.format((String)"Possible recursive cycle on element {0}. Not generated", (Object)name.localname));
            if (iWalker.acceptElement(name.namespace, name.localname, name.localname)) {
                iWalker.skipAttributes();
                iWalker.skipContents();
            }
            return;
        }
        ++this.elementCount;
        if (this.elementCount == this.maxElements) {
            this.addComment(Local.format((String)"Maximum of {0} elements exceeded", (int)this.maxElements));
        }
        if (this.elementCount >= this.maxElements) {
            return;
        }
        String string2 = name.localname;
        StringBuffer stringBuffer = this.getTopNs();
        if (bl && name.namespace.length() > 0 && (string = this.getPrefix(name.namespace)).length() > 0) {
            string2 = String.valueOf(string) + ':' + name.localname;
        }
        this.startElement(string2);
        if (iWalker.acceptElement(name.namespace, name.localname, name.localname)) {
            if (this.rootAttrs != null) {
                int n2 = 0;
                while (n2 < this.rootAttrs.length) {
                    this.addAttribute(this.rootAttrs[n2], this.rootAttrs[n2 + 1]);
                    n2 += 2;
                }
                this.rootAttrs = null;
            }
            this.generateAttributes(iWalker, generateXMLResult, bl);
            if (!iWalker.acceptEndAttributes()) {
                iWalker.skipAttributes();
            }
            this.generateChildren(iWalker, generateXMLResult, bl);
            if (!iWalker.acceptEndTag(name.namespace, name.localname, name.localname)) {
                iWalker.skipContents();
            }
        }
        this.popTopNs(stringBuffer);
        this.endElement(string2);
        if (n == null) {
            this.genCount.remove(name);
        } else {
            this.genCount.put(name, n);
        }
    }

    private void popTopNs(StringBuffer stringBuffer) {
        if (stringBuffer == null && this.nslist.size() == 0) {
            return;
        }
        StringBuffer stringBuffer2 = (StringBuffer)this.nslist.getLast();
        while (stringBuffer2 != stringBuffer) {
            if (stringBuffer2 == this.altNs) {
                this.altNs = null;
            } else {
                this.nsToPrefix.remove(stringBuffer2.toString());
            }
            this.nslist.removeLast();
            if (this.nslist.size() == 0) break;
            stringBuffer2 = (StringBuffer)this.nslist.getLast();
        }
    }

    private StringBuffer getTopNs() {
        if (this.nslist.size() > 0) {
            return (StringBuffer)this.nslist.getLast();
        }
        return null;
    }

    private void generateChildren(IWalker iWalker, GenerateXMLResult generateXMLResult, boolean bl) {
        if (iWalker.isTextOnly()) {
            String[] stringArray = iWalker.getTextValues();
            String[] stringArray2 = iWalker.getElementTypes();
            Name name = new Name(stringArray2[0], stringArray2[1]);
            String string = this.getValueForType(name, stringArray);
            this.addText(string);
        } else {
            HashSet<String[]> hashSet = null;
            while (this.elementCount < this.maxElements) {
                Name name;
                Object object;
                String[] stringArray = iWalker.getRequiredElements();
                while (stringArray.length > 0) {
                    this.generateElement(new Name(stringArray[0], stringArray[1]), iWalker, generateXMLResult, bl);
                    stringArray = iWalker.getRequiredElements();
                }
                String[] stringArray3 = iWalker.getRepeatingElements();
                if (generateXMLResult.repeatCount > 0) {
                    if (hashSet == null) {
                        hashSet = new HashSet<String[]>();
                    }
                    if ((object = this.getNewName(stringArray3, hashSet)) != null) {
                        hashSet.add((String[])object);
                        int n = 0;
                        while (n < generateXMLResult.repeatCount) {
                            this.generateElement((Name)object, iWalker, generateXMLResult, bl);
                            ++n;
                        }
                        continue;
                    }
                } else if (stringArray3.length > 0) {
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    }
                    object = this.getNewName(stringArray3, hashSet);
                    while (object != null) {
                        hashSet.add((String[])object);
                        object = this.getNewName(stringArray3, hashSet);
                    }
                }
                if (!generateXMLResult.optionalElements || ((String[])(object = iWalker.getElements())).length <= 0 || (name = this.getNewName((String[])object, hashSet)) == null) break;
                this.generateElement(name, iWalker, generateXMLResult, bl);
            }
        }
    }

    private Name getNewName(String[] stringArray, HashSet hashSet) {
        if (hashSet == null) {
            return new Name(stringArray[0], stringArray[1]);
        }
        Name name = null;
        int n = 0;
        while (n < stringArray.length) {
            Name name2 = new Name(stringArray[n], stringArray[n + 1]);
            if (!hashSet.contains(name2)) {
                name = name2;
                break;
            }
            n += 2;
        }
        return name;
    }

    private void generateAttributes(IWalker iWalker, GenerateXMLResult generateXMLResult, boolean bl) {
        while (true) {
            String[] stringArray;
            String[] stringArray2 = iWalker.getRequiredAttributes();
            while (stringArray2.length > 0) {
                this.generateAttribute(new Name(stringArray2[0], stringArray2[1]), iWalker, generateXMLResult, bl);
                stringArray2 = iWalker.getRequiredAttributes();
            }
            if (!generateXMLResult.optionalAttributes || (stringArray = iWalker.getAttributes()).length <= 0) break;
            this.generateAttribute(new Name(stringArray[0], stringArray[1]), iWalker, generateXMLResult, bl);
        }
    }

    private void generateAttribute(Name name, IWalker iWalker, GenerateXMLResult generateXMLResult, boolean bl) {
        String[] stringArray;
        String string = name.localname;
        if (bl && name.namespace.length() > 0) {
            stringArray = this.getPrefix(name.namespace);
            this.pushPendingNs();
            if (stringArray.length() == 0) {
                stringArray = this.getAltPrefix(name.namespace);
                this.pushPendingNs();
            }
            string = String.valueOf(stringArray) + ':' + name.localname;
        }
        stringArray = iWalker.getAttributeValues(name.namespace, name.localname, name.localname);
        String[] stringArray2 = iWalker.getAttributeTypes(name.namespace, name.localname, name.localname);
        Name name2 = new Name(stringArray2[0], stringArray2[1]);
        String string2 = this.getValueForType(name2, stringArray);
        this.addAttribute(string, string2);
        if (!iWalker.acceptAttribute(name.namespace, name.localname, name.localname, string2, this.dummyContext)) {
            iWalker.acceptAttributeSkipValue(name.namespace, name.localname, name.localname);
        }
    }

    private String getValueForType(Name name, String[] stringArray) {
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        String string = null;
        if (name.namespace.equals("http://www.w3.org/2001/XMLSchema-datatypes") || name.namespace.equals("http://www.w3.org/2001/XMLSchema")) {
            string = name.localname.equals("ID") ? "id" + this.uniqueId++ : (name.localname.equals("IDREF") || name.localname.equals("IDREFS") ? "id0" : (String)SchemaConstants.TYPE_VALUES.get(name.localname));
        } else if (name.namespace.length() == 0) {
            if ("string".equals(name.localname)) {
                string = "string";
            } else if ("token".equals(name.localname)) {
                string = "token";
            }
        }
        if (string == null) {
            string = "String";
        }
        return string;
    }

    private String getPrefix(String string) {
        if (string.length() == 0) {
            return "";
        }
        String string2 = (String)this.nsToPrefix.get(string);
        if (string2 == null) {
            if (this.prefixCount++ == 0) {
                if (this.defaultPrefix != null) {
                    string2 = this.defaultPrefix;
                } else {
                    string2 = "ns";
                    ++this.prefixCount;
                }
            } else {
                while (!(string2 = "ns" + this.prefixCount++).equals(this.defaultPrefix)) {
                }
            }
            this.nsToPrefix.put(string, string2);
            this.nslist.add(new StringBuffer(string));
            this.pendingNs = string;
            this.pendingPrefix = string2;
        }
        return string2;
    }

    private String getAltPrefix(String string) {
        if (this.altNs == null) {
            this.pushPendingNs();
            this.altNs = new StringBuffer(string);
            this.nslist.add(this.altNs);
            this.pendingNs = string;
            this.pendingPrefix = "alt";
        }
        return "alt";
    }

    private void startElement(String string) {
        this.endStartTag();
        ++this.nest;
        this.indent();
        this.print('<');
        this.print(string);
        this.inElement = true;
        this.pushPendingNs();
    }

    private void pushPendingNs() {
        if (this.pendingNs != null) {
            String string = this.pendingPrefix;
            if (string.length() > 0) {
                this.addAttribute("xmlns:" + string, this.pendingNs);
            } else {
                this.addAttribute("xmlns", this.pendingNs);
            }
            this.pendingNs = null;
            this.pendingPrefix = null;
        }
    }

    private void endStartTag() {
        if (this.inElement) {
            this.println(">");
            this.inElement = false;
        }
    }

    private void addText(String string) {
        if (!this.inElement) {
            throw new IllegalStateException("text node not in element");
        }
        this.print(">");
        this.inElement = false;
        this.print(string);
        this.inText = true;
    }

    private void addComment(String string) {
        this.endStartTag();
        this.indent();
        this.print("<!--");
        this.print(string);
        this.println("-->");
    }

    private void endElement(String string) {
        if (this.inElement) {
            this.print('/');
            this.endStartTag();
        } else {
            if (!this.inText) {
                this.indent();
            }
            this.inText = false;
            this.print("</");
            this.print(string);
            this.println(">");
        }
        --this.nest;
    }

    private void addAttribute(String string, String string2) {
        if (!this.inElement) {
            throw new IllegalStateException("Attribute outside element");
        }
        int n = string.length() + string2.length() + 4;
        if (this.lineLength + n > this.lineMax) {
            this.println();
            this.indent();
            this.printTab();
        } else {
            this.print(' ');
        }
        this.print(string);
        this.print("=\"");
        this.print(string2);
        this.print('\"');
    }

    private void indent() {
        int n = 0;
        while (n < this.nest) {
            this.printTab();
            ++n;
        }
    }

    private void print(char c) {
        ++this.lineLength;
        this.writer.print(c);
    }

    private void print(String string) {
        this.lineLength += string.length();
        this.writer.print(string);
    }

    private void println(String string) {
        this.writer.println(string);
        this.lineLength = 0;
    }

    private void println() {
        this.writer.println();
        this.lineLength = 0;
    }

    private void printTab() {
        this.writer.print('\t');
        this.lineLength += this.tabCount;
    }
}

