/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.format;

import com.objfac.util.TabCalculator;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class XMLAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private String fTab;
    private static XMLAutoIndentStrategy fStrategy = new XMLAutoIndentStrategy();

    private XMLAutoIndentStrategy() {
    }

    public static XMLAutoIndentStrategy getStrategy() {
        return fStrategy;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && this.endsWithDelimiter(iDocument, documentCommand.text)) {
            this.rewriteIndentAfterNewLine(iDocument, documentCommand);
        }
    }

    private void rewriteIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        String[] stringArray = iDocument.getLegalLineDelimiters();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (documentCommand.text.equals(stringArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        n = documentCommand.offset;
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        TabCalculator tabCalculator = new TabCalculator(iPreferenceStore.getInt("com.objfac.xmleditor.tabwidth"), iPreferenceStore.getBoolean("com.objfac.xmleditor.spaces"));
        BaseEditor baseEditor = XMLEditor.findEditor(iDocument);
        if (baseEditor instanceof XMLEditor) {
            XMLTree xMLTree = ((XMLEditor)baseEditor).getXMLTree();
            XMLNode xMLNode = xMLTree.findExactNode(n);
            int n2 = XMLConstants.getIntType(xMLNode.getType());
            switch (n2) {
                case 11: {
                    String string = this.getParentLineStart(xMLNode, iDocument, iPreferenceStore);
                    if (string == null) break;
                    documentCommand.text = String.valueOf(documentCommand.text) + tabCalculator.tabIn(string);
                    break;
                }
                case 0: {
                    if (!iPreferenceStore.getBoolean("com.objfac.xmleditor.indentc")) break;
                    String string = this.getLineStart(xMLNode, iDocument);
                    documentCommand.text = String.valueOf(documentCommand.text) + tabCalculator.tabInWhole(string);
                    break;
                }
                default: {
                    if (documentCommand.offset == xMLNode.getOffset()) {
                        String string = this.getParentLineStart(xMLNode, iDocument, iPreferenceStore);
                        if (string == null) break;
                        if (n2 == 4) {
                            XMLNode xMLNode2 = xMLNode.parent;
                            if (xMLNode2 != null && xMLNode2.getOffset() + xMLNode2.getLength() == n) {
                                this.replace(iDocument, n, 0, String.valueOf(documentCommand.text) + tabCalculator.normalizeLeadingWhitespace(string));
                                documentCommand.text = String.valueOf(documentCommand.text) + tabCalculator.tabIn(string);
                                break;
                            }
                            documentCommand.text = String.valueOf(documentCommand.text) + tabCalculator.normalizeLeadingWhitespace(string);
                            break;
                        }
                        documentCommand.text = String.valueOf(documentCommand.text) + tabCalculator.tabIn(string);
                        break;
                    }
                    if (!iPreferenceStore.getBoolean("com.objfac.xmleditor.indente")) break;
                    String string = this.getLineStart(xMLNode, iDocument);
                    documentCommand.text = this.nodeStartsLine(xMLNode, iDocument) ? String.valueOf(documentCommand.text) + tabCalculator.tabIn(string) : String.valueOf(documentCommand.text) + tabCalculator.normalizeLeadingWhitespace(string);
                }
            }
        }
    }

    private void indentBeforeText(IDocument iDocument, DocumentCommand documentCommand) {
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
            int n = iRegion.getOffset() + iRegion.getLength();
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            int n2 = documentCommand.offset - iRegion.getOffset();
            if (documentCommand.offset == n && this.isWhitespaceOrEmpty(string, 0, n2)) {
                documentCommand.doit = false;
                String cfr_ignored_0 = String.valueOf(string) + documentCommand.text;
                new StringBuffer();
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return;
        }
    }

    private boolean isWhitespaceOrEmpty(String string, int n, int n2) {
        boolean bl = true;
        int n3 = n;
        int n4 = string.length();
        while (n3 < n4) {
            if (!XMLCharacter.isWhitespace((char)string.charAt(n3))) {
                bl = false;
                break;
            }
            ++n3;
        }
        return bl;
    }

    private void replace(IDocument iDocument, int n, int n2, String string) {
        try {
            iDocument.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {}
    }

    private String getParentLineStart(XMLNode xMLNode, IDocument iDocument, IPreferenceStore iPreferenceStore) {
        XMLNode xMLNode2 = xMLNode.getParent();
        if (xMLNode2 != null && iPreferenceStore.getBoolean("com.objfac.xmleditor.indentas")) {
            while (xMLNode2 != null && !this.nodeStartsLine(xMLNode2, iDocument)) {
                xMLNode2 = xMLNode2.getParent();
            }
            return this.getLineStart(xMLNode2, iDocument);
        }
        return null;
    }

    private boolean nodeStartsLine(XMLNode xMLNode, IDocument iDocument) {
        String string = this.getLineStart(xMLNode, iDocument);
        return string != null && string.length() == 0 || XMLCharacter.isWhitespace((String)string);
    }

    private String getLineStart(XMLNode xMLNode, IDocument iDocument) {
        try {
            int n = xMLNode.getOffset();
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            return iDocument.get(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean endsWithDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

