/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.notes;

import com.objfac.xml.XMLCharacter;

public class XLexer {
    private int end;
    private int pos;
    private char[] buf;
    private int token;
    private int begin;
    private boolean push;
    public static final int EOB = 0;
    public static final int DSC = 1;
    public static final int DOC = 2;
    public static final int ATT = 3;
    public static final int NAM = 4;
    public static final int BAD = 5;
    public static final int LBK = 6;
    public static final int RBK = 7;
    public static final int LPN = 8;
    public static final int RPN = 9;
    public static final int EQL = 10;
    public static final int NEQ = 11;
    public static final int AND = 12;
    public static final int ORR = 13;
    public static final int LIT = 14;
    public static final int NOT = 15;

    public void setBuffer(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.end = this.buf.length;
    }

    public int nextToken() {
        if (this.push) {
            this.push = false;
            return this.token;
        }
        this.begin = this.pos;
        while (this.pos < this.end && XMLCharacter.isWhitespace((char)this.buf[this.pos])) {
            ++this.pos;
        }
        if (this.pos >= this.end) {
            return 0;
        }
        this.token = 5;
        char c = this.buf[this.pos++];
        switch (c) {
            case '/': {
                if (this.pos < this.end && this.buf[this.pos] == '/') {
                    ++this.pos;
                    this.token = 1;
                }
                this.token = 2;
                break;
            }
            case '@': {
                this.token = 3;
                break;
            }
            case '[': {
                this.token = 6;
                break;
            }
            case ']': {
                this.token = 7;
                break;
            }
            case '(': {
                this.token = 8;
                break;
            }
            case ')': {
                this.token = 9;
                break;
            }
            case '=': {
                this.token = 10;
                break;
            }
            case '!': {
                if (this.pos >= this.end || this.buf[this.pos] != '=') break;
                ++this.pos;
                this.token = 11;
                break;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                while (this.pos < this.end && this.buf[this.pos] != c2) {
                    ++this.pos;
                }
                if (this.pos >= this.end) break;
                ++this.pos;
                this.token = 14;
                break;
            }
            default: {
                if (!XMLCharacter.isIDStart((char)c)) break;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                while (this.pos < this.end && XMLCharacter.isIDPart((char)this.buf[this.pos])) {
                    stringBuffer.append(this.buf[this.pos]);
                    ++this.pos;
                }
                String string = stringBuffer.toString();
                if ("and".equals(string)) {
                    return 12;
                }
                if ("or".equals(string)) {
                    return 13;
                }
                if ("not".equals(string)) {
                    return 15;
                }
                this.token = 4;
            }
        }
        return this.token;
    }

    public void pushToken() {
        this.push = true;
    }

    public String token() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.begin;
        while (n < this.pos) {
            stringBuffer.append(this.buf[n]);
            ++n;
        }
        return this.buf.toString();
    }

    public String unquote() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.begin + 1;
        int n2 = this.pos - 1;
        while (n < n2) {
            stringBuffer.append(this.buf[n]);
            ++n;
        }
        return this.buf.toString();
    }
}

