/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.notes;

import com.objfac.util.Local;
import com.objfac.xmleditor.notes.Atom;
import com.objfac.xmleditor.notes.Attr;
import com.objfac.xmleditor.notes.Desc;
import com.objfac.xmleditor.notes.Elem;
import com.objfac.xmleditor.notes.Memo;
import com.objfac.xmleditor.notes.NamespaceResolver;
import com.objfac.xmleditor.notes.Test;
import com.objfac.xmleditor.notes.TestAnd;
import com.objfac.xmleditor.notes.TestAttrExists;
import com.objfac.xmleditor.notes.TestAttrValue;
import com.objfac.xmleditor.notes.TestNot;
import com.objfac.xmleditor.notes.TestOr;
import com.objfac.xmleditor.notes.XLexer;
import com.objfac.xmleditor.notes.XParseException;

public class XParser {
    private NamespaceResolver resolver;
    private Memo memo;
    private XLexer lex;
    private String[] name = new String[2];

    public XParser(Memo memo) {
        this.memo = memo;
    }

    public Atom parse(String string, NamespaceResolver namespaceResolver) throws XParseException {
        this.lex.setBuffer(string.toCharArray());
        this.resolver = namespaceResolver;
        return this.parseLocator();
    }

    public int peek() {
        int n = this.lex.nextToken();
        this.lex.pushToken();
        return n;
    }

    public int next() {
        return this.lex.nextToken();
    }

    public void push() {
        this.lex.pushToken();
    }

    private Atom parseLocator() throws XParseException {
        Atom atom;
        Atom atom2;
        int n = this.next();
        if (n == 2) {
            atom = atom2 = this.memo.doc();
        } else if (n == 1) {
            atom = this.memo.doc();
            atom2 = new Desc();
            atom.addChild(atom2);
        } else {
            this.push();
            atom = atom2 = this.parseStep();
        }
        while ((n = this.lex.nextToken()) != 0) {
            Atom atom3 = this.parseStep();
            atom2.addChild(atom3);
            atom2 = atom3;
        }
        return atom;
    }

    private Atom parseStep() throws XParseException {
        Atom atom = null;
        String[] cfr_ignored_0 = new String[2];
        int n = this.next();
        if (n == 3) {
            if (this.next() != 4) {
                return this.expect(Local.getString((String)"attribute name"));
            }
            atom = new Attr(this.lex.token(), this.resolver);
        } else if (n == 4) {
            atom = new Elem(this.lex.token(), this.resolver);
        } else {
            this.expect(Local.getString((String)"element or attribute name"));
        }
        if (this.peek() == 6) {
            Test test = this.parseTest();
            if (atom.getKind() == 1) {
                ((Attr)atom).test = test;
            } else {
                ((Elem)atom).test = test;
            }
        }
        return atom;
    }

    private Test parseTest() throws XParseException {
        this.next();
        Test test = this.parseTestExpr();
        if (this.next() != 93) {
            return this.expectTest("]");
        }
        return test;
    }

    private Test parseTestExpr() throws XParseException {
        Test test = this.parseTestOr();
        while (this.next() == 12) {
            Test test2 = this.parseTestOr();
            TestAnd testAnd = new TestAnd(test, test2);
            test = testAnd;
        }
        this.push();
        return test;
    }

    private Test parseTestOr() throws XParseException {
        Test test = this.parseTestPrimary();
        while (this.next() == 13) {
            Test test2 = this.parseTestPrimary();
            TestOr testOr = new TestOr(test, test2);
            test = testOr;
        }
        this.push();
        return test;
    }

    private Test parseTestPrimary() throws XParseException {
        Test test;
        int n = this.next();
        if (n == 8) {
            test = this.parseTestExpr();
            if (this.next() != 41) {
                return this.expectTest(")");
            }
        } else if (n == 3) {
            if (this.next() != 4) {
                return this.expectTest("attribute name");
            }
            String string = this.lex.token();
            n = this.next();
            boolean bl = n == 11;
            if (bl || n == 10) {
                if (this.next() != 14) {
                    return this.expectTest("literal");
                }
                TestAttrValue testAttrValue = new TestAttrValue(string, this.resolver, this.lex.unquote());
                testAttrValue.ne = bl;
                test = testAttrValue;
            } else {
                this.push();
                test = new TestAttrExists(string, this.resolver);
            }
            test = new TestAttrExists(this.lex.token(), this.resolver);
        } else if (n == 15) {
            if (this.next() != 8) {
                return this.expectTest("( after not");
            }
            Test test2 = this.parseTestPrimary();
            if (this.next() != 9) {
                return this.expectTest(")");
            }
            test = new TestNot(test2);
        } else {
            return this.expectTest(Local.getString((String)"), @ or not in test"));
        }
        return test;
    }

    private Atom expect(String string) throws XParseException {
        throw new XParseException(Local.format((String)"Expecting {1} found \"{1}\"", (Object)string, (Object)this.lex.token()));
    }

    private Test expectTest(String string) throws XParseException {
        throw new XParseException(Local.format((String)"Expecting {1} found \"{1}\"", (Object)string, (Object)this.lex.token()));
    }
}

