/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition.scanner;

import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.scanner.ContextPosition;
import com.objfac.xmleditor.partition.scanner.IContextualScanner;
import com.objfac.xmleditor.partition.scanner.Partitioner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.Assert;

public class ContextualPartitioner
extends Partitioner {
    public static final String CONTEXT_CATEGORY = "__context_category";
    protected ContextPositionUpdater fContextPositionUpdater = new ContextPositionUpdater();
    protected ContextPosition fLastContextPosition;
    Position[] fContextPositions;
    private static final ContextPosition DEFAULT_CONTEXT_POSITION = new ContextPosition(-1, 0, "__default_context");

    public ContextualPartitioner(IContextualScanner iContextualScanner, String[] stringArray) {
        super(iContextualScanner, stringArray);
    }

    public void connect(IDocument iDocument) {
        this.fDocument.addPositionCategory(CONTEXT_CATEGORY);
        super.connect(iDocument);
    }

    protected void initialize() {
        IContextualScanner iContextualScanner = (IContextualScanner)this.fScanner;
        iContextualScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            Object object = "__default_context";
            IToken iToken = iContextualScanner.nextToken(object);
            Object object2 = iContextualScanner.getContextObject();
            int n = this.fDocument.getLength();
            while (!iToken.isEOF()) {
                String string = this.getTokenContentType(iToken);
                if (this.isSupportedContentType(string)) {
                    TypedPosition typedPosition = new TypedPosition(iContextualScanner.getTokenOffset(), iContextualScanner.getTokenLength(), string);
                    this.fDocument.addPosition("__content_types_category", (Position)typedPosition);
                    if (!object2.equals(object)) {
                        int n2 = iContextualScanner.getTokenOffset();
                        int n3 = n - n2;
                        ContextPosition contextPosition = new ContextPosition(n2, n3, object2);
                        this.fDocument.addPosition(CONTEXT_CATEGORY, (Position)contextPosition);
                        object = object2;
                    }
                }
                iToken = iContextualScanner.nextToken(object);
                object2 = iContextualScanner.getContextObject();
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
    }

    public void disconnect() {
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(CONTEXT_CATEGORY));
        try {
            this.fDocument.removePositionCategory(CONTEXT_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        super.disconnect();
    }

    protected void aboutToParse(DocumentEvent documentEvent, int n) {
        try {
            this.fContextPositionUpdater.update(documentEvent);
            this.fContextPositions = documentEvent.getDocument().getPositions(CONTEXT_CATEGORY);
            this.findContextPosition(this.fContextPositions, n);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
    }

    protected IToken nextToken() {
        return ((IContextualScanner)this.fScanner).nextToken((Object)this.fLastContextPosition);
    }

    protected void validToken(IToken iToken) {
        IContextualScanner iContextualScanner = (IContextualScanner)this.fScanner;
        this.fLastContextPosition = this.addContextPosition(this.fDocument, this.fContextPositions, this.fLastContextPosition, iContextualScanner.getTokenOffset(), iContextualScanner.getTokenLength(), iContextualScanner.getContextObject());
    }

    private ContextPosition findContextPosition(Position[] positionArray, int n) {
        int n2 = this.findPosition(positionArray, n);
        if (n2 >= 0) {
            return (ContextPosition)positionArray[n2];
        }
        return DEFAULT_CONTEXT_POSITION;
    }

    private int findPosition(Position[] positionArray, int n) {
        int n2 = 0;
        while (n2 < positionArray.length) {
            Position position = positionArray[n2];
            if (position.getOffset() >= n) {
                return n2 - 1;
            }
            ++n2;
        }
        return -1;
    }

    private ContextPosition addContextPosition(IDocument iDocument, Position[] positionArray, ContextPosition contextPosition, int n, int n2, Object object) {
        Object object2 = contextPosition.getContext();
        int n3 = contextPosition.getOffset();
        if (object.equals(object2) && n == n3) {
            return contextPosition;
        }
        iDocument.addPositionCategory(CONTEXT_CATEGORY);
        ContextPosition contextPosition2 = contextPosition;
        try {
            int n4 = this.findPosition(positionArray, n);
            int n5 = this.findPosition(positionArray, n + n2);
            int n6 = n4;
            while (n6 <= n5) {
                if (n6 >= 0) {
                    Position position = positionArray[n6];
                    int n7 = position.getOffset();
                    if (!position.isDeleted() && n7 >= n && n7 < n + n2) {
                        iDocument.removePosition(CONTEXT_CATEGORY, position);
                    }
                }
                ++n6;
            }
            n6 = iDocument.getLength() - n;
            contextPosition2 = new ContextPosition(n, n6, object);
            iDocument.addPosition(CONTEXT_CATEGORY, (Position)contextPosition2);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        return contextPosition2;
    }

    protected static class ContextPositionUpdater
    implements IPositionUpdater {
        protected ContextPositionUpdater() {
        }

        public void update(DocumentEvent documentEvent) {
            try {
                Position[] positionArray = documentEvent.getDocument().getPositions(ContextualPartitioner.CONTEXT_CATEGORY);
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                int n3 = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
                IDocument iDocument = documentEvent.getDocument();
                int n4 = iDocument.getLength();
                int n5 = 0;
                while (n5 < positionArray.length) {
                    Position position = positionArray[n5];
                    int n6 = position.offset;
                    if (n6 >= n && n6 < n + n2) {
                        iDocument.removePosition(ContextualPartitioner.CONTEXT_CATEGORY, position);
                    } else {
                        if (n6 >= n + n2) {
                            position.offset += n3 - n2;
                        }
                        position.length = n4 - position.offset;
                    }
                    ++n5;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                XMLPlugin.log(badPositionCategoryException);
            }
        }
    }
}

