/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.IAbstractDocument;
import com.objfac.xmleditor.search.IResultCollector;
import com.objfac.xmleditor.search.SearchUtils;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import com.objfac.xmleditor.xpath.DocumentFinder;
import com.objfac.xmleditor.xpath.DocumentNavigator;
import com.objfac.xmleditor.xpath.XMLAttr;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class XPathSearchMatch {
    private int matchCount;
    private ISearchResultView view;
    private String xpathExpr;
    private DocumentNavigator navigator = new DocumentNavigator(new DocumentFinder());
    private int linebeg;
    private IEditorPart[] editors;

    public XPathSearchMatch(ISearchResultView iSearchResultView, String string) {
        this.view = iSearchResultView;
        this.xpathExpr = string;
    }

    public void match(IFile iFile, MultiStatus multiStatus, IResultCollector iResultCollector) throws CoreException {
        XMLTree xMLTree = this.navigator.setDocument(iFile, multiStatus);
        if (xMLTree == null) {
            return;
        }
        XPath xPath = null;
        try {
            xPath = this.navigator.parseXPath(this.xpathExpr);
        }
        catch (SAXPathException sAXPathException) {
            sAXPathException.printStackTrace();
        }
        if (xPath == null) {
            return;
        }
        List list = null;
        try {
            list = xPath.selectNodes((Object)xMLTree);
        }
        catch (JaxenException jaxenException) {
            jaxenException.printStackTrace();
        }
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            int n3;
            IRegion iRegion;
            IAbstractDocument iAbstractDocument;
            Object object;
            String string;
            Object object2;
            Object e = iterator.next();
            if (e instanceof XMLTree) {
                object2 = xMLTree.getPositions();
                string = "";
                if (object2 != null && ((Object)object2).length > 0) {
                    object = (XMLNode)object2[0];
                    iAbstractDocument = ((XMLNode)object).getDocument();
                    iRegion = this.getLineInformation(iAbstractDocument, 0, multiStatus);
                    if (iRegion == null) continue;
                    string = this.get(iAbstractDocument, iRegion.getOffset(), iRegion.getLength(), multiStatus).trim();
                }
                n3 = 0;
                n2 = 0;
                n = 0;
            } else if (e instanceof XMLNode) {
                object2 = (XMLNode)e;
                iAbstractDocument = ((XMLNode)object2).getDocument();
                iRegion = this.getLineInformation(iAbstractDocument, (object = ((XMLNode)object2).getHighlightRegion()).getOffset(), multiStatus);
                if (iRegion == null) continue;
                string = this.get(iAbstractDocument, object.getOffset(), object.getLength(), multiStatus).trim();
                n = object.getOffset();
                n2 = object.getLength();
                object2.getType();
                n3 = this.getLineOfOffset(iAbstractDocument, n, multiStatus);
            } else {
                if (!(e instanceof XMLAttr)) continue;
                object2 = (XMLAttr)e;
                object = ((XMLAttr)object2).getParent();
                iAbstractDocument = ((XMLNode)object).getDocument();
                n = ((XMLAttr)object2).getOffset();
                n2 = ((XMLAttr)object2).getQName().length();
                iRegion = this.getLineInformation(iAbstractDocument, n, multiStatus);
                if (iRegion == null) continue;
                string = this.get(iAbstractDocument, iRegion.getOffset(), iRegion.getLength(), multiStatus).trim();
                n3 = this.getLineOfOffset(iAbstractDocument, n, multiStatus);
            }
            iResultCollector.accept((IResource)iFile, string, n, n2, n3);
        }
    }

    private int getLineOfOffset(IAbstractDocument iAbstractDocument, int n, MultiStatus multiStatus) {
        try {
            return iAbstractDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            multiStatus.add((IStatus)new Status(4, XMLPlugin.getPluginId(), 0, Local.getString((String)"Internal error getLineOfOffset()"), (Throwable)badLocationException));
            return 0;
        }
    }

    private IRegion getLineInformation(IAbstractDocument iAbstractDocument, int n, MultiStatus multiStatus) {
        try {
            return iAbstractDocument.getLineInformationOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            multiStatus.add((IStatus)new Status(4, XMLPlugin.getPluginId(), 0, Local.getString((String)"Internal error getLineInformationOfOffset()"), (Throwable)badLocationException));
            return null;
        }
    }

    private String get(IAbstractDocument iAbstractDocument, int n, int n2, MultiStatus multiStatus) {
        try {
            return iAbstractDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            multiStatus.add((IStatus)new Status(4, XMLPlugin.getPluginId(), 0, Local.getString((String)"Internal error get()"), (Throwable)badLocationException));
            return "";
        }
    }

    private boolean canBeXML(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && XMLCharacter.isWhitespace((char)cArray[n2])) {
            ++n2;
        }
        return n2 < n && cArray[n2] == '<';
    }

    private ITextEditor findEditorFor(IFile iFile) {
        if (this.editors == null) {
            this.editors = SearchUtils.getActiveEditors();
        }
        int n = 0;
        IPath iPath = iFile.getLocation();
        while (n < this.editors.length) {
            IPath iPath2;
            IEditorPart iEditorPart = this.editors[n];
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IPathEditorInput && iEditorPart instanceof ITextEditor && (iPath2 = ((IPathEditorInput)iEditorInput).getPath()).equals((Object)iPath)) {
                return (ITextEditor)iEditorPart;
            }
            ++n;
        }
        return null;
    }
}

