/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.util.Local;
import java.util.LinkedList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ErrorCatcher
implements ErrorListener {
    private LinkedList list;
    private MultiStatus multi;
    private String summary;
    private int maxSeverity = 0;

    public int getSeverity() {
        return this.maxSeverity;
    }

    public String getSummaryMessage() {
        this.summary = Local.getString((String)"No errors or warnings");
        this.getStatus();
        return this.summary;
    }

    public MultiStatus getStatus() {
        if (this.list != null && this.multi == null) {
            int n = this.list.size();
            String string = Local.getString((String)"See details");
            if (n == 1) {
                switch (this.maxSeverity) {
                    case 4: {
                        this.summary = Local.getString((String)"Transform error");
                        break;
                    }
                    case 2: {
                        this.summary = Local.getString((String)"Transform warning");
                    }
                }
            } else {
                switch (this.maxSeverity) {
                    case 4: {
                        this.summary = Local.getString((String)"Transform errors");
                        break;
                    }
                    case 2: {
                        this.summary = Local.getString((String)"Transform warnings");
                    }
                }
            }
            Status[] statusArray = this.list.toArray(new Status[this.list.size()]);
            this.multi = new MultiStatus("com.objfac.xmleditor", 0, (IStatus[])statusArray, string, null);
        }
        return this.multi;
    }

    public void addStatus(int n, String string, Throwable throwable) {
        if (this.maxSeverity < n) {
            this.maxSeverity = n;
        }
        Status status = new Status(n, "com.objfac.xmleditor", 0, string, throwable);
        if (this.list == null) {
            this.list = new LinkedList();
        }
        this.list.add(status);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        this.addStatus(4, transformerException.getMessageAndLocation(), transformerException.getException());
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.addStatus(4, transformerException.getMessageAndLocation(), transformerException.getException());
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        this.addStatus(2, transformerException.getMessageAndLocation(), transformerException.getException());
    }
}

