/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.util.Local;
import com.objfac.walker.IWalker;
import com.objfac.xml.DefaultLocatorInfo;
import com.objfac.xml.ErrorCallback;
import com.objfac.xml.LocatorInfo;
import com.objfac.xml.schema.impl.SchemaError;
import com.objfac.xmleditor.validate.ErrorTuple;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ErrorCollector
implements ErrorCallback {
    private LinkedList fErrors = new LinkedList();
    private int fMaxSeverity = -1;
    private static final int[] fSchemaToCallback = new int[]{1, 2, 3};

    public void error(int n, String string, LocatorInfo locatorInfo) {
        this.fErrors.add(new ErrorTuple(n, string, locatorInfo));
        if (this.fMaxSeverity < n) {
            this.fMaxSeverity = n;
        }
    }

    public LinkedList getErrors() {
        return this.fErrors;
    }

    public int getMaxSeverity() {
        return this.fMaxSeverity;
    }

    public boolean hasSchemaErrors(IWalker iWalker, String string) {
        List list = iWalker.getErrors();
        if (list != null && list.size() > 0) {
            DefaultLocatorInfo defaultLocatorInfo = new DefaultLocatorInfo(null, string, 0, 0);
            Iterator iterator = list.iterator();
            int n = -1;
            String string2 = null;
            while (iterator.hasNext()) {
                SchemaError schemaError = (SchemaError)iterator.next();
                int n2 = schemaError.getSeverity();
                int n3 = 0;
                if (n2 >= 0 && n2 < fSchemaToCallback.length) {
                    n3 = fSchemaToCallback[n2];
                }
                if (n >= n3) continue;
                n = n3;
                string2 = schemaError.getMessage();
            }
            this.error(n, Local.format((String)"Error in schema: {0}", string2), (LocatorInfo)defaultLocatorInfo);
            return true;
        }
        return false;
    }

    public void addWalkerErrors(IWalker iWalker, String string) {
        List list = iWalker.getErrors();
        if (list != null && list.size() > 0) {
            DefaultLocatorInfo defaultLocatorInfo = new DefaultLocatorInfo(0, 0);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SchemaError schemaError = (SchemaError)iterator.next();
                int n = schemaError.getSeverity();
                int n2 = 0;
                if (n >= 0 && n < fSchemaToCallback.length) {
                    n2 = fSchemaToCallback[n];
                }
                defaultLocatorInfo.setInfo(null, string, schemaError.getLineNumber(), schemaError.getLineOffset());
                this.error(n2, schemaError.getMessage(), (LocatorInfo)defaultLocatorInfo);
            }
        }
    }
}

