/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.walker.IWalker;
import com.objfac.xml.ErrorCallback;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.dtd.DTDDecl;
import com.objfac.xmleditor.validate.DTDDeclReader;
import com.objfac.xmleditor.validate.IFlattener;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.io.StringReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class Flattener {
    private static final String XERCES_DECL_READER = "com.objfac.xmleditor.xerces.XercesDTDDeclReader";
    private static final String JING_FLATTENER = "com.objfac.xmleditor.xerces.JingFlattener";

    public IWalker flatten(IWalker iWalker) {
        IFlattener iFlattener = (IFlattener)XMLPlugin.getDefault().loadInternalClass(JING_FLATTENER);
        return iFlattener.flatten(iWalker);
    }

    public DTDDecl parse(boolean bl, XMLEditor xMLEditor, ErrorCallback errorCallback) {
        String string;
        Object object;
        StringReader stringReader = null;
        String string2 = null;
        Object object2 = null;
        String string3 = xMLEditor.getEncoding();
        if (xMLEditor.getEditorKind() == 1) {
            object = xMLEditor.getUrl();
            String string4 = DTDDecl.getFakeDocument("", (String)object);
            stringReader = new StringReader(string4);
            string = null;
            string2 = null;
            object2 = object;
        } else {
            object = xMLEditor.getDTDParams();
            string = xMLEditor.getUrl();
            if (((DTDParams)object).tdtd) {
                XMLTree xMLTree = xMLEditor.getXMLTree();
                XMLNode xMLNode = xMLTree.getRoot();
                XMLNode xMLNode2 = xMLTree.getDoctype();
                string2 = ((DTDParams)object).pub;
                object2 = ((DTDParams)object).sys;
                if (xMLNode2 != null) {
                    int n;
                    int n2;
                    String string5;
                    String string6 = this.getRootName(xMLNode2, xMLNode);
                    if (string6 != null && (string5 = this.replaceDoctype(xMLEditor, string6, string2, (String)object2, n2 = xMLNode2.getOffset(), n = n2 + xMLNode2.getLength())) != null) {
                        stringReader = new StringReader(string5);
                    }
                } else if (xMLNode != null) {
                    int n = xMLNode.getOffset();
                    String string7 = xMLNode.getQName();
                    String string8 = this.replaceDoctype(xMLEditor, string7, string2, (String)object2, n, n);
                    if (string8 != null) {
                        stringReader = new StringReader(string8);
                    }
                }
            } else if (((DTDParams)object).epub != null || ((DTDParams)object).esys != null || ((DTDParams)object).beg != ((DTDParams)object).end) {
                string2 = ((DTDParams)object).epub;
                object2 = ((DTDParams)object).esys;
                IDocument iDocument = xMLEditor.getDocument();
                stringReader = new StringReader(iDocument.get());
            }
        }
        if (stringReader == null) {
            return new DTDDecl();
        }
        object = (DTDDeclReader)XMLPlugin.getDefault().loadInternalClass(XERCES_DECL_READER);
        return object.parse(bl, stringReader, string, string2, (String)object2, errorCallback, string3);
    }

    private String replaceDoctype(XMLEditor xMLEditor, String string, String string2, String string3, int n, int n2) {
        try {
            IDocument iDocument = xMLEditor.getDocument();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(iDocument.get(0, n));
            String string4 = DTDDecl.getFakeDoctype(string, string2, string3);
            stringBuffer.append(string4);
            stringBuffer.append(iDocument.get(n2, iDocument.getLength() - n2));
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return null;
        }
    }

    private String getRootName(XMLNode xMLNode, XMLNode xMLNode2) {
        String string = null;
        if (xMLNode2 != null) {
            string = xMLNode2.getQName();
        } else if (xMLNode != null) {
            String string2 = xMLNode.getContents();
            int n = "<!DOCTYPE ".length();
            int n2 = string2.length();
            int n3 = n;
            while (n < n2 && XMLCharacter.isIDPart((char)string2.charAt(n))) {
                ++n;
            }
            if (n > n3) {
                string = string2.substring(n3, n - n3);
            }
        }
        return string;
    }
}

