/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.io.DocumentCache;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.PluginFactoryExtension;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.ErrorCatcher;
import com.objfac.xmleditor.validate.ITransformResult;
import com.objfac.xmleditor.validate.TransformArguments;
import com.objfac.xmleditor.validate.TransformResult;
import com.objfac.xmleditor.validate.TransformerShell;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.InputSource;

public class JavaxTransformerShell
implements TransformerShell {
    public ITransformResult[] transform(XMLEditor xMLEditor, TransformArguments transformArguments, ResourceWatcherCallback resourceWatcherCallback) {
        String string;
        String string2;
        String string3 = xMLEditor.getUrl();
        ITransformResult[] iTransformResultArray = null;
        ErrorCatcher errorCatcher = new ErrorCatcher();
        if (xMLEditor.getEditorKind() == 6) {
            string2 = string3;
            string = transformArguments.inputUri;
        } else {
            string2 = transformArguments.inputUri;
            string = string3;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            Object object;
            transformerFactory.setErrorListener(errorCatcher);
            Resolver resolver = new Resolver(resourceWatcherCallback);
            transformerFactory.setURIResolver(resolver);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            StreamResult streamResult = new StreamResult(charArrayWriter);
            try {
                object = resolver.resolve(string2, string3);
                Transformer transformer = transformerFactory.newTransformer((Source)object);
                this.setParams(transformer, transformArguments);
                if (errorCatcher.getSeverity() <= 2) {
                    transformer.setErrorListener(errorCatcher);
                    transformer.setURIResolver(resolver);
                    Source source = resolver.resolve(string, string3);
                    transformer.transform(source, streamResult);
                }
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                errorCatcher.addStatus(4, transformerConfigurationException.getMessageAndLocation(), null);
            }
            catch (TransformerException transformerException) {
                errorCatcher.addStatus(4, transformerException.getMessageAndLocation(), null);
            }
            object = charArrayWriter.toCharArray();
            if (errorCatcher.getSeverity() == 0 || object != null && ((Object)object).length > 0) {
                iTransformResultArray = new ITransformResult[]{new TransformResult((char[])object, streamResult.getSystemId())};
            }
        } else {
            errorCatcher.addStatus(4, Local.getString((String)"javax TransformerFactory does not support SAXSource/StreamResult"), null);
        }
        if (errorCatcher.getSeverity() > 0) {
            ErrorDialog.openError((Shell)xMLEditor.getViewer().getTextWidget().getShell(), (String)Local.getString((String)"Transform problems"), (String)errorCatcher.getSummaryMessage(), (IStatus)errorCatcher.getStatus());
        }
        return iTransformResultArray;
    }

    private void setParams(Transformer transformer, TransformArguments transformArguments) {
        ArrayList arrayList = transformArguments.params;
        if (arrayList != null) {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                TransformArguments.Param param = (TransformArguments.Param)arrayList.get(n);
                transformer.setParameter(param.name, param.value);
                ++n;
            }
        }
    }

    private static class Resolver
    implements URIResolver {
        private ResourceWatcherCallback rwCallback;

        public Resolver(ResourceWatcherCallback resourceWatcherCallback) {
            this.rwCallback = resourceWatcherCallback;
        }

        public Source resolve(String string, String string2) throws TransformerException {
            String string3 = string2 != null ? Misc.getAbsUrl((String)string2, (String)string) : string;
            try {
                Reader reader = this.internalResolve(null, string3);
                if (reader != null) {
                    if (this.rwCallback != null) {
                        this.rwCallback.watchResource(string3);
                    }
                    InputSource inputSource = new InputSource(reader);
                    inputSource.setSystemId(string3);
                    SAXSource sAXSource = new SAXSource(inputSource);
                    return sAXSource;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return null;
        }

        protected Reader internalResolve(String string, String string2) throws IOException {
            DocumentCache.getCache();
            StringBuffer stringBuffer = new StringBuffer();
            IDocumentReaderFactory iDocumentReaderFactory = PluginFactoryExtension.getFactory();
            ExternalEntity externalEntity = new ExternalEntity(null, string, string2, iDocumentReaderFactory);
            try {
                externalEntity.getContents(stringBuffer);
                return new StringReader(stringBuffer.toString());
            }
            catch (IOException iOException) {
                XMLPlugin.log(iOException);
                return null;
            }
        }
    }
}

