/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xmltree;

import com.objfac.xmleditor.xmltree.XMLNode;
import java.util.LinkedList;
import java.util.List;

public class XMLNodeTree {
    protected XMLNode fHead;

    public XMLNode getHead() {
        return this.fHead;
    }

    protected void setHead(XMLNode xMLNode) {
        this.fHead = xMLNode;
    }

    public List getListOfType(String string) {
        LinkedList linkedList = new LinkedList();
        XMLNode xMLNode = this.getHead();
        if (xMLNode != null) {
            TypeVisitor typeVisitor = new TypeVisitor(linkedList, string);
            this.visit(typeVisitor);
        }
        return linkedList;
    }

    public void visit(Visitor visitor) {
        XMLNode xMLNode = this.getHead();
        if (xMLNode != null) {
            this.visit(xMLNode, visitor);
        }
    }

    public Object visit(FindVisitor findVisitor) {
        XMLNode xMLNode = this.getHead();
        return xMLNode == null ? null : this.visit(xMLNode, findVisitor);
    }

    private Object visit(XMLNode xMLNode, FindVisitor findVisitor) {
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            Object object = findVisitor.visit(xMLNode2);
            if (object != null) {
                return object;
            }
            if (xMLNode2.getFirstChild() != null) {
                return this.visit(xMLNode2.getFirstChild(), findVisitor);
            }
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return null;
    }

    private void visit(XMLNode xMLNode, Visitor visitor) {
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            visitor.visit(xMLNode2);
            if (xMLNode2.getFirstChild() != null) {
                this.visit(xMLNode2.getFirstChild(), visitor);
            }
            xMLNode2 = xMLNode2.getNextSibling();
        }
    }

    public static interface Visitor {
        public void visit(XMLNode var1);
    }

    public static interface FindVisitor {
        public Object visit(XMLNode var1);
    }

    private static class TypeVisitor
    implements Visitor {
        private String type;
        private List list;

        public TypeVisitor(List list, String string) {
            this.list = list;
            this.type = string;
        }

        public void visit(XMLNode xMLNode) {
            if (xMLNode.getType() == this.type) {
                this.list.add(xMLNode);
            }
        }
    }
}

