/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xmltree;

import com.objfac.util.Misc;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.DocumentWrapper;
import com.objfac.xmleditor.partition.FilterIterator;
import com.objfac.xmleditor.partition.IAbstractDocument;
import com.objfac.xmleditor.partition.XMLPartitioner;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLNodeTree;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class XMLTree
extends XMLNodeTree
implements IOutlineTree {
    protected Position[] fPositions;
    protected boolean fIncremental = true;
    protected int fCommonIndex;
    protected static boolean fXMLRules = true;
    protected static final LinkedList EMPTY = new LinkedList();
    protected LinkedList fChanges = EMPTY;
    protected DocumentWrapper fDocument = new DocumentWrapper(null);
    protected Position fTmpPosition = new Position(0, 0);
    protected final Position fFindPosition = new Position(0);
    protected boolean fModified;
    protected boolean fDeleted;
    protected boolean fAdded;

    public void updateTree(IDocument iDocument, Position[] positionArray, int n) {
        this.fDocument.setDocument(iDocument);
        this.updateTree(this.fDocument, positionArray, n);
    }

    public void updateTree(IAbstractDocument iAbstractDocument, Position[] positionArray, int n) {
        this.fChanges = EMPTY;
        if (this.fHead == null) {
            this.buildTree(iAbstractDocument, positionArray);
        } else {
            this.repairTree(iAbstractDocument, positionArray, n);
        }
        this.fPositions = positionArray;
    }

    public boolean isIncremental() {
        return this.fIncremental;
    }

    public XMLNode getIncrementalChange(FilterIterator filterIterator) {
        XMLNode xMLNode = null;
        if (this.fPositions != null) {
            int n = this.fCommonIndex;
            n = Math.min(n, this.fPositions.length - 1);
            while (n >= 0 && !filterIterator.pass((XMLNode)this.fPositions[n])) {
                --n;
            }
            if (n >= 0) {
                xMLNode = (XMLNode)this.fPositions[n];
            }
        }
        return xMLNode;
    }

    public List getIncrementalChanges(FilterIterator filterIterator) {
        LinkedList<XMLNode> linkedList = new LinkedList<XMLNode>();
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            XMLNode xMLNode = (XMLNode)iterator.next();
            if (!filterIterator.pass(xMLNode)) continue;
            linkedList.add(xMLNode);
        }
        return linkedList;
    }

    public int getCommonIndex() {
        return this.fCommonIndex;
    }

    public XMLNode findFilteredNode(FilterIterator filterIterator, int n) {
        XMLNode xMLNode = null;
        if (this.fPositions != null) {
            this.fTmpPosition.setOffset(n);
            int n2 = this.findRange(this.fPositions, n);
            n2 = Math.min(n2, this.fPositions.length - 1);
            while (n2 >= 0 && !filterIterator.pass((XMLNode)this.fPositions[n2])) {
                --n2;
            }
            if (n2 >= 0) {
                xMLNode = (XMLNode)this.fPositions[n2];
            }
        }
        return xMLNode;
    }

    public XMLNode findNode(int n) {
        XMLNode xMLNode = null;
        if (this.fPositions != null) {
            int n2 = this.findRange(this.fPositions, n);
            if ((n2 = Math.min(n2, this.fPositions.length - 1)) >= 0) {
                xMLNode = (XMLNode)this.fPositions[n2];
            } else if (this.fPositions.length > 0) {
                xMLNode = (XMLNode)this.fPositions[0];
            }
        }
        return xMLNode;
    }

    public XMLNode findExactNode(int n) {
        int n2;
        XMLNode xMLNode = null;
        if (this.fPositions != null && (n2 = this.findExactRange(this.fPositions, n)) >= 0) {
            xMLNode = (XMLNode)this.fPositions[n2];
        }
        return xMLNode;
    }

    public int findNodeIndex(int n) {
        int n2 = -1;
        if (this.fPositions != null) {
            n2 = this.findRange(this.fPositions, n);
            if ((n2 = Math.min(n2, this.fPositions.length - 1)) < 0 && this.fPositions.length > 0) {
                n2 = 0;
            }
        }
        return n2;
    }

    protected int findRange(Position[] positionArray, int n) {
        this.fFindPosition.setOffset(n);
        int n2 = Misc.findRange((Object[])positionArray, (Object)this.fFindPosition, (Comparator)XMLPartitioner.POSITION_COMPARATOR);
        if (n2 > 0 && n2 < positionArray.length && positionArray[n2].getOffset() == n && ((XMLNode)positionArray[n2]).getType() != "com.objfac.xmltext") {
            --n2;
        }
        return n2;
    }

    protected int findExactRange(Position[] positionArray, int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < positionArray.length) {
            Position position = positionArray[n3];
            if (n < position.getOffset() + position.getLength()) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1 && positionArray.length > 0) {
            n2 = positionArray.length - 1;
        }
        return n2;
    }

    public XMLNode[] findNodes(int n) {
        this.fFindPosition.setOffset(n);
        int n2 = Misc.findRange((Object[])this.fPositions, (Object)this.fFindPosition, (Comparator)XMLPartitioner.POSITION_COMPARATOR);
        if (n2 < 0 || n2 == this.fPositions.length) {
            return new XMLNode[0];
        }
        if (this.fPositions[n2].getOffset() == n && n2 > 0) {
            return new XMLNode[]{(XMLNode)this.fPositions[n2 - 1], (XMLNode)this.fPositions[n2]};
        }
        return new XMLNode[]{(XMLNode)this.fPositions[n2]};
    }

    public Position[] getPositions() {
        return this.fPositions;
    }

    protected void repairTree(IAbstractDocument iAbstractDocument, Position[] positionArray, int n) {
        XMLNode xMLNode;
        String string;
        int n2;
        this.fIncremental = true;
        int n3 = this.findRange(positionArray, n);
        n3 = Math.min(n3, Math.min(this.fPositions.length - 1, positionArray.length - 1));
        while (n3 >= 0 && positionArray[n3] != this.fPositions[n3]) {
            --n3;
        }
        this.fCommonIndex = n3;
        if (n3 < 0) {
            XMLNode xMLNode2 = this.fHead = positionArray.length > 0 ? (XMLNode)positionArray[0] : null;
        }
        if ((n2 = n3) < 0) {
            ++n2;
        }
        this.fChanges = new LinkedList();
        this.fAdded = false;
        this.fDeleted = false;
        this.fModified = false;
        this.getDeleted(n2);
        this.getAdded(n2, positionArray);
        if (!(!this.fModified || this.fDeleted || this.fAdded || this.fChanges.size() != 1 || (string = (xMLNode = (XMLNode)this.fChanges.getFirst()).getType()) != "com.objfac.xmltext" && string != "com.objfac.xmlcomment")) {
            n2 = this.fPositions.length;
        }
        if (n2 < this.fPositions.length) {
            xMLNode = (XMLNode)this.fPositions[n2];
            while (xMLNode.parent != null) {
                xMLNode = xMLNode.parent;
            }
            n2 = 0;
            while (this.fPositions[n2] != xMLNode) {
                ++n2;
            }
            this.fixParents(iAbstractDocument, positionArray, n2, null);
        }
    }

    protected void getDeleted(int n) {
        boolean bl = false;
        int n2 = n;
        while (n2 < this.fPositions.length) {
            Position position = this.fPositions[n2];
            if (position.isDeleted()) {
                bl = true;
                this.fDeleted = true;
                this.fChanges.add(position);
            } else if (bl) break;
            ++n2;
        }
    }

    protected void getAdded(int n, Position[] positionArray) {
        boolean bl = false;
        int n2 = n;
        while (n2 < positionArray.length) {
            XMLNode xMLNode = (XMLNode)positionArray[n2];
            if (xMLNode.added || xMLNode.modified) {
                xMLNode.chain = null;
                xMLNode.attlist = null;
                xMLNode.attoffs = null;
                this.fAdded |= xMLNode.added;
                this.fModified |= xMLNode.modified;
                bl = true;
                xMLNode.modified = false;
                xMLNode.added = false;
                this.fChanges.add(xMLNode);
            } else if (bl) break;
            ++n2;
        }
    }

    protected void fixParents(IAbstractDocument iAbstractDocument, Position[] positionArray, int n, XMLNode xMLNode) {
        XMLNode xMLNode2 = null;
        int n2 = n;
        while (n2 < positionArray.length) {
            XMLNode xMLNode3 = (XMLNode)positionArray[n2];
            if (xMLNode != null) {
                this.addChild(xMLNode, xMLNode3);
            } else {
                if (xMLNode2 != null) {
                    xMLNode2.nextSibling = xMLNode3;
                }
                xMLNode2 = xMLNode3;
                xMLNode3.parent = null;
                xMLNode3.nextSibling = null;
            }
            xMLNode3.lastChild = null;
            xMLNode3.firstChild = null;
            block0 : switch (XMLConstants.getIntType(xMLNode3.getType())) {
                case 2: 
                case 17: {
                    xMLNode3.getQName(iAbstractDocument);
                    xMLNode = xMLNode3;
                    break;
                }
                case 4: {
                    String string = xMLNode3.getQName(iAbstractDocument);
                    XMLNode xMLNode4 = xMLNode;
                    while (xMLNode4 != null) {
                        String string2 = xMLNode4.getQName(iAbstractDocument);
                        int n3 = XMLConstants.getIntType(xMLNode4.getType());
                        if (string.equals(string2) && n3 == 2) {
                            xMLNode = xMLNode4.parent;
                            break block0;
                        }
                        if (fXMLRules) break block0;
                        xMLNode4 = xMLNode4.parent;
                    }
                    break;
                }
                case 18: {
                    XMLNode xMLNode4 = xMLNode;
                    while (xMLNode4 != null) {
                        int n4 = XMLConstants.getIntType(xMLNode4.getType());
                        if (n4 == 17) {
                            xMLNode = xMLNode4.parent;
                            break block0;
                        }
                        xMLNode4 = xMLNode4.parent;
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    protected boolean equivalent(XMLNode xMLNode, Position[] positionArray) {
        XMLNode xMLNode2 = xMLNode;
        int n = 0;
        while (n < positionArray.length) {
            if (xMLNode2 != positionArray[n]) {
                return false;
            }
            xMLNode2 = xMLNode2.next;
            xMLNode2.added = false;
            ++n;
        }
        return false;
    }

    protected void buildTree(IAbstractDocument iAbstractDocument, Position[] positionArray) {
        this.fIncremental = false;
        int n = positionArray.length;
        if (n > 0) {
            this.fHead = (XMLNode)positionArray[0];
            XMLNode xMLNode = null;
            int n2 = 0;
            while (n2 < positionArray.length) {
                XMLNode xMLNode2 = (XMLNode)positionArray[n2];
                xMLNode2.added = false;
                if (xMLNode != null) {
                    xMLNode.next = xMLNode2;
                }
                xMLNode = xMLNode2;
                ++n2;
            }
            this.fixParents(iAbstractDocument, positionArray, 0, null);
        }
    }

    protected void addChild(XMLNode xMLNode, XMLNode xMLNode2) {
        if (xMLNode != null) {
            if (xMLNode.lastChild == null) {
                xMLNode.firstChild = xMLNode.lastChild = xMLNode2;
            } else {
                xMLNode.lastChild.nextSibling = xMLNode2;
                xMLNode.lastChild = xMLNode2;
            }
        }
        xMLNode2.parent = xMLNode;
        xMLNode2.nextSibling = null;
    }

    public XMLNode getDoctype() {
        XMLNode xMLNode = this.fHead;
        while (xMLNode != null) {
            String string = xMLNode.getType();
            if (string == "com.objfac.xmldoctype" || string == "com.objfac.xmldoctypestart") {
                return xMLNode;
            }
            xMLNode = xMLNode.nextSibling;
        }
        return null;
    }

    public XMLNode getRoot() {
        XMLNode xMLNode = this.fHead;
        while (xMLNode != null) {
            String string = xMLNode.getType();
            if (string == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag") {
                return xMLNode;
            }
            xMLNode = xMLNode.nextSibling;
        }
        return null;
    }

    public XMLNode getXMLDecl() {
        if (this.fHead != null && this.fHead.getType() == "com.objfac.xmlxml") {
            return this.fHead;
        }
        return null;
    }

    public String getDoctypeContents(boolean bl) {
        String string = null;
        XMLNode xMLNode = this.getDoctype();
        if (!(xMLNode == null || bl && xMLNode.getType() != "com.objfac.xmldoctypestart")) {
            int n = xMLNode.getOffset();
            int n2 = n + xMLNode.getLength();
            if (xMLNode.getType() == "com.objfac.xmldoctypestart") {
                XMLNode xMLNode2 = xMLNode.lastChild;
                if (xMLNode2 != null) {
                    n2 = xMLNode2.getType() == "com.objfac.xmldoctypeend" ? xMLNode2.getOffset() : xMLNode2.getOffset() + xMLNode2.getLength();
                }
                try {
                    string = this.fDocument.get(n, n2 - n);
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
        return string;
    }
}

