/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moved;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorEditor {
    private Point fExtent;
    private Image fImage;
    private RGB fColorValue;
    private Color fColor;
    private Button fButton;

    public ColorEditor(Composite composite) {
        this.fButton = new Button(composite, 8);
        this.fExtent = this.computeImageSize((Control)composite);
        this.fImage = new Image((Device)composite.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gC = new GC((Drawable)this.fImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gC.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ColorEditor.this.fButton.getShell());
                colorDialog.setRGB(ColorEditor.this.fColorValue);
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    ColorEditor.this.fColorValue = rGB;
                    ColorEditor.this.updateColorImage();
                }
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColorEditor.this.fImage != null) {
                    ColorEditor.this.fImage.dispose();
                    ColorEditor.this.fImage = null;
                }
                if (ColorEditor.this.fColor != null) {
                    ColorEditor.this.fColor.dispose();
                    ColorEditor.this.fColor = null;
                }
            }
        });
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rGB) {
        this.fColorValue = rGB;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.fButton;
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gC = new GC((Drawable)this.fImage);
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        this.fColor = new Color((Device)display, this.fColorValue);
        gC.setBackground(this.fColor);
        gC.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gC.dispose();
        this.fButton.setImage(this.fImage);
    }

    protected Point computeImageSize(Control control) {
        GC gC = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }
}

