/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.SecuritySupport;

class FactoryFinder {
    private static boolean debug;
    private static Properties jaxpProperties;
    private static long lastModified;
    static /* synthetic */ Class class$0;

    static {
        jaxpProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getInstance().getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2) throws ConfigurationError {
        Class<?> clazz;
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader == null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("javax.xml.transform.FactoryFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classLoader = clazz2.getClassLoader();
        }
        FactoryFinder.dPrint("find factoryId=" + string);
        try {
            String string3 = securitySupport.getSystemProperty(string);
            if (string3 != null) {
                FactoryFinder.dPrint("found system property, value=" + string3);
                return FactoryFinder.newInstance(string3, classLoader, true);
            }
        }
        catch (SecurityException securityException) {}
        boolean bl = false;
        File file = null;
        try {
            object = securitySupport.getSystemProperty("java.home");
            String string4 = String.valueOf(object) + File.separator + "lib" + File.separator + "jaxp.properties";
            file = new File(string4);
            bl = securitySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            jaxpProperties = null;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("javax.xml.transform.FactoryFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        object = clazz;
        synchronized (clazz) {
            boolean bl2 = false;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = securitySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        jaxpProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = securitySupport.getLastModified(file);
                }
                if (bl2) {
                    jaxpProperties = new Properties();
                    FileInputStream fileInputStream = securitySupport.getFileInputStream(file);
                    jaxpProperties.load(fileInputStream);
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            if (jaxpProperties != null && (object = jaxpProperties.getProperty(string)) != null) {
                FactoryFinder.dPrint("found in jaxp.properties, value=" + (String)object);
                return FactoryFinder.newInstance((String)object, classLoader, true);
            }
            object = FactoryFinder.findJarServiceProvider(string);
            if (object != null) {
                return object;
            }
            if (string2 == null) {
                throw new ConfigurationError("Provider for " + string + " cannot be found", null);
            }
            FactoryFinder.dPrint("using fallback, value=" + string2);
            return FactoryFinder.newInstance(string2, classLoader, true);
        }
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("javax.xml.transform.FactoryFinder");
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                            }
                        }
                        clazz = (classLoader = clazz2.getClassLoader()) != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    throw classNotFoundException;
                }
            }
            Object obj = clazz.newInstance();
            FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.xml.transform.FactoryFinder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classLoader = clazz.getClassLoader();
                inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.xml.transform.FactoryFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classLoader = clazz.getClassLoader();
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        FactoryFinder.dPrint("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            FactoryFinder.dPrint("found in resource, value=" + string3);
            return FactoryFinder.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

