/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.prompts.view;

import aurora.ide.helpers.CompositeMapUtil;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class ViewNode {
    private CompositeMap cm;
    private String promptsCode;
    private Attribute att;
    private String promptPrefix = "";
    private String zhsPrompt;

    public ViewNode(CompositeMap map, Attribute attrib, String promptPrefix) {
        this.setCompositeMap(map);
        this.setAttribute(attrib);
        this.setPromptPrefix(promptPrefix);
        this.setPromptsCode(this.getDefaultPromptsCode(map));
        this.setZhsPrompt(this.getPromptAttribute());
    }

    private String getDefaultPromptsCode(CompositeMap map) {
        if ("".equals(this.promptPrefix)) {
            return this.getNameAttribute().toUpperCase();
        }
        return (String.valueOf(this.promptPrefix) + "." + this.getNameAttribute()).toUpperCase();
    }

    public String getPromptsCode() {
        return this.promptsCode;
    }

    public void setPromptsCode(String promptsCode) {
        this.promptsCode = promptsCode;
    }

    public CompositeMap getCompositeMap() {
        return this.cm;
    }

    public void setCompositeMap(CompositeMap cm) {
        this.cm = cm;
    }

    public String getElementRawName() {
        return this.cm.getRawName();
    }

    public String getNameAttribute() {
        return this.cm.getString((Object)"name", "NONE");
    }

    private String getPromptAttribute() {
        return CompositeMapUtil.getValueIgnoreCase((Attribute)this.att, (CompositeMap)this.cm);
    }

    public Attribute getAttribute() {
        return this.att;
    }

    public void setAttribute(Attribute att) {
        this.att = att;
    }

    private void setPromptPrefix(String promptPrefix) {
        this.promptPrefix = promptPrefix;
    }

    private void setPromptAttribute(String text) {
        this.cm.putString((Object)this.att.getName(), text);
    }

    public void applyCode() {
        this.setPromptAttribute(this.getPromptsCode());
    }

    private void removeKey() {
        Set keySet = this.cm.keySet();
        for (Object object : keySet) {
            if (!(object instanceof String) || !((String)object).equalsIgnoreCase(this.att.getName())) continue;
            this.cm.remove(object);
        }
    }

    public String getZhsPrompt() {
        return this.zhsPrompt;
    }

    public void setZhsPrompt(String zhsPrompt) {
        this.zhsPrompt = zhsPrompt;
    }
}

