/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.widgets;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.ListenerAppender;
import org.insightech.er.common.widgets.RowHeaderTable;
import org.insightech.er.common.widgets.SpinnerWithScale;

public class CompositeFactory {
    public static SpinnerWithScale createSpinnerWithScale(AbstractDialog dialog, Composite composite, String title, int minimum, int maximum) {
        return CompositeFactory.createSpinnerWithScale(dialog, composite, title, "%", minimum, maximum);
    }

    public static SpinnerWithScale createSpinnerWithScale(AbstractDialog dialog, Composite composite, String title, String unit, int minimum, int maximum) {
        if (title != null) {
            Label label = new Label(composite, 131072);
            label.setText(ResourceString.getResourceString(title));
        }
        GridData scaleGridData = new GridData();
        Scale scale = new Scale(composite, 0);
        scale.setLayoutData((Object)scaleGridData);
        int diff = 0;
        if (minimum < 0) {
            scale.setMinimum(0);
            scale.setMaximum(-minimum + maximum);
            diff = minimum;
        } else {
            scale.setMinimum(minimum);
            scale.setMaximum(maximum);
        }
        scale.setPageIncrement((maximum - minimum) / 10);
        GridData spinnerGridData = new GridData();
        Spinner spinner = new Spinner(composite, 133120);
        spinner.setLayoutData((Object)spinnerGridData);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        Label label = new Label(composite, 0);
        label.setText(unit);
        ListenerAppender.addModifyListener(scale, spinner, diff, dialog);
        return new SpinnerWithScale(spinner, scale, diff);
    }

    public static Combo createReadOnlyCombo(AbstractDialog dialog, Composite composite, String title) {
        return CompositeFactory.createReadOnlyCombo(dialog, composite, title, 1, -1);
    }

    public static Combo createReadOnlyCombo(AbstractDialog dialog, Composite composite, String title, int span, int width) {
        if (title != null) {
            Label label = new Label(composite, 131072);
            label.setText(ResourceString.getResourceString(title));
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        if (width > 0) {
            gridData.widthHint = width;
        } else {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gridData);
        ListenerAppender.addComboListener(combo, dialog, false);
        return combo;
    }

    public static Combo createCombo(AbstractDialog dialog, Composite composite, String title, int span) {
        if (title != null) {
            Label label = new Label(composite, 131072);
            label.setText(ResourceString.getResourceString(title));
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Combo combo = new Combo(composite, 0);
        combo.setLayoutData((Object)gridData);
        ListenerAppender.addComboListener(combo, dialog, false);
        return combo;
    }

    public static Combo createFileEncodingCombo(IEditorPart editorPart, AbstractDialog dialog, Composite composite, String title, int span) {
        Combo fileEncodingCombo = CompositeFactory.createReadOnlyCombo(dialog, composite, title, span, -1);
        for (Charset charset : Charset.availableCharsets().values()) {
            fileEncodingCombo.add(charset.displayName());
        }
        IFile file = ((IFileEditorInput)editorPart.getEditorInput()).getFile();
        IProject project = file.getProject();
        try {
            Charset defautlCharset = Charset.forName(project.getDefaultCharset());
            fileEncodingCombo.setText(defautlCharset.displayName());
        }
        catch (CoreException coreException) {}
        return fileEncodingCombo;
    }

    public static Text createText(AbstractDialog dialog, Composite composite, String title, boolean imeOn) {
        return CompositeFactory.createText(dialog, composite, title, 1, imeOn);
    }

    public static Text createText(AbstractDialog dialog, Composite composite, String title, int span, boolean imeOn) {
        return CompositeFactory.createText(dialog, composite, title, span, -1, imeOn);
    }

    public static Text createText(AbstractDialog dialog, Composite composite, String title, int span, int width, boolean imeOn) {
        return CompositeFactory.createText(dialog, composite, title, span, width, 2048, imeOn);
    }

    public static Text createNumText(AbstractDialog dialog, Composite composite, String title) {
        return CompositeFactory.createNumText(dialog, composite, title, -1);
    }

    public static Text createNumText(AbstractDialog dialog, Composite composite, String title, int width) {
        return CompositeFactory.createNumText(dialog, composite, title, 1, width);
    }

    public static Text createNumText(AbstractDialog dialog, Composite composite, String title, int span, int width) {
        return CompositeFactory.createText(dialog, composite, title, span, width, 133120, false);
    }

    public static Text createText(AbstractDialog dialog, Composite composite, String title, int span, int width, int style, boolean imeOn) {
        if (title != null) {
            Label label = new Label(composite, 0);
            label.setText(ResourceString.getResourceString(title));
        }
        GridData textGridData = new GridData();
        textGridData.horizontalSpan = span;
        if (width > 0) {
            textGridData.widthHint = width;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        }
        Text text = new Text(composite, style);
        text.setLayoutData((Object)textGridData);
        ListenerAppender.addTextListener(text, dialog, imeOn);
        return text;
    }

    public static Label createExampleLabel(Composite composite, String title) {
        return CompositeFactory.createExampleLabel(composite, title, -1);
    }

    public static Label createExampleLabel(Composite composite, String title, int span) {
        Label label = new Label(composite, 0);
        label.setText(ResourceString.getResourceString(title));
        if (span > 0) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = span;
            label.setLayoutData((Object)gridData);
        }
        FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
        Font font = new Font((Device)Display.getCurrent(), fontData.getName(), 8, 0);
        label.setFont(font);
        return label;
    }

    public static void filler(Composite composite, int span) {
        CompositeFactory.filler(composite, span, -1);
    }

    public static void filler(Composite composite, int span, int width) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        if (width > 0) {
            gridData.widthHint = width;
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
    }

    public static Label createLabel(Composite composite, String title) {
        return CompositeFactory.createLabel(composite, title, -1);
    }

    public static Label createLabel(Composite composite, String title, int span) {
        return CompositeFactory.createLabel(composite, title, span, -1);
    }

    public static Label createLabel(Composite composite, String title, int span, int width) {
        Label label = new Label(composite, 0);
        label.setText(ResourceString.getResourceString(title));
        if (span > 0 || width > 0) {
            GridData gridData = new GridData();
            if (span > 0) {
                gridData.horizontalSpan = span;
            }
            if (width > 0) {
                gridData.widthHint = width;
            }
            label.setLayoutData((Object)gridData);
        }
        return label;
    }

    public static Button createCheckbox(AbstractDialog dialog, Composite composite, String title) {
        return CompositeFactory.createCheckbox(dialog, composite, title, -1);
    }

    public static Button createCheckbox(AbstractDialog dialog, Composite composite, String title, int span) {
        Button checkbox = new Button(composite, 32);
        checkbox.setText(ResourceString.getResourceString(title));
        if (span != -1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = span;
            checkbox.setLayoutData((Object)gridData);
        }
        ListenerAppender.addCheckBoxListener(checkbox, dialog);
        return checkbox;
    }

    public static Button createRadio(AbstractDialog dialog, Composite composite, String title) {
        return CompositeFactory.createRadio(dialog, composite, title, -1);
    }

    public static Button createRadio(AbstractDialog dialog, Composite composite, String title, int span) {
        Button radio = new Button(composite, 16);
        radio.setText(ResourceString.getResourceString(title));
        if (span != -1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = span;
            radio.setLayoutData((Object)gridData);
        }
        ListenerAppender.addCheckBoxListener(radio, dialog);
        return radio;
    }

    public static Text createTextArea(AbstractDialog dialog, Composite composite, String title, int width, int height, int span, boolean selectAll, boolean imeOn) {
        if (title != null) {
            Label label = new Label(composite, 0);
            label.setText(ResourceString.getResourceString(title));
        }
        GridData textAreaGridData = new GridData();
        textAreaGridData.heightHint = height;
        textAreaGridData.grabExcessHorizontalSpace = true;
        textAreaGridData.horizontalSpan = span;
        textAreaGridData.horizontalAlignment = 4;
        textAreaGridData.widthHint = width;
        Text text = new Text(composite, 2626);
        text.setLayoutData((Object)textAreaGridData);
        ListenerAppender.addTextAreaListener(text, dialog, selectAll, imeOn);
        return text;
    }

    public static Text createTextArea(AbstractDialog dialog, Composite composite, String title, int width, int height, int span, boolean imeOn) {
        return CompositeFactory.createTextArea(dialog, composite, title, width, height, span, true, imeOn);
    }

    public static Table createTable(Composite composite, int height, int span) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.heightHint = height;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Table table = new Table(composite, 67588);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return table;
    }

    public static TableColumn createTableColumn(Table table, String text, int width, int style) {
        TableColumn tableColumn = new TableColumn(table, style);
        tableColumn.setText(ResourceString.getResourceString(text));
        tableColumn.setWidth(width);
        tableColumn.setAlignment(style);
        return tableColumn;
    }

    public static Button createButton(Composite composite, String text) {
        return CompositeFactory.createButton(composite, text, -1);
    }

    public static Button createButton(Composite composite, String text, int span) {
        GridData gridData = new GridData();
        if (span != -1) {
            gridData.horizontalSpan = span;
        } else {
            gridData.widthHint = 60;
        }
        Button button = new Button(composite, 0);
        button.setText(ResourceString.getResourceString(text));
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Button createAddButton(Composite composite) {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 3;
        gridData.widthHint = 60;
        Button button = new Button(composite, 0);
        button.setText(ResourceString.getResourceString("label.right.arrow"));
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Button createRemoveButton(Composite composite) {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.widthHint = 60;
        Button button = new Button(composite, 0);
        button.setText(ResourceString.getResourceString("label.left.arrow"));
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static TableEditor createCheckBoxTableEditor(TableItem tableItem, boolean selection, int column) {
        Table table = tableItem.getParent();
        Button checkBox = new Button((Composite)table, 32);
        checkBox.pack();
        TableEditor editor = new TableEditor(table);
        editor.minimumWidth = checkBox.getSize().x;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)checkBox, tableItem, column);
        checkBox.setSelection(selection);
        return editor;
    }

    public static RowHeaderTable createRowHeaderTable(Composite parent, int width, int height, int rowHeaderWidth, int rowHeight, int span, boolean iconEnable, boolean editable) {
        Composite composite = new Composite(parent, 0x1000000);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = height;
        composite.setLayoutData((Object)gridData);
        return CompositeFactory.createTable(composite, width, height, rowHeaderWidth, rowHeight, iconEnable, editable);
    }

    private static RowHeaderTable createTable(Composite composite, int width, int height, int rowHeaderWidth, int rowHeight, boolean iconEnable, boolean editable) {
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        frame.setLayout(new FlowLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        frame.add(panel);
        RowHeaderTable table = new RowHeaderTable(width, height, rowHeaderWidth, rowHeight, iconEnable, editable);
        panel.add(table);
        return table;
    }
}

