/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.sqlite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.insightech.er.db.DBManagerBase;
import org.insightech.er.db.impl.sqlite.SQLiteDDLCreator;
import org.insightech.er.db.impl.sqlite.SQLitePreTableExportManager;
import org.insightech.er.db.impl.sqlite.SQLitePreTableImportManager;
import org.insightech.er.db.impl.sqlite.SQLiteSqlTypeManager;
import org.insightech.er.db.impl.sqlite.SQLiteTableImportManager;
import org.insightech.er.db.impl.sqlite.SQLiteTableProperties;
import org.insightech.er.db.sqltype.SqlTypeManager;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.db.PreTableExportManager;
import org.insightech.er.editor.model.dbexport.ddl.DDLCreator;
import org.insightech.er.editor.model.dbimport.ImportFromDBManager;
import org.insightech.er.editor.model.dbimport.PreImportFromDBManager;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableProperties;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDBManager
extends DBManagerBase {
    public static final String ID = "SQLite";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    @Override
    protected String getURL() {
        return "jdbc:sqlite:<DB NAME>";
    }

    @Override
    public int getDefaultPort() {
        return 0;
    }

    @Override
    public SqlTypeManager getSqlTypeManager() {
        return new SQLiteSqlTypeManager();
    }

    @Override
    public TableProperties createTableProperties(TableProperties tableProperties) {
        if (tableProperties != null && tableProperties instanceof SQLiteTableProperties) {
            return tableProperties;
        }
        return new SQLiteTableProperties();
    }

    @Override
    public DDLCreator getDDLCreator(ERDiagram diagram, boolean semicolon) {
        return new SQLiteDDLCreator(diagram, semicolon);
    }

    @Override
    public List<String> getIndexTypeList(ERTable table) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("BTREE");
        return list;
    }

    @Override
    protected int[] getSupportItems() {
        int[] nArray = new int[2];
        nArray[0] = 4;
        return nArray;
    }

    @Override
    public ImportFromDBManager getTableImportManager() {
        return new SQLiteTableImportManager();
    }

    @Override
    public PreImportFromDBManager getPreTableImportManager() {
        return new SQLitePreTableImportManager();
    }

    @Override
    public PreTableExportManager getPreTableExportManager() {
        return new SQLitePreTableExportManager();
    }

    @Override
    public boolean doesNeedURLServerName() {
        return false;
    }

    @Override
    public TablespaceProperties createTablespaceProperties() {
        return null;
    }

    @Override
    public TablespaceProperties checkTablespaceProperties(TablespaceProperties tablespaceProperties) {
        return null;
    }

    @Override
    public String[] getCurrentTimeValue() {
        return new String[]{"CURRENT_TIMESTAMP"};
    }

    @Override
    public BigDecimal getSequenceMaxValue() {
        return BigDecimal.ZERO;
    }
}

