/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.insightech.er.Activator;
import org.insightech.er.editor.ERDiagramMultiPageEditor;

public class ERDiagramElementStateListener
implements IElementStateListener {
    private IDocumentProvider documentProvider;
    private ERDiagramMultiPageEditor editorPart;

    public ERDiagramElementStateListener(ERDiagramMultiPageEditor editorPart) {
        this.editorPart = editorPart;
        this.documentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(editorPart.getEditorInput());
        this.documentProvider.addElementStateListener((IElementStateListener)this);
        try {
            this.documentProvider.connect((Object)editorPart.getEditorInput());
        }
        catch (CoreException e) {
            Activator.showExceptionDialog(e);
        }
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
    }

    public void elementDeleted(Object deletedElement) {
        if (deletedElement != null && deletedElement.equals(this.editorPart.getEditorInput())) {
            Runnable r = new Runnable(){

                public void run() {
                    ERDiagramElementStateListener.this.close(false);
                }
            };
            this.execute(r, false);
        }
    }

    public void elementMoved(Object originalElement, final Object movedElement) {
        if (originalElement != null && originalElement.equals(this.editorPart.getEditorInput())) {
            final boolean doValidationAsync = Display.getCurrent() != null;
            Runnable r = new Runnable(){

                public void run() {
                    if (movedElement == null || movedElement instanceof IEditorInput) {
                        String previousContent;
                        IDocumentUndoManager previousUndoManager = null;
                        IDocument changed = null;
                        boolean wasDirty = ERDiagramElementStateListener.this.editorPart.isDirty();
                        changed = ERDiagramElementStateListener.this.documentProvider.getDocument((Object)ERDiagramElementStateListener.this.editorPart.getEditorInput());
                        if (changed != null) {
                            previousContent = wasDirty ? changed.get() : null;
                            previousUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)changed);
                            if (previousUndoManager != null) {
                                previousUndoManager.connect((Object)this);
                            }
                        } else {
                            previousContent = null;
                        }
                        ERDiagramElementStateListener.this.editorPart.setInputWithNotify((IEditorInput)movedElement);
                        if (previousUndoManager != null) {
                            IDocumentUndoManager newUndoManager;
                            IDocument newDocument = ERDiagramElementStateListener.this.documentProvider.getDocument(movedElement);
                            if (newDocument != null && (newUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)newDocument)) != null) {
                                newUndoManager.transferUndoHistory(previousUndoManager);
                            }
                            previousUndoManager.disconnect((Object)this);
                        }
                        if (wasDirty && changed != null) {
                            Runnable r2 = new Runnable(){

                                public void run() {
                                    ERDiagramElementStateListener.this.documentProvider.getDocument((Object)ERDiagramElementStateListener.this.editorPart.getEditorInput()).set(previousContent);
                                }
                            };
                            ERDiagramElementStateListener.this.execute(r2, doValidationAsync);
                        }
                    }
                }
            };
            this.execute(r, false);
        }
    }

    private void execute(Runnable runnable, boolean postAsync) {
        if (postAsync || Display.getCurrent() == null) {
            this.editorPart.getSite().getShell().getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void close(final boolean save) {
        Display display = this.editorPart.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ERDiagramElementStateListener.this.editorPart.getSite().getPage().closeEditor((IEditorPart)ERDiagramElementStateListener.this.editorPart, save);
            }
        });
    }

    protected void disposeDocumentProvider() {
        if (this.documentProvider != null) {
            IEditorInput input = this.editorPart.getEditorInput();
            if (input != null) {
                this.documentProvider.disconnect((Object)input);
            }
            this.documentProvider.removeElementStateListener((IElementStateListener)this);
        }
        this.documentProvider = null;
    }
}

