/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.common;

import org.insightech.er.editor.controller.command.AbstractCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.Settings;

public class ChangeOutlineViewModeCommand
extends AbstractCommand {
    private ERDiagram diagram;
    private int oldViewMode;
    private int newViewMode;
    private Settings settings;

    public ChangeOutlineViewModeCommand(ERDiagram diagram, int viewMode) {
        this.diagram = diagram;
        this.settings = this.diagram.getDiagramContents().getSettings();
        this.newViewMode = viewMode;
        this.oldViewMode = this.settings.getViewMode();
    }

    protected void doExecute() {
        this.settings.setOutlineViewMode(this.newViewMode);
        this.diagram.changeAll();
    }

    protected void doUndo() {
        this.settings.setOutlineViewMode(this.oldViewMode);
        this.diagram.changeAll();
    }
}

