/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation;

import org.eclipse.gef.EditPart;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.AbstractCreateRelationCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;

public class CreateSelfRelationCommand
extends AbstractCreateRelationCommand {
    private Relation relation;

    public CreateSelfRelationCommand(Relation relation) {
        this.relation = relation;
    }

    public void setSource(EditPart source) {
        this.source = source;
        this.target = source;
    }

    protected void doExecute() {
        ERDiagramEditPart.setUpdateable(false);
        boolean anotherSelfRelation = false;
        ERTable sourceTable = (ERTable)this.source.getModel();
        for (Relation otherRelation : sourceTable.getOutgoingRelations()) {
            if (otherRelation.getSource() != otherRelation.getTarget()) continue;
            anotherSelfRelation = true;
            break;
        }
        int rate = 0;
        rate = anotherSelfRelation ? 50 : 100;
        Bendpoint bendpoint0 = new Bendpoint(rate, rate);
        bendpoint0.setRelative(true);
        int xp = 100 - rate / 2;
        int yp = 100 - rate / 2;
        this.relation.setSourceLocationp(100, yp);
        this.relation.setTargetLocationp(xp, 100);
        this.relation.addBendpoint(0, bendpoint0);
        this.relation.setSource(sourceTable);
        ERDiagramEditPart.setUpdateable(true);
        this.relation.setTargetTableView((ERTable)this.target.getModel());
        sourceTable.setDirty();
    }

    protected void doUndo() {
        ERDiagramEditPart.setUpdateable(false);
        this.relation.setSource(null);
        ERDiagramEditPart.setUpdateable(true);
        this.relation.setTargetTableView(null);
        this.relation.removeBendpoint(0);
        ERTable targetTable = (ERTable)this.target.getModel();
        targetTable.setDirty();
    }

    public boolean canExecute() {
        return this.source != null && this.target != null;
    }
}

